<?php
if (!defined('ABSPATH')) exit;
/**
 * @package WccCf7Clio
 */

/**
 * Class WccCf7Clio_Forms.
 *
 * @since 1.2.0
 */
class WccCf7Clio_Forms {



    var $authtoken;

    var $accesstoken;
    var $id;
    var $authorization_code;
    var $client_id;
    var $client_secret;
    var $client_token;
    
    
    function __construct($array = array()) {
         
        if(!empty($array['id'])){
            $this->id = $array['id'];
        }
        if(!empty($array['authorization_code'])){
            $this->authorization_code = $array['authorization_code'];
        }
        if(!empty($array['client_id'])){
            $this->client_id = $array['client_id'];
        }
        if(!empty($array['client_secret'])){
            $this->client_secret = $array['client_secret'];
        }
        if(!empty($array['client_token'])){
            $this->client_token = $array['client_token'];
        }
        $this->accesstoken();
        
    }

    public function accesstoken() {

        $post = array(
            "client_id" => $this->client_id,
            "client_secret" => $this->client_secret,
            "grant_type" => "refresh_token",
            "refresh_token" => $this->authorization_code,
        );
        $reposnse = wp_remote_post(WccCf7Clio::$authTokenUrl,array(
                'headers' => array(
                    "Content-Type" => "application/x-www-form-urlencoded"
                ),
                "body"  => $post
            )
        );
        $reposnse     = json_decode( wp_remote_retrieve_body( $reposnse ),1);


        $token = "";

        if(!empty($reposnse['access_token'])){
            $token = $reposnse['access_token'];
        }
        $this->accesstoken = $token;
        return $token;
    }


    /**
     * Forms.
     *
     * @since 1.2.0
     * @access public
     */
    public function list() {
        global $wpdb;
        $forms = array();

        $cf7_db_version = get_option( 'cf7_db_version' );


        if ( $cf7_db_version && version_compare( $cf7_db_version, '2.3', '>=' ) ) {
            $table_name = $wpdb->prefix."gf_form";
            $forms = $wpdb->get_results( $wpdb->prepare('SELECT * FROM {$table_name} WHERE is_trash=%d',0) );
        } else {
            $table_name = $wpdb->prefix."rg_form";
            $forms = $wpdb->get_results( $wpdb->prepare('SELECT * FROM {$table_name} WHERE is_trash=%d',0) );
        }
        return $forms;
    }

    public function info( $id ) {
        global $wpdb;

        $cf7_db_version = get_option( 'cf7_db_version' );
        if ( $cf7_db_version && version_compare( $cf7_db_version, '2.3', '>=' ) ) {
            $table_name = $wpdb->prefix.'gf_form_meta';
            $form_meta = $wpdb->get_row( $wpdb->prepare('SELECT * FROM {$table_name} WHERE form_id=%d LIMIT 1',$id) );
        } else {
            $table_name = $wpdb->prefix.'rg_form_meta';
            $form_meta = $wpdb->get_row( $wpdb->prepare('SELECT * FROM {$table_name} WHERE form_id=%d LIMIT 1',$id) );
        }
        return $form_meta;
    }
    public function getModuleFields( $module = "" ) {
        if(!$module){
            $module = WccCf7Clio::$module;
        }
        $fields = array();

        
        if($this->accesstoken && $module == "contacts"){

            
            $fields["type"] = array(
                'label'     => "Type",
                'type'      => "Choice",  
                'required'  => 1,
                'choices'   => array(
                    array(
                        "id" => "Company",
                        "option" => "Company",
                    ),
                    array(
                        "id" => "Person",
                        "option" => "Person",
                    ),
                ),
            );

            $fields["addresses_name"] = array(
                'label'     => "Addresses Name",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["addresses_street"] = array(
                'label'     => "Addresses Street",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["addresses_city"] = array(
                'label'     => "Addresses City",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["addresses_province"] = array(
                'label'     => "Addresses Province",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["addresses_postal_code"] = array(
                'label'     => "Addresses Postal Code",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["addresses_country"] = array(
                'label'     => "Addresses Country",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["avatar_image"] = array(
                'label'     => "Avatar Image",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["avatar_destroy"] = array(
                'label'     => "Avatar Destroy",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["clio_connect_email"] = array(
                'label'     => "Clio Connect Email",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["co_counsel_rate"] = array(
                'label'     => "Co Counsel Rate",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["company_id"] = array(
                'label'     => "Company Id",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["custom_field_set_associations_display_order"] = array(
                'label'     => "Custom Field Set Associations Display Order",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["custom_field_set_associations_custom_field_set"] = array(
                'label'     => "Custom Field Set Associations Custom Field Set",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );
            $fields["date_of_birth"] = array(
                'label'     => "Date Of Birth",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );


            $fields["email_addresses_address"] = array(
                'label'     => "Email",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );
            $fields["email_addresses_name"] = array(
                'label'     => "Email Addresses Name",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["email_addresses_default_email"] = array(
                'label'     => "Email Addresses Default Email",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["first_name"] = array(
                'label'     => "First Name",
                'type'      => "String",  
                'required'  => 1,
                'choices'   => "",
            );

            $fields["instant_messengers_name"] = array(
                'label'     => "Instant Messengers Name",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["instant_messengers_address"] = array(
                'label'     => "Instant Messengers Address",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["last_name"] = array(
                'label'     => "Last Name",
                'type'      => "String",  
                'required'  => 1,
                'choices'   => "",
            );

            $fields["ledes_client_id"] = array(
                'label'     => "Ledes Client Id",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["middle_name"] = array(
                'label'     => "Middle Name",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["name"] = array(
                'label'     => "Name",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );


            $fields["prefix"] = array(
                'label'     => "Prefix",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["title"] = array(
                'label'     => "Title",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );


            $fields["web_sites_name"] = array(
                'label'     => "Web Sites Name",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["web_sites_address"] = array(
                'label'     => "Web Sites Address",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );

            $fields["web_sites_default_web_site"] = array(
                'label'     => "Web Sites Default Web Site",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );


        
            $header = array(                
                'X-API-VERSION' => WccCf7Clio::$wcc_cf7_clio_api_version,
                'Authorization' => 'Bearer '.$this->accesstoken,
                'Accept' => 'application/json',
            );
            
            $url = WccCf7Clio::$apiUrl."custom_fields.json?fields=id,name,field_type,required,picklist_options&parent_type=contact";

            $main_response = wp_remote_get($url,
                array(
                    'headers' => $header,
                )
            );

            $json_response = wp_remote_retrieve_body($main_response);
            $response = wp_json_encode($json_response,1);
            

            if(!empty($response['data'])){
                foreach ($response['data'] as $key => $value) {
                    $fields[$value['id']] = array(
                        'label'     => $value['name'],
                        'type'      => $value['field_type'],  
                        'required'  => 0,
                        'choices'   => isset($value['picklist_options']) ? $value['picklist_options'] : array(),
                    );
                }
            }

            
            if ( is_wp_error( $main_response ) ) {
                $status = wp_remote_retrieve_response_code( $main_response );
                $log = "Status: ".$status."\n";
                $log .= "Error: ".$json_response."\n";
                $log .= "Date: ".gmdate( 'Y-m-d H:i:s' )."\n\n";
                
                $send_to = get_option( 'wccc_cf7_clio_notification_send_to  ' );
                if ( $send_to ) {
                    $to = $send_to;
                    $subject = get_option( 'wccc_cf7_clio_notification_subject' );
                    $body = "Status: ".$status."<br>";
                    $body .= "Error: ".$json_response."<br>";
                    $body .= "Date: ".gmdate( 'Y-m-d H:i:s' );
                    $headers = array(
                        'Content-Type: text/html; charset=UTF-8',
                    );
                    wp_mail( $to, $subject, $body, $headers );
                }
                
                $wccc_cf7_clio_debug = get_option("wccc_cf7_clio_debug");
                $wccc_cf7_clio_debug .= $log."\n\n";
                update_option("wccc_cf7_clio_debug",$wccc_cf7_clio_debug);
            }

        
        }else{

            
            $fields["email"] = array(
                'label'     => "Email",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );
            $fields["first_name"] = array(
                'label'     => "First Name",
                'type'      => "String",  
                'required'  => 1,
                'choices'   => "",
            );
            $fields["from_message"] = array(
                'label'     => "From Message",
                'type'      => "String",  
                'required'  => 1,
                'choices'   => "",
            );
            $fields["from_source"] = array(
                'label'     => "From Source",
                'type'      => "String",  
                'required'  => 1,
                'choices'   => "",
            );
            $fields["last_name"] = array(
                'label'     => "Last Name",
                'type'      => "String",  
                'required'  => 1,
                'choices'   => "",
            );
            $fields["phone_number"] = array(
                'label'     => "Phone Number",
                'type'      => "String",  
                'required'  => 0,
                'choices'   => "",
            );
            $fields["referring_url"] = array(
                'label'     => "Referring URL",
                'type'      => "String",  
                'required'  => 1,
                'choices'   => "",
            );
            
        }

    
    
        return $fields;
    }
    
    function addRecord( $module, $data, $form_id ) {

        $token = $this->accesstoken;
        if(!$this->accesstoken){
            $token = $this->accesstoken();
        }
        
        if ( $module == 'leads' ) {
            

            $data_manage = $data_send;
            if(isset($data_send['email'])){
                $data['email'] = $data_send['email'];
                unset($data_manage['email']);
            }            
            $data_manage = $data_send;
            if(isset($data_send['first_name'])){
                $data['first_name'] = $data_send['first_name'];
                unset($data_manage['first_name']);
            }            
            $data_manage = $data_send;
            if(isset($data_send['from_message'])){
                $data['from_message'] = $data_send['from_message'];
                unset($data_manage['from_message']);
            }            
            $data_manage = $data_send;
            if(isset($data_send['from_source'])){
                $data['from_source'] = $data_send['from_source'];
                unset($data_manage['from_source']);
            }            
            $data_manage = $data_send;
            if(isset($data_send['last_name'])){
                $data['last_name'] = $data_send['last_name'];
                unset($data_manage['last_name']);
            }            
            $data_manage = $data_send;
            if(isset($data_send['phone_number'])){
                $data['phone_number'] = $data_send['phone_number'];
                unset($data_manage['phone_number']);
            }            
            $data_manage = $data_send;
            if(isset($data_send['referring_url'])){
                $data['referring_url'] = $data_send['referring_url'];
                unset($data_manage['referring_url']);
            }
        
            $header = array(
                'X-API-VERSION' => WccCf7Clio::$wcc_cf7_clio_api_version,
                'Authorization' => 'Bearer '.$this->client_token,
                'Content-Type' => 'application/json',
            );
        } else if ( $module == 'notes' ) {
            $data = array(
                'note'  => $data_send,
            );
        } else {

            $data_manage = $data_send;
            if(isset($data_send['addresses_name'])){
                $data['addresses'][0]['name'] = $data_send['addresses_name'];
                unset($data_manage['addresses_name']);
            }

            if(isset($data_send['addresses_street'])){
                $data['addresses'][0]['street'] = $data_send['addresses_street'];
                unset($data_manage['addresses_street']);
            }

            if(isset($data_send['addresses_city'])){
                $data['addresses'][0]['city'] = $data_send['addresses_city'];
                unset($data_manage['addresses_city']);
            }

            if(isset($data_send['addresses_province'])){
                $data['addresses'][0]['province'] = $data_send['addresses_province'];
                unset($data_manage['addresses_province']);
            }

            if(isset($data_send['addresses_postal_code'])){
                $data['addresses'][0]['postal_code'] = $data_send['addresses_postal_code'];
                unset($data_manage['addresses_postal_code']);
            }

            if(isset($data_send['addresses_country'])){
                $data['addresses'][0]['country'] = $data_send['addresses_country'];
                unset($data_manage['addresses_country']);
            }

            if(isset($data_send['avatar_image'])){
                $data['avatar']['image'] = $data_send['avatar_image'];
                unset($data_manage['avatar_image']);
            }

            if(isset($data_send['avatar_destroy'])){
                $data['avatar']['destroy'] = $data_send['avatar_destroy'];
                unset($data_manage['avatar_destroy']);
            }

            if(isset($data_send['clio_connect_email'])){
                $data['clio_connect_email'] = $data_send['clio_connect_email'];
                unset($data_manage['clio_connect_email']);
            }

            if(isset($data_send['co_counsel_rate'])){
                $data['co_counsel_rate'] = $data_send['co_counsel_rate'];
                unset($data_manage['co_counsel_rate']);
            }

            if(isset($data_send['company_id'])){
                $data['company']['id'] = $data_send['company_id'];
                unset($data_manage['company_id']);
            }

            if(isset($data_send['custom_field_set_associations_display_order'])){
                $data['custom_field_set_associations'][0]['display_order'] = $data_send['custom_field_set_associations_display_order'];
                unset($data_manage['custom_field_set_associations_display_order']);
            }

            if(isset($data_send['custom_field_set_associations_custom_field_set'])){
                $data['custom_field_set_associations'][0]['custom_field_set']['id'] = $data_send['custom_field_set_associations_custom_field_set'];
                unset($data_manage['custom_field_set_associations_custom_field_set']);
            }
            if(isset($data_send['date_of_birth'])){
                $data['date_of_birth'] = $data_send['date_of_birth'];
                unset($data_manage['date_of_birth']);
            }

            if(isset($data_send['email_addresses_name'])){
                $data['email_addresses'][0]['name'] = $data_send['email_addresses_name'];
                unset($data_manage['email_addresses_name']);
            }


            if(isset($data_send['email_addresses_default_email'])){
                $data['email_addresses'][0]['default_email'] = $data_send['email_addresses_default_email'];
                unset($data_manage['email_addresses_default_email']);
            }
            if(isset($data_send['email_addresses_address'])){

                if(!isset($data['email_addresses'][0]['name'])){
                    $data['email_addresses'][0]['name'] = "Work";
                }


                if(!isset($data['email_addresses'][0]['default_email'])){
                    $data['email_addresses'][0]['default_email'] = false;
                }

                $data['email_addresses'][0]['address'] = $data_send['email_addresses_address'];
                unset($data_manage['email_addresses_address']);
            }

            if(isset($data_send['first_name'])){
                $data['first_name'] = $data_send['first_name'];
                unset($data_manage['first_name']);
            }

            if(isset($data_send['instant_messengers_name'])){
                $data['instant_messengers'][0]['name'] = $data_send['instant_messengers_name'];
                unset($data_manage['instant_messengers_name']);
            }

            if(isset($data_send['instant_messengers_address'])){
                $data['instant_messengers'][0]['address'] = $data_send['instant_messengers_address'];
                unset($data_manage['instant_messengers_address']);
            }

            if(isset($data_send['last_name'])){
                $data['last_name'] = $data_send['last_name'];
                unset($data_manage['last_name']);
            }

            if(isset($data_send['ledes_client_id'])){
                $data['ledes_client_id'] = $data_send['ledes_client_id'];
                unset($data_manage['ledes_client_id']);
            }

            if(isset($data_send['middle_name'])){
                $data['middle_name'] = $data_send['middle_name'];
                unset($data_manage['middle_name']);
            }

            if(isset($data_send['name'])){
                $data['name'] = $data_send['name'];
                unset($data_manage['name']);
            }

            if(isset($data_send['phone_numbers_name'])){
                $data['phone_numbers'][0]['name'] = $data_send['phone_numbers_name'];
                unset($data_manage['phone_numbers_name']);
            }


            if(isset($data_send['phone_numbers_default_number'])){
                $data['phone_numbers'][0]['default_number'] = $data_send['phone_numbers_default_number'];
                unset($data_manage['phone_numbers_default_number']);
            }
            if(isset($data_send['phone_numbers_number'])){

                if(!isset($data['phone_numbers'][0]['name'])){
                    $data['emails'][0]['name'] = "Work";
                }


                if(!isset($data['phone_numbers'][0]['default_number'])){
                    $data['emails'][0]['default_number'] = false;
                }

                $data['phone_numbers'][0]['number'] = $data_send['phone_numbers_number'];
                unset($data_manage['phone_numbers_number']);
            }

            if(isset($data_send['prefix'])){
                $data['prefix'] = $data_send['prefix'];
                unset($data_manage['prefix']);
            }

            if(isset($data_send['title'])){
                $data['title'] = $data_send['title'];
                unset($data_manage['title']);
            }

            if(isset($data_send['type'])){
                $data['type'] = $data_send['type'];
                unset($data_manage['type']);
            }

            if(isset($data_send['web_sites_name'])){
                $data['web_sites'][0]['name'] = $data_send['web_sites_name'];
                unset($data_manage['web_sites_name']);
            }

            if(isset($data_send['web_sites_address'])){
                $data['web_sites'][0]['address'] = $data_send['web_sites_address'];
                unset($data_manage['web_sites_address']);
            }

            if(isset($data_send['web_sites_default_web_site'])){
                $data['web_sites'][0]['default_web_site'] = $data_send['web_sites_default_web_site'];
                unset($data_manage['web_sites_default_web_site']);
            }
            if($data_manage){
                $data['custom_fields'] = array();
                $field[] = "custom_fields";
                foreach ($data_manage as $key => $value) {
                    $data['custom_fields'][] = array(
                        "id" => $key,
                        "value" => $value,
                    );
                }
            }
            $header = array(
                'X-API-VERSION' => WccCf7Clio::$wcc_cf7_clio_api_version,
                'Authorization' => 'Bearer '.$token,
                'Content-Type' => 'application/json',
            );
        }

        if ( $module == 'leads' ) {

            $array = Array(
                'auth_token' => $this->client_token,
                'inbox_lead' => array(
                    'from_first' => isset($data['first_name']) ? $data['first_name'] : "",
                    'from_last' => isset($data['last_name']) ? $data['last_name'] : "",
                    'from_message' => isset($data['from_message']) ? $data['from_message'] : "",
                    'from_email' => isset($data['email']) ? $data['email'] : "",
                    'from_phone' => isset($data['phone_number']) ? $data['phone_number'] : "",
                    'from_source' => isset($data['from_source']) ? $data['from_source'] : "",
                    'referring_url' => isset($data['referring_url']) ? $data['referring_url'] : ""
                )
            );
            $data = wp_json_encode($array);

            $header = array(
                'Content-Type' => 'application/json;'
            );

            $response = wp_remote_post($url,$args);
            $url = "https://grow.clio.com/inbox_leads";

        }else{
            $url = WccCf7Clio::$apiUrl."contacts.json";
            $data =  array("data" => $data);
            $data = wp_json_encode($data);
        }


        $main_response = wp_remote_post($url,
            array(
                'headers' => $header,
                "body"  => $data
            )
        );

        $json_response = wp_remote_retrieve_body($main_response);
        $response = wp_json_encode($json_response,1);

        if ( is_wp_error( $main_response ) ) {
            $log = "Form ID: ".$form_id."\n";
            $log .= "Error: ".wp_json_encode( $main_response )."\n";
            $log .= "Date: ".gmdate( 'Y-m-d H:i:s' )."\n\n";
            
            $send_to = get_option( 'wccc_cf7_clio_notification_send_to	' );
            if ( $send_to ) {
                $to = $send_to;
                $subject = get_option( 'wccc_cf7_clio_notification_subject' );
                $body = "Form ID: ".$form_id."<br>";
                $body .= "Error: ".wp_json_encode( $main_response )."<br>";
                $body .= "Date: ".gmdate( 'Y-m-d H:i:s' );
                $headers = array(
                    'Content-Type: text/html; charset=UTF-8',
                );
                wp_mail( $to, $subject, $body, $headers );
            }
            
            
            $wccc_cf7_clio_debug = get_option("wccc_cf7_clio_debug");
            $wccc_cf7_clio_debug .= $log."\n\n";
            update_option("wccc_cf7_clio_debug",$wccc_cf7_clio_debug);
        }
        
        return $response;
    }
    
    function getRecords( $module, $email ) {

        
        $token = $this->accesstoken;
        if(!$this->accesstoken){
            $token = $this->accesstoken();
        }
       
        $header = array(
            'X-API-VERSION' => WccCf7Clio::$wcc_cf7_clio_api_version,
            'Authorization' => 'Bearer '.$token,
            'Content-Type' => 'application/json',
        );
        
        $url = WccCf7Clio::$apiUrl."contacts.json?query=".$email;


        $main_response = wp_remote_get($url,
            array(
                'headers' => $header,
            )
        );

        $json_response = wp_remote_retrieve_body($main_response);
        $response = json_decode($json_response,1);
        
        return isset($response['data']) ? $response : array();
    
    }
    
    function updateRecord( $module, $data, $record_id, $form_id ) {
        
        
        $token = $this->accesstoken;
        if(!$this->accesstoken){
            $token = $this->accesstoken();
        }
        if ( $module == 'leads' ) {
            $data = array(
                'lead'  => $data_send,
            );
        } else {

            $data_manage = $data_send;
            if(isset($data_send['addresses_name'])){
                $data['addresses'][0]['name'] = $data_send['addresses_name'];
                unset($data_manage['addresses_name']);
            }

            if(isset($data_send['addresses_street'])){
                $data['addresses'][0]['street'] = $data_send['addresses_street'];
                unset($data_manage['addresses_street']);
            }

            if(isset($data_send['addresses_city'])){
                $data['addresses'][0]['city'] = $data_send['addresses_city'];
                unset($data_manage['addresses_city']);
            }

            if(isset($data_send['addresses_province'])){
                $data['addresses'][0]['province'] = $data_send['addresses_province'];
                unset($data_manage['addresses_province']);
            }

            if(isset($data_send['addresses_postal_code'])){
                $data['addresses'][0]['postal_code'] = $data_send['addresses_postal_code'];
                unset($data_manage['addresses_postal_code']);
            }

            if(isset($data_send['addresses_country'])){
                $data['addresses'][0]['country'] = $data_send['addresses_country'];
                unset($data_manage['addresses_country']);
            }

            if(isset($data_send['avatar_image'])){
                $data['avatar']['image'] = $data_send['avatar_image'];
                unset($data_manage['avatar_image']);
            }

            if(isset($data_send['avatar_destroy'])){
                $data['avatar']['destroy'] = $data_send['avatar_destroy'];
                unset($data_manage['avatar_destroy']);
            }

            if(isset($data_send['clio_connect_email'])){
                $data['clio_connect_email'] = $data_send['clio_connect_email'];
                unset($data_manage['clio_connect_email']);
            }

            if(isset($data_send['co_counsel_rate'])){
                $data['co_counsel_rate'] = $data_send['co_counsel_rate'];
                unset($data_manage['co_counsel_rate']);
            }

            if(isset($data_send['company_id'])){
                $data['company']['id'] = $data_send['company_id'];
                unset($data_manage['company_id']);
            }

            if(isset($data_send['custom_field_set_associations_display_order'])){
                $data['custom_field_set_associations'][0]['display_order'] = $data_send['custom_field_set_associations_display_order'];
                unset($data_manage['custom_field_set_associations_display_order']);
            }

            if(isset($data_send['custom_field_set_associations_custom_field_set'])){
                $data['custom_field_set_associations'][0]['custom_field_set']['id'] = $data_send['custom_field_set_associations_custom_field_set'];
                unset($data_manage['custom_field_set_associations_custom_field_set']);
            }
            if(isset($data_send['date_of_birth'])){
                $data['date_of_birth'] = $data_send['date_of_birth'];
                unset($data_manage['date_of_birth']);
            }

            if(isset($data_send['email_addresses_name'])){
                $data['email_addresses'][0]['name'] = $data_send['email_addresses_name'];
                unset($data_manage['email_addresses_name']);
            }


            if(isset($data_send['email_addresses_default_email'])){
                $data['email_addresses'][0]['default_email'] = $data_send['email_addresses_default_email'];
                unset($data_manage['email_addresses_default_email']);
            }
            if(isset($data_send['email_addresses_address'])){

                if(!isset($data['email_addresses'][0]['name'])){
                    $data['email_addresses'][0]['name'] = "Work";
                }


                if(!isset($data['email_addresses'][0]['default_email'])){
                    $data['email_addresses'][0]['default_email'] = false;
                }

                $data['email_addresses'][0]['address'] = $data_send['email_addresses_address'];
                unset($data_manage['email_addresses_address']);
            }

            if(isset($data_send['first_name'])){
                $data['first_name'] = $data_send['first_name'];
                unset($data_manage['first_name']);
            }

            if(isset($data_send['instant_messengers_name'])){
                $data['instant_messengers'][0]['name'] = $data_send['instant_messengers_name'];
                unset($data_manage['instant_messengers_name']);
            }

            if(isset($data_send['instant_messengers_address'])){
                $data['instant_messengers'][0]['address'] = $data_send['instant_messengers_address'];
                unset($data_manage['instant_messengers_address']);
            }

            if(isset($data_send['last_name'])){
                $data['last_name'] = $data_send['last_name'];
                unset($data_manage['last_name']);
            }

            if(isset($data_send['ledes_client_id'])){
                $data['ledes_client_id'] = $data_send['ledes_client_id'];
                unset($data_manage['ledes_client_id']);
            }

            if(isset($data_send['middle_name'])){
                $data['middle_name'] = $data_send['middle_name'];
                unset($data_manage['middle_name']);
            }

            if(isset($data_send['name'])){
                $data['name'] = $data_send['name'];
                unset($data_manage['name']);
            }

            if(isset($data_send['phone_numbers_name'])){
                $data['phone_numbers'][0]['name'] = $data_send['phone_numbers_name'];
                unset($data_manage['phone_numbers_name']);
            }


            if(isset($data_send['phone_numbers_default_number'])){
                $data['phone_numbers'][0]['default_number'] = $data_send['phone_numbers_default_number'];
                unset($data_manage['phone_numbers_default_number']);
            }
            if(isset($data_send['phone_numbers_number'])){

                if(!isset($data['phone_numbers'][0]['name'])){
                    $data['emails'][0]['name'] = "Work";
                }


                if(!isset($data['phone_numbers'][0]['default_number'])){
                    $data['emails'][0]['default_number'] = false;
                }

                $data['phone_numbers'][0]['number'] = $data_send['phone_numbers_number'];
                unset($data_manage['phone_numbers_number']);
            }

            if(isset($data_send['prefix'])){
                $data['prefix'] = $data_send['prefix'];
                unset($data_manage['prefix']);
            }

            if(isset($data_send['title'])){
                $data['title'] = $data_send['title'];
                unset($data_manage['title']);
            }

            if(isset($data_send['type'])){
                $data['type'] = $data_send['type'];
                unset($data_manage['type']);
            }

            if(isset($data_send['web_sites_name'])){
                $data['web_sites'][0]['name'] = $data_send['web_sites_name'];
                unset($data_manage['web_sites_name']);
            }

            if(isset($data_send['web_sites_address'])){
                $data['web_sites'][0]['address'] = $data_send['web_sites_address'];
                unset($data_manage['web_sites_address']);
            }

            if(isset($data_send['web_sites_default_web_site'])){
                $data['web_sites'][0]['default_web_site'] = $data_send['web_sites_default_web_site'];
                unset($data_manage['web_sites_default_web_site']);
            }
            if($data_manage){
                $data['custom_fields'] = array();
                $field[] = "custom_fields";
                foreach ($data_manage as $key => $value) {
                    $data['custom_fields'][] = array(
                        "id" => $key,
                        "value" => $value,
                    );
                }
            }      
        
        }
       
        $header = array(
            'X-API-VERSION' => WccCf7Clio::$wcc_cf7_clio_api_version,
            'Authorization' => 'Bearer '.$token,
            'Content-Type' => 'application/json',
        );
        
        $url = WccCf7Clio::$apiUrl."contacts/".$record_id.".json";

        $data =  array("data" => $data);
        $data = wp_json_encode($data);

        $main_response = wp_remote_request($url,
            array(
                'method'     => 'PATCH',
                'headers' => $header,
                "body"  => $data
            )
        );

        $json_response = wp_remote_retrieve_body($main_response);
        $response = json_decode($json_response,1);
        
        if ( is_wp_error( $main_response ) ) {
            $log = "Form ID: ".$form_id."\n";
            $log .= "Error: ".wp_json_encode( $main_response )."\n";
            $log .= "Date: ".gmdate( 'Y-m-d H:i:s' )."\n\n";
            
            $send_to = get_option( 'wccc_cf7_clio_notification_send_to	' );
            if ( $send_to ) {
                $to = $send_to;
                $subject = get_option( 'wccc_cf7_clio_notification_subject' );
                $body = "Form ID: ".$form_id."<br>";
                $body .= "Error: ".wp_json_encode( $main_response )."<br>";
                $body .= "Date: ".gmdate( 'Y-m-d H:i:s' );
                $headers = array(
                    'Content-Type: text/html; charset=UTF-8',
                );
                wp_mail( $to, $subject, $body, $headers );
            }
            
            
            $wccc_cf7_clio_debug = get_option("wccc_cf7_clio_debug");
            $wccc_cf7_clio_debug .= $log."\n\n";
            update_option("wccc_cf7_clio_debug",$wccc_cf7_clio_debug);
        }
        
        return $response;
    
    }
    
    function addFile( $data, $form_id ) {
     
        $header = array(
            'Authorization' => 'Token token='.$this->key,
            'Content-Type' => 'multipart/form-data',
            'content-type' => 'multipart/form-data; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW',
        );


        
        if ( strpos( $this->url, 'freshsales.io' ) !== false ) {
            $url = $this->url.'/api/documents';
        } else {
            $url = $this->url.'/crm/sales/api/documents';
        }
       
        $data = wp_json_encode($data);

        $main_response = wp_remote_post($url,
            array(
                'headers' => $header,
                "body"  => $data
            )
        );


        $json_response = wp_remote_retrieve_body($main_response);
        $response = json_decode($json_response,1);

         
        if ( is_wp_error( $main_response ) ) {
            $log = "Form ID: ".$form_id."\n";
            $log .= "Error: ".wp_json_encode( $main_response )."\n";
            $log .= "Date: ".gmdate( 'Y-m-d H:i:s' )."\n\n";
            
            $send_to = get_option( 'wccc_cf7_clio_notification_send_to	' );
            if ( $send_to ) {
                $to = $send_to;
                $subject = get_option( 'wccc_cf7_clio_notification_subject' );
                $body = "Form ID: ".$form_id."<br>";
                $body .= "Error: ".wp_json_encode( $main_response )."<br>";
                $body .= "Date: ".gmdate( 'Y-m-d H:i:s' );
                $headers = array(
                    'Content-Type: text/html; charset=UTF-8',
                );
                wp_mail( $to, $subject, $body, $headers );
            }
            
            $wccc_cf7_clio_debug = get_option("wccc_cf7_clio_debug");
            $wccc_cf7_clio_debug .= $log."\n\n";
            update_option("wccc_cf7_clio_debug",$wccc_cf7_clio_debug);
        }
        
        
        return $response;
    }
}