<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://thetechpad.com/
 * @since      1.0.0
 *
 * @package    Message_AlertsForWoocommerce
 * @subpackage Message_AlertsForWoocommerce/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Message_AlertsForWoocommerce
 * @subpackage Message_AlertsForWoocommerce/public
 * @author     Example Author <info@example.com/>
 */
class Message_AlertsForWoocommerce_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $message_alerts_for_woocommerce    The ID of this plugin.
	 */
	private $message_alerts_for_woocommerce;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $message_alerts_for_woocommerce       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $message_alerts_for_woocommerce, $version ) {
		$this->message_alerts_for_woocommerce = $message_alerts_for_woocommerce;
		$this->version = $version;

		add_action('woocommerce_checkout_order_processed', array($this,'message_alerts_for_woocommerce_send_whatsapp_notification'));
		add_action('woocommerce_order_status_changed', array($this,'message_alerts_for_woocommerce_send_whatsapp_notification_status'));
	}

	function message_alerts_for_woocommerce_send_whatsapp_notification($order_id) {
		if(!empty(get_option('message_alerts_for_woocommerce_status')) && get_option('message_alerts_for_woocommerce_status') == '1') {
			$order = wc_get_order( $order_id );
			$message = $this->getOrderConfirmMessage($order);
			Message_AlertsForWoocommerce_Thetechpad::sendMessage('+'.Message_AlertsForWoocommerce_Thetechpad::getCountryCallingCode($order->data['billing']['country']).$order->data['billing']['phone'], $message);
			$this->sendMessageToAdmin($message);
		}
	}

	function getOrderConfirmMessage($order) {
		$order = wc_get_order( $order );
		$message = "Hi ".$order->data['billing']['first_name'].", thank you for placing order - ".$order->ID." with us. Below are your order details:\n";
		foreach ( $order->get_items() as $item_id => $item ) {
			$message .= $item->get_name()."(".$item->get_quantity().") - ".$order->get_currency()." ".number_format($item->get_total(),2,'.')."\n";
		}
		$message .= "Total : ".$order->get_currency()." ".$order->get_total();
		return $this->appendPrefixSuffix($message);
	}

	function appendPrefixSuffix($message) {
		$prefix = get_option('message_alerts_for_woocommerce_message_prefix');
		$suffix = get_option('message_alerts_for_woocommerce_message_suffix');
		if(!empty($prefix)) {
			$message = $prefix."\n".$message;
		}
		if(!empty($suffix)) {
			$message = $message."\n".$suffix;
		}
		return $message;
	}

	function sendMessageToAdmin($message) {
		$sendAdminNotice = get_option('message_alerts_for_woocommerce_send_admin_notice');
		if(!empty($sendAdminNotice) && $sendAdminNotice == '1') {
			$adminNums = get_option('message_alerts_for_woocommerce_admin_nums');
			if(!empty($adminNums)) {
				$adminNumArr = explode(',',$adminNums);
				foreach($adminNumArr as $num) {
					Message_AlertsForWoocommerce_Thetechpad::sendMessage($num, $message);
				}
			}
		}
	}

	function message_alerts_for_woocommerce_send_whatsapp_notification_status( $order_id ){
		if(!empty(get_option('message_alerts_for_woocommerce_status')) && get_option('message_alerts_for_woocommerce_status') == '1') {
			$order = wc_get_order( $order_id );
			$message = $this->appendPrefixSuffix('Hi '.$order->data['billing']['first_name'].', the status of your order - '.$order->ID.' has been updated to '.$order->data['status'].'.');
			Message_AlertsForWoocommerce_Thetechpad::sendMessage('+'.Message_AlertsForWoocommerce_Thetechpad::getCountryCallingCode($order->data['billing']['country']).$order->data['billing']['phone'],$message);
			$this->sendMessageToAdmin($message);
		}
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Message_AlertsForWoocommerce_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Message_AlertsForWoocommerce_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->message_alerts_for_woocommerce, plugin_dir_url( __FILE__ ) . 'css/message-alerts-for-woocommerce-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Message_AlertsForWoocommerce_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Message_AlertsForWoocommerce_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->message_alerts_for_woocommerce, plugin_dir_url( __FILE__ ) . 'js/message-alerts-for-woocommerce-public.js', array( 'jquery' ), $this->version, false );

	}

}
