<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://thetechpad.com/
 * @since             1.0.0
 * @package           MessageAlertsForWoocommerce
 *
 * @wordpress-plugin
 * Plugin Name:       Message Alerts For WooCommerce
 * Plugin URI:        https://thetechpad.com/message-alerts-for-woocommerce/
 * Description:       Send automated whatsapp messages on woocommerce order status updates.
 * Version:           1.0.0
 * Author:            The Tech Pad
 * Author URI:        https://thetechpad.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       message-alerts-for-woocommerce
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'message_alerts_for_woocommerce_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-message-alerts-for-woocommerce-activator.php
 */
function activate_message_alerts_for_woocommerce() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-message-alerts-for-woocommerce-activator.php';
	Message_AlertsForWoocommerce_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-message-alerts-for-woocommerce-deactivator.php
 */
function deactivate_message_alerts_for_woocommerce() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-message-alerts-for-woocommerce-deactivator.php';
	Message_AlertsForWoocommerce_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_message_alerts_for_woocommerce' );
register_deactivation_hook( __FILE__, 'deactivate_message_alerts_for_woocommerce' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-message-alerts-for-woocommerce.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_message_alerts_for_woocommerce() {

	$plugin = new Message_AlertsForWoocommerce();
	$plugin->run();

}
run_message_alerts_for_woocommerce();
