<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://thetechpad.com/
 * @since      1.0.0
 *
 * @package    Message_AlertsForWoocommerce
 * @subpackage Message_AlertsForWoocommerce/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Message_AlertsForWoocommerce
 * @subpackage Message_AlertsForWoocommerce/includes
 * @author     Example Author <info@example.com>
 */
class Message_AlertsForWoocommerce_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'message-alerts-for-woocommerce',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
