<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://thetechpad.com/
 * @since      1.0.0
 *
 * @package    Message_AlertsForWoocommerce
 * @subpackage Message_AlertsForWoocommerce/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Message_AlertsForWoocommerce
 * @subpackage Message_AlertsForWoocommerce/admin
 * @author     Example Author <info@example.com>
 */
class Message_AlertsForWoocommerce_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $message_alerts_for_woocommerce    The ID of this plugin.
	 */
	private $message_alerts_for_woocommerce;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $message_alerts_for_woocommerce       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $message_alerts_for_woocommerce, $version ) {
		$this->message_alerts_for_woocommerce = $message_alerts_for_woocommerce;
		$this->version = $version;
		add_action( 'admin_init',  array($this,'message_alerts_for_woocommerce_register_setting'));
		add_action( 'admin_menu', array($this,'message_alerts_for_woocommerce_menu_page'));
	}

	function message_alerts_for_woocommerce_menu_page() {
		add_menu_page(
			'Message Alerts For Woocommerce Settings',
			'Message Alerts For Woocommerce Settings',
			'manage_options',
			'messagealertsforwoocommerce-settings',
			array($this,'message_alerts_for_woocommerce_settings_content'),
			'dashicons-star-half',
			60
		);
	}
	function message_alerts_for_woocommerce_settings_content(){
		echo '<div class="wrap">
				<h1>Message Alerts For Woocommerce Settings</h1>
				<form method="post" action="options.php">';
					settings_fields( 'message_alerts_for_woocommerce_settings' );
					do_settings_sections( 'message-alerts-for-woocommerce-slug' );
					submit_button();
			echo '</form></div>';
	}

	function message_alerts_for_woocommerce_register_setting(){
		register_setting(
			'message_alerts_for_woocommerce_settings',
			'message_alerts_for_woocommerce_status',
			'sanitize_text_field'
		);
		register_setting(
			'message_alerts_for_woocommerce_settings',
			'message_alerts_for_woocommerce_thetechpad_api_key',
			'sanitize_text_field'
		);
		register_setting(
			'message_alerts_for_woocommerce_settings',
			'message_alerts_for_woocommerce_thetechpad_device_key',
			'sanitize_text_field'
		);
		register_setting(
			'message_alerts_for_woocommerce_settings',
			'message_alerts_for_woocommerce_message_prefix',
			'sanitize_text_field'
		);
		register_setting(
			'message_alerts_for_woocommerce_settings',
			'message_alerts_for_woocommerce_message_suffix',
			'sanitize_text_field'
		);
		register_setting(
			'message_alerts_for_woocommerce_settings',
			'message_alerts_for_woocommerce_admin_nums',
			'sanitize_text_field'
		);
		register_setting(
			'message_alerts_for_woocommerce_settings',
			'message_alerts_for_woocommerce_send_admin_notice',
			'sanitize_text_field'
		);
		add_settings_section(
			'message_alerts_for_woocommerce_settings_section_id',
			'', // title (if needed)
			'', // callback function (if needed)
			'message-alerts-for-woocommerce-slug' // page slug
		);
		add_settings_field(
			'message_alerts_for_woocommerce_thetechpad_api_key',
			'Thetechpad API Key',
			array($this,'message_alerts_for_woocommerce_text_field_html'), // function which prints the field
			'message-alerts-for-woocommerce-slug', // page slug
			'message_alerts_for_woocommerce_settings_section_id', // section ID
			array( 
				'label_for' => 'message_alerts_for_woocommerce_thetechpad_api_key',
				'class' => 'messagealertsforwoocommerce-class', // for <tr> element
			)
		);
		add_settings_field(
			'message_alerts_for_woocommerce_thetechpad_device_key',
			'Thetechpad Device ID',
			array($this,'message_alerts_for_woocommerce_device_id_field_html'), // function which prints the field
			'message-alerts-for-woocommerce-slug', // page slug
			'message_alerts_for_woocommerce_settings_section_id', // section ID
			array( 
				'label_for' => 'message_alerts_for_woocommerce_thetechpad_device_key',
				'class' => 'messagealertsforwoocommerce-class', // for <tr> element
			)
		);
		add_settings_field(
			'message_alerts_for_woocommerce_message_prefix',
			'Message Prefix',
			array($this,'message_alerts_for_woocommerce_prefix_field_html'), // function which prints the field
			'message-alerts-for-woocommerce-slug', // page slug
			'message_alerts_for_woocommerce_settings_section_id', // section ID
			array( 
				'label_for' => 'message_alerts_for_woocommerce_message_prefix',
				'class' => 'messagealertsforwoocommerce-class', // for <tr> element
			)
		);
		add_settings_field(
			'message_alerts_for_woocommerce_message_suffix',
			'Message Suffix',
			array($this,'message_alerts_for_woocommerce_suffix_field_html'), // function which prints the field
			'message-alerts-for-woocommerce-slug', // page slug
			'message_alerts_for_woocommerce_settings_section_id', // section ID
			array( 
				'label_for' => 'message_alerts_for_woocommerce_message_suffix',
				'class' => 'messagealertsforwoocommerce-class', // for <tr> element
			)
		);
		add_settings_field(
			'message_alerts_for_woocommerce_admin_nums',
			'Comma separated Admin Numbers with country code (+91xxxxxxxxxx,+91xxxxxxxxxx)',
			array($this,'message_alerts_for_woocommerce_admin_num_field_html'), // function which prints the field
			'message-alerts-for-woocommerce-slug', // page slug
			'message_alerts_for_woocommerce_settings_section_id', // section ID
			array( 
				'label_for' => 'message_alerts_for_woocommerce_admin_nums',
				'class' => 'messagealertsforwoocommerce-class', // for <tr> element
			)
		);
		add_settings_field(
			'message_alerts_for_woocommerce_send_admin_notice',
			'Send Notifications to Admin',
			array($this,'message_alerts_for_woocommerce_send_admin_notice_field_html'), // function which prints the field
			'message-alerts-for-woocommerce-slug', // page slug
			'message_alerts_for_woocommerce_settings_section_id', // section ID
			array( 
				'label_for' => 'message_alerts_for_woocommerce_send_admin_notice',
				'class' => 'messagealertsforwoocommerce-class', // for <tr> element
			)
		);
		add_settings_field(
			'message_alerts_for_woocommerce_status',
			'Message Alerts For Woocommerce Status',
			array($this,'message_alerts_for_woocommerce_status_field_html'), // function which prints the field
			'message-alerts-for-woocommerce-slug', // page slug
			'message_alerts_for_woocommerce_settings_section_id', // section ID
			array( 
				'label_for' => 'message_alerts_for_woocommerce_status',
				'class' => 'messagealertsforwoocommerce-class', // for <tr> element
			)
		);
	}

	function message_alerts_for_woocommerce_text_field_html(){
		$text = get_option( 'message_alerts_for_woocommerce_thetechpad_api_key' );
		printf(
			'<input type="text" id="message_alerts_for_woocommerce_thetechpad_api_key" name="message_alerts_for_woocommerce_thetechpad_api_key" value="%s" />
			<div class="tooltip">
				<span class="dashicons dashicons-info"></span>
				<span class="tooltiptext">You can find the API keys <a target="_blank" href="https://app.thetechpad.com/apikeys">here</a></span>
			</div>',
			esc_attr( $text )
		);
	}

	function message_alerts_for_woocommerce_device_id_field_html(){
		$text = get_option( 'message_alerts_for_woocommerce_thetechpad_device_key' );
		printf(
			'<input type="text" id="message_alerts_for_woocommerce_thetechpad_device_key" name="message_alerts_for_woocommerce_thetechpad_device_key" value="%s" />
			<div class="tooltip">
				<span class="dashicons dashicons-info"></span>
				<span class="tooltiptext">You can find the Device IDs <a target="_blank" href="https://app.thetechpad.com/devices">here</a> by clicking on the preferred device and copy the ID from resulting page.</span>
			</div>',
			esc_attr( $text )
		);
	}

	function message_alerts_for_woocommerce_prefix_field_html(){
		$text = get_option( 'message_alerts_for_woocommerce_message_prefix' );
		printf(
			'<input type="text" id="message_alerts_for_woocommerce_message_prefix" name="message_alerts_for_woocommerce_message_prefix" value="%s" />
			<div class="tooltip">
				<span class="dashicons dashicons-info"></span>
				<span class="tooltiptext">This text will be added as first line of the message.</span>
			</div>',
			esc_attr( $text )
		);
	}

	function message_alerts_for_woocommerce_suffix_field_html(){
		$text = get_option( 'message_alerts_for_woocommerce_message_suffix' );
		printf(
			'<input type="text" id="message_alerts_for_woocommerce_message_suffix" name="message_alerts_for_woocommerce_message_suffix" value="%s" />
			<div class="tooltip">
				<span class="dashicons dashicons-info"></span>
				<span class="tooltiptext">This text will be added as last line of the message.</span>
			</div>',
			esc_attr( $text )
		);
	}

	function message_alerts_for_woocommerce_admin_num_field_html(){
		$text = get_option( 'message_alerts_for_woocommerce_admin_nums' );
		printf(
			'<input type="text" id="message_alerts_for_woocommerce_admin_nums" name="message_alerts_for_woocommerce_admin_nums" value="%s" />',
			esc_attr( $text )
		);
	}

	function message_alerts_for_woocommerce_send_admin_notice_field_html(){
		$text = get_option( 'message_alerts_for_woocommerce_send_admin_notice' );
		echo '<select id="message_alerts_for_woocommerce_send_admin_notice" name="message_alerts_for_woocommerce_send_admin_notice">
				<option '.($text == 1 ? "selected" : "").' value="1">Yes</option>
				<option '.($text == 0 ? "selected" : "").' value="0">No</option>
			</select>';
	}

	function message_alerts_for_woocommerce_status_field_html(){
		$text = get_option( 'message_alerts_for_woocommerce_status' );
		echo '<select id="message_alerts_for_woocommerce_status" name="message_alerts_for_woocommerce_status">
				<option '.($text == 1 ? "selected" : "").' value="1">Active</option>
				<option '.($text == 0 ? "selected" : "").' value="0">Inactive</option>
			</select>';
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Message_AlertsForWoocommerce_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Message_AlertsForWoocommerce_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->message_alerts_for_woocommerce, plugin_dir_url( __FILE__ ) . 'css/message-alerts-for-woocommerce-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Message_AlertsForWoocommerce_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Message_AlertsForWoocommerce_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->message_alerts_for_woocommerce, plugin_dir_url( __FILE__ ) . 'js/message-alerts-for-woocommerce-admin.js', array( 'jquery' ), $this->version, false );

	}

}
