# Installment Calculator for WooCommerce

Installment Calculator is a lightweight and free WordPress plugin that allows store owners to display installment payment information on WooCommerce product pages in a purely informational way.

## Features ##

The plugin automatically takes the current product price and calculates installment values based on the number of installments and extra charge percentage defined by the admin. This helps customers clearly understand how much they would pay per installment before reaching checkout.

No payment gateway integration, no checkout modifications — just clear and simple installment information.

* Displays installment payment information on WooCommerce product pages
* Uses the current product price automatically
* Admin can define:
* Number of installments
* Extra charge percentage
* Calculates installment amounts dynamically
* Informational only (does not affect checkout or order totals)
* Simple setup and easy to use
* Lightweight and performance-friendly
* Compatible with all WooCommerce themes
* No external APIs or third-party services required

## Requirements ##

- PHP 8.0 or higher
- [WooCommerce Plugin](https://wordpress.org/plugins/woocommerce/)


## Installation from WP repository

You can download the plugin from the WordPress repository:
[https://wordpress.org/plugins/wc-installment-calculator/](https://wordpress.org/plugins/wc-installment-calculator/)

Or, you can install it from your WordPress using the plugin search,


## Installation from Github

**1. Clone Repository**

```bash
git clone git@github.com:LetsGoDev-com/wc-installment-calculator.git
```

**2. Download dependences**
```bash
composer install
```

## Available Languages ##

* English
* Spanish


## Changelog ##
#### 1.0.1 ####
* The beginning


## FAQ ##

####  Does it work with taxes? ####
* Yes!, it works with taxes

#### Does it work on variable products? ####
* Yes!, it works with variable products

#### Is this a payment method? ####
* No.

#### Can I use this plugin to set fees on payment gateways? ####
* No, this plugin is for informational purposes only; fees are handled by each individual payment gateway.

## Contributing ##

* [Alexander](https://github.com/gonzalesc)

## License

[GPL-3.0+](https://www.gnu.org/licenses/gpl-3.0.txt)