<?php
/*
Plugin Name: Burq: On-Demand Delivery for WooCommerce
Description: Offer on-demand delivery instantly with Burq
Version: 1.0
Author: Burq
Requires PHP: 7.2
Requires at least: 5.8
Requires Plugins: woocommerce
WC requires at least: 6.0
WC tested up to: 10.1.0
*/

defined('ABSPATH') || exit;
// Stop loading if WooCommerce is missing

// Prevent activation if WooCommerce is not active
register_activation_hook(__FILE__, function () {
    if ( ! class_exists('WooCommerce') ) {
        deactivate_plugins(plugin_basename(__FILE__));
        wp_die(
            esc_html__('This plugin requires WooCommerce to be installed and active.', 'burq'),
            esc_html__('Plugin dependency check', 'burq'),
            array('back_link' => true)
        );
    }
});

// 1) Declare HPOS compatibility EARLY and UNCONDITIONALLY.
add_action('before_woocommerce_init', function () {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
            'custom_order_tables',
            __FILE__,
            true
        );
    }
});

// 2) One clean init hook.
add_action('plugins_loaded', 'burq_init_shipping_integration', 1);

function burq_init_shipping_integration() {
    // If WooCommerce is not active, bail safely (do NOT hard-deactivate).
    if (! class_exists('WooCommerce')) {
        return;
    }

    // Define paths/urls
    if (! defined('BURQ_PLUGIN_DIR')) {
        define('BURQ_PLUGIN_DIR', plugin_dir_path(__FILE__));
    }
    if (! defined('BURQ_PLUGIN_URL')) {
        define('BURQ_PLUGIN_URL', plugin_dir_url(__FILE__));
    }

    // Load plugin files
    require_once BURQ_PLUGIN_DIR . 'includes/loader.php';
    require_once BURQ_PLUGIN_DIR . 'includes/shipping.php';
}

// 3) Activation check (simple & safe).
register_activation_hook(__FILE__, function () {
    if (! did_action('woocommerce_loaded') && ! class_exists('WooCommerce')) {
        deactivate_plugins(plugin_basename(__FILE__));
        wp_die(
            esc_html__('Please install and activate WooCommerce before activating this plugin.', 'burq'),
            esc_html__('Dependency missing', 'burq'),
            array('back_link' => true)
        );
    }
});

// 4) Settings link in plugins screen.
add_filter('plugin_action_links_' . plugin_basename(__FILE__), function ($links) {
    $settings_link = '<a href="' . esc_url(admin_url('admin.php?page=wc-settings&tab=shipping&section=burq')) . '">' . esc_html__('Settings', 'burq') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
});

// 5) Optional: keep your decimals tweak.
add_filter('wc_get_price_decimals', function ($decimals) {
    if (is_cart() || is_checkout()) {
        $decimals = 2;
    }
    return $decimals;
}, 20);
