<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://webtoffee.com
 * @since             1.0.0
 * @package           Wbtfe_Multichannel_Inventory_Sync
 *
 * @wordpress-plugin
 * Plugin Name:       WebToffee Inventory Sync for Amazon
 * Plugin URI:        https://wordpress.org/plugins/wbtfe-multichannel-inventory-sync/
 * Description:       Connect WooCommerce with Amazon to sync inventory in real time, manage listings, set pricing rules, and keep stock accurate to prevent overselling.
 * Version:           1.0.1
 * Author:            WebToffee
 * Author URI:        https://webtoffee.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wbtfe-multichannel-inventory-sync
 * Domain Path:       /languages
 * Requires at least: 6.2
 * Requires PHP:      7.0
 * Requires Plugins:  woocommerce
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'WBTFE_MULTICHANNEL_INVENTORY_SYNC_VERSION', '1.0.1' );
define( 'WBTFE_MULTICHANNEL_INVENTORY_SYNC_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'WBTFE_MULTICHANNEL_INVENTORY_SYNC_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wbtfe-multichannel-inventory-sync-activator.php
 */
function activate_wbtfe_multichannel_inventory_sync() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wbtfe-multichannel-inventory-sync-activator.php';
	Wbtfe_Multichannel_Inventory_Sync_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wbtfe-multichannel-inventory-sync-deactivator.php
 */
function deactivate_wbtfe_multichannel_inventory_sync() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wbtfe-multichannel-inventory-sync-deactivator.php';
	Wbtfe_Multichannel_Inventory_Sync_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_wbtfe_multichannel_inventory_sync' );
register_deactivation_hook( __FILE__, 'deactivate_wbtfe_multichannel_inventory_sync' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-wbtfe-multichannel-inventory-sync.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_wbtfe_multichannel_inventory_sync() {

	$plugin = new Wbtfe_Multichannel_Inventory_Sync();
	$plugin->run();
}
run_wbtfe_multichannel_inventory_sync();
