<?php
/**
 * File page to display plugin not connection with the inventory app.
 *
 * @link       https://www.webtoffee.com
 * @since      1.0.0
 *
 * @package    Wbtfe_Multichannel_Inventory_Sync
 * @subpackage Wbtfe_Multichannel_Inventory_Sync/admin/views
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

?>

<h2><?php esc_html_e( 'You\'re One Step Away from Your Amazon Storefront', 'wbtfe-multichannel-inventory-sync' ); ?></h2>
<img src="<?php echo esc_url( WBTFE_MULTICHANNEL_INVENTORY_SYNC_PLUGIN_URL ) . 'admin/images/'; ?>not-connected.svg" alt="<?php esc_attr_e( 'Not connected', 'wbtfe-multichannel-inventory-sync' ); ?>" style="max-width:180px;">

	<a href="<?php echo esc_url( $auth_url ); ?>" style="margin-top:30px; margin-bottom:15px;" class="wbte_multinvsync_button-shadow wbte_multinvsync_button wbte_multinvsync_button-filled wbte_multinvsync_button-medium">
		<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M19.8901 9.55029C19.807 9.38537 19.6799 9.24669 19.5228 9.14961C19.3657 9.05253 19.1848 9.00085 19.0001 9.00029H14.0001V3.00029C14.0108 2.78097 13.9491 2.56422 13.8244 2.38349C13.6997 2.20276 13.519 2.06809 13.3101 2.00029C13.1093 1.93423 12.8928 1.93349 12.6916 1.99817C12.4903 2.06285 12.3148 2.18962 12.1901 2.36029L4.19011 13.3603C4.08987 13.5052 4.02968 13.6739 4.01564 13.8495C4.00159 14.0251 4.03418 14.2013 4.11011 14.3603C4.18003 14.542 4.30149 14.6994 4.4596 14.8131C4.6177 14.9268 4.80555 14.9919 5.00011 15.0003H10.0001V21.0003C10.0003 21.2112 10.0671 21.4166 10.191 21.5872C10.3149 21.7578 10.4896 21.8849 10.6901 21.9503C10.7906 21.9814 10.8949 21.9983 11.0001 22.0003C11.1579 22.0007 11.3135 21.9638 11.4543 21.8925C11.5951 21.8212 11.717 21.7177 11.8101 21.5903L19.8101 10.5903C19.9178 10.4411 19.9823 10.265 19.9964 10.0815C20.0106 9.89805 19.9738 9.71421 19.8901 9.55029ZM12.0001 17.9203V14.0003C12.0001 13.7351 11.8947 13.4807 11.7072 13.2932C11.5197 13.1056 11.2653 13.0003 11.0001 13.0003H7.00011L12.0001 6.08029V10.0003C12.0001 10.2655 12.1055 10.5199 12.293 10.7074C12.4805 10.8949 12.7349 11.0003 13.0001 11.0003H17.0001L12.0001 17.9203Z" fill="#2A3646"></path>
		</svg>
		<?php esc_html_e( 'Connect to app', 'wbtfe-multichannel-inventory-sync' ); ?>
	</a>

<p class="wbte_multinvsync_subtitle-text">
	<?php esc_html_e( 'Simple one-click setup connects your store instantly.', 'wbtfe-multichannel-inventory-sync' ); ?><br>
	<?php esc_html_e( 'No Keys or complex configuration.', 'wbtfe-multichannel-inventory-sync' ); ?>
</p>