<?php
/**
 * File page to display plugin connection with the inventory app.
 *
 * @link       https://www.webtoffee.com
 * @since      1.0.0
 *
 * @package    Wbtfe_Multichannel_Inventory_Sync
 * @subpackage Wbtfe_Multichannel_Inventory_Sync/admin/views
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

?>
<h2>
	<?php
		// translators: %s is name of the customer.
		echo esc_html( sprintf( __( 'Welcome back, %s', 'wbtfe-multichannel-inventory-sync' ), $customer_name ) );
	?>
	</h2>
<img src="<?php echo esc_url( WBTFE_MULTICHANNEL_INVENTORY_SYNC_PLUGIN_URL ) . 'admin/images/'; ?>connected.svg" alt="<?php esc_attr_e( 'Connected', 'wbtfe-multichannel-inventory-sync' ); ?>" style="max-width:180px;">
	
<h3 class="wbtfe_mis_connected_success wbte_multinvsync_h3-text">
	<img src="
	<?php
	echo esc_url(
		$ds_obj->get_asset(
			array(
				'name' => 'success-icon',
				'type' => 'icon',
			)
		)
	);
	?>
	">
	<?php esc_html_e( 'You\'re connected', 'wbtfe-multichannel-inventory-sync' ); ?>
</h3>

<p class="wbte_multinvsync_subtitle-text" style="margin-top:0px;">
	<?php esc_html_e( 'and your products are now synced in real time with WebToffee Inventory app.', 'wbtfe-multichannel-inventory-sync' ); ?>
</p>

<div style="display:flex; align-items:start; gap:15px;">
	<a target="_blank" href="<?php echo esc_url( $dashboard_url ); ?>" style="margin-bottom:15px;" class="wbte_multinvsync_button-shadow wbte_multinvsync_button wbte_multinvsync_button-filled wbte_multinvsync_button-medium">
		<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M18 10.82C17.7348 10.82 17.4804 10.9254 17.2929 11.1129C17.1054 11.3004 17 11.5548 17 11.82V19C17 19.2652 16.8946 19.5196 16.7071 19.7071C16.5196 19.8946 16.2652 20 16 20H5C4.73478 20 4.48043 19.8946 4.29289 19.7071C4.10536 19.5196 4 19.2652 4 19V8C4 7.73478 4.10536 7.48043 4.29289 7.29289C4.48043 7.10536 4.73478 7 5 7H12.18C12.4452 7 12.6996 6.89464 12.8871 6.70711C13.0746 6.51957 13.18 6.26522 13.18 6C13.18 5.73478 13.0746 5.48043 12.8871 5.29289C12.6996 5.10536 12.4452 5 12.18 5H5C4.20435 5 3.44129 5.31607 2.87868 5.87868C2.31607 6.44129 2 7.20435 2 8V19C2 19.7956 2.31607 20.5587 2.87868 21.1213C3.44129 21.6839 4.20435 22 5 22H16C16.7956 22 17.5587 21.6839 18.1213 21.1213C18.6839 20.5587 19 19.7956 19 19V11.82C19 11.5548 18.8946 11.3004 18.7071 11.1129C18.5196 10.9254 18.2652 10.82 18 10.82ZM21.92 2.62C21.8185 2.37565 21.6243 2.18147 21.38 2.08C21.2598 2.02876 21.1307 2.00158 21 2H15C14.7348 2 14.4804 2.10536 14.2929 2.29289C14.1054 2.48043 14 2.73478 14 3C14 3.26522 14.1054 3.51957 14.2929 3.70711C14.4804 3.89464 14.7348 4 15 4H18.59L8.29 14.29C8.19627 14.383 8.12188 14.4936 8.07111 14.6154C8.02034 14.7373 7.9942 14.868 7.9942 15C7.9942 15.132 8.02034 15.2627 8.07111 15.3846C8.12188 15.5064 8.19627 15.617 8.29 15.71C8.38296 15.8037 8.49356 15.8781 8.61542 15.9289C8.73728 15.9797 8.86799 16.0058 9 16.0058C9.13201 16.0058 9.26272 15.9797 9.38458 15.9289C9.50644 15.8781 9.61704 15.8037 9.71 15.71L20 5.41V9C20 9.26522 20.1054 9.51957 20.2929 9.70711C20.4804 9.89464 20.7348 10 21 10C21.2652 10 21.5196 9.89464 21.7071 9.70711C21.8946 9.51957 22 9.26522 22 9V3C21.9984 2.86932 21.9712 2.74022 21.92 2.62Z" fill="#2A3646"></path>
		</svg>
		<?php esc_html_e( 'Go to Webtoffee Inventory app', 'wbtfe-multichannel-inventory-sync' ); ?>
	</a>

	<?php
	// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped -- Already escaped in the get_component.
	echo $ds_obj->get_component(
		'button medium danger',
		array( // @codingStandardsIgnoreLine
			'values' => array(
				'button_title'      => esc_html__( 'Disconnect app', 'wbtfe-multichannel-inventory-sync' ),
				'icon_left'      	=> 'disconnect',
			),
			'class' => array('wbtfe_mis_disconnect'),
		)
	);
	// phpcs:enable WordPress.Security.EscapeOutput.OutputNotEscaped
	?>
</div>

<p class="wbte_multinvsync_subtitle-text" style="margin-top:5px;">
	<?php
	if ( $last_sync_date ) {
		// translators: %s is the last sync date.
		echo esc_html( sprintf( __( 'Last sync: %s', 'wbtfe-multichannel-inventory-sync' ), $last_sync_date ) );
	}
	?>
</p>


<!-- Custom Disconnect Modal -->
<div id="wbtfe-disconnect-modal" class="wbtfe-modal-overlay" style="display: none;">
	<div class="wbtfe-modal-content">
		<div class="wbtfe-modal-header">
			<h3 class="wbtfe-modal-title"><?php esc_html_e( 'Disconnect from app?', 'wbtfe-multichannel-inventory-sync' ); ?></h3>
			<button type="button" class="wbtfe-modal-close" aria-label="Close">&times;</button>
		</div>
		<div class="wbtfe-modal-body">
			<p><?php esc_html_e( 'This will remove all store data and sync with Amazon products.', 'wbtfe-multichannel-inventory-sync' ); ?></p>
		</div>
		<div class="wbtfe-modal-footer">
			<button type="button" class="wbtfe-modal-cancel"><?php esc_html_e( 'Cancel', 'wbtfe-multichannel-inventory-sync' ); ?></button>
			<button type="button" class="wbtfe-modal-disconnect"><?php esc_html_e( 'Disconnect', 'wbtfe-multichannel-inventory-sync' ); ?></button>
		</div>
	</div>
</div>

