<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://www.webtoffee.com
 * @since      1.0.0
 *
 * @package    Wbtfe_Multichannel_Inventory_Sync
 * @subpackage Wbtfe_Multichannel_Inventory_Sync/admin/views
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
$ds_obj           = Wbte\Multinvsync\Ds\Wbte_Ds::get_instance( WBTFE_MULTICHANNEL_INVENTORY_SYNC_VERSION );
$admin_views_path = WBTFE_MULTICHANNEL_INVENTORY_SYNC_PLUGIN_PATH . 'admin/views/';
?>
<div>
	<?php
	// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped -- Already escaped in the get_component.
	echo $ds_obj->get_component(
		'header',
		array( // @codingStandardsIgnoreLine
			'values' => array(
				'plugin_logo'      => esc_url(
					$ds_obj->get_asset(
						array(
							'name' => 'webtoffee-inventory-logo.svg',
							'type' => 'image',
						)
					)
				),
				'plugin_name'      => esc_html__( 'WebToffee Inventory Sync for Amazon', 'wbtfe-multichannel-inventory-sync' ),
				'developed_by_txt' => esc_html__( 'Developed by ', 'wbtfe-multichannel-inventory-sync' ),
			),
			'class'  => array( '' ),
		)
	);
	// phpcs:enable WordPress.Security.EscapeOutput.OutputNotEscaped

	// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped -- Already escaped in the get_component.
	echo $ds_obj->get_component(
		'help-widget',
		array( // @codingStandardsIgnoreLine
			'values' => array(
				'items'      => array(
					array(
						'title'  => esc_html__( 'FAQ', 'wbtfe-multichannel-inventory-sync' ),
						'icon'   => 'chat-1',
						'href'   => 'https://wordpress.org/plugins/wbtfe-multichannel-inventory-sync',
						'target' => '_blank',
					),
					array(
						'title'  => esc_html__( 'Setup guide', 'wbtfe-multichannel-inventory-sync' ),
						'icon'   => 'book',
						'href'   => 'https://www.webtoffee.com/',
						'target' => '_blank',
					),
					array(
						'title'  => esc_html__( 'Contact support', 'wbtfe-multichannel-inventory-sync' ),
						'icon'   => 'headphone',
						'href'   => 'https://wordpress.org/plugins/wbtfe-multichannel-inventory-sync/',
						'target' => '_blank',
					),
				),
				'hover_text' => esc_html__( 'Help', 'wbtfe-multichannel-inventory-sync' ),
			),
		)
	);
	// phpcs:enable WordPress.Security.EscapeOutput.OutputNotEscaped
	?>
	<div class="wbtfe_mis_container">
		<input type="hidden" id="wbtfe_delete_connection_data_forcefully" name="wbtfe_delete_connection_data_forcefully" value="<?php echo esc_attr( wp_create_nonce( 'wbtfe_delete_connection_data_forcefully' ) ); ?>">
		<?php
		if( $show_warning &&  $is_connected ){
			include_once $admin_views_path . 'warning.php';
		}
		?>
		<div class="wbtfe_mis_connection_box wbte_multinvsync_card-shadow">
		<?php
		if ( $is_connected ) {
			include_once $admin_views_path . 'connected.php';
		} else {
			include_once $admin_views_path . 'not-connected.php';
		}
		?>
		</div>
	</div>
</div>