(function ( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	// Disconnect functionality
	$(function() {
		var disconnection_in_progress = false;
		var original_button_html = '';
		
		// Show modal when disconnect button is clicked
		$('.wbtfe_mis_disconnect').on('click', function(e){
			e.preventDefault();
			if(disconnection_in_progress){
				return;
			}
			original_button_html = $(this).html();
			$('#wbtfe-disconnect-modal').show();
		});
		
		// Handle modal close events
		$('.wbtfe-modal-close, .wbtfe-modal-cancel').on('click', function(){
			$('#wbtfe-disconnect-modal').hide();
		});
		
		// Handle clicking outside modal to close
		$('#wbtfe-disconnect-modal').on('click', function(e){
			if(e.target === this){
				$('#wbtfe-disconnect-modal').hide();
			}
		});
		
		// Handle disconnect confirmation
		$('.wbtfe-modal-disconnect').on('click', function(){
			if(disconnection_in_progress){
				return;
			}
			disconnection_in_progress = true;
			
			// Hide modal
			$('#wbtfe-disconnect-modal').hide();
			
			// Update button text
			$('.wbtfe_mis_disconnect').html(wbtfe_mis_admin.disconnecting_text);
			
			// Perform AJAX disconnect
			$.ajax({
				url: wbtfe_mis_admin.ajax_url,
				type: 'POST',
				data: { 
					action: 'wbtfe_mis_disconnect', 
					nonce: wbtfe_mis_admin.disconnect_nonce 
				},
				dataType: 'json',
				success: function(response){
					disconnection_in_progress = false;
					if(response.success){
						// Show success notification
						if(typeof wbte_multinvsync_notify_msg !== 'undefined'){
							wbte_multinvsync_notify_msg.success( wbtfe_mis_admin.disconnected_success_text, false );
						}
						
						// Reload page after 2 seconds
						setTimeout(function(){
							window.location.reload();
						}, 2000);
					}else{                   
						if(typeof wbte_multinvsync_notify_msg !== 'undefined'){
							wbte_multinvsync_notify_msg.error( wbtfe_mis_admin.disconnect_failed_text, false );
						}
						$('.wbtfe_mis_disconnect').html(original_button_html);                           
					}
				},
				error: function(xhr, status, error){
					disconnection_in_progress = false;
					if(typeof wbte_multinvsync_notify_msg !== 'undefined'){
						wbte_multinvsync_notify_msg.error( wbtfe_mis_admin.disconnect_failed_text, false );
					}
					$('.wbtfe_mis_disconnect').html(original_button_html);
				}
			});
		});
	});

})( jQuery );
