<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://webtoffee.com
 * @since      1.0.0
 *
 * @package    Wbtfe_Multichannel_Inventory_Sync
 * @subpackage Wbtfe_Multichannel_Inventory_Sync/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * @package    Wbtfe_Multichannel_Inventory_Sync
 * @subpackage Wbtfe_Multichannel_Inventory_Sync/admin
 * @author     WebToffee
 */
class Wbtfe_Multichannel_Inventory_Sync_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Is design system files loaded or not.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      bool    $ds_loaded    Is design system files loaded or not.
	 */
	private $ds_loaded = false;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string $plugin_name       The name of this plugin.
	 * @param      string $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles( $hook ) {

		/**
		 * Only enqueue styles on our plugin's admin pages
		 */
		if ( strpos( $hook, 'wbtfe-multichannel-inventory-sync' ) === false ) {
			return;
		}

		wp_enqueue_style( 
			$this->plugin_name, 
			plugin_dir_url( __FILE__ ) . 'css/wbtfe-multichannel-inventory-sync-admin.css', 
			array(), 
			$this->version, 
			'all' 
		);
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts( $hook ) {

		/**
		 * Only enqueue scripts on our plugin's admin pages
		 */
		if ( strpos( $hook, 'wbtfe-multichannel-inventory-sync' ) === false ) {
			return;
		}

		wp_enqueue_script( 
			$this->plugin_name, 
			plugin_dir_url( __FILE__ ) . 'js/wbtfe-multichannel-inventory-sync-admin.js', 
			array( 'jquery' ), 
			$this->version, 
			false 
		);

		// Localize script with data needed by JavaScript
		wp_localize_script( 
			$this->plugin_name, 
			'wbtfe_mis_admin', 
			array(
				'ajax_url' => admin_url( 'admin-ajax.php' ),
				'disconnect_nonce' => wp_create_nonce( 'wbtfe_mis_disconnect' ),
				'disconnecting_text' => __( 'Disconnecting...', 'wbtfe-multichannel-inventory-sync' ),
				'disconnected_success_text' => __( 'Disconnected from app!', 'wbtfe-multichannel-inventory-sync' ),
				'disconnect_failed_text' => __( 'Failed to disconnect.', 'wbtfe-multichannel-inventory-sync' ),
			)
		);
	}

	/**
	 *  Load the design system files and initiate it.
	 *
	 *  @since    1.0.0
	 */
	public function include_design_system() {
		if ( ! $this->ds_loaded ) {
			include_once plugin_dir_path( __FILE__ ) . 'wt-ds/class-wbte-ds.php';
			/**
			 * Just initiate it. This is to load the CSS and JS.
			 */
			Wbte\Multinvsync\Ds\Wbte_Ds::get_instance( WBTFE_MULTICHANNEL_INVENTORY_SYNC_VERSION );
			$this->ds_loaded = true;
		}
	}
}
