<?php

function waktu_berbuka_install () {
    global $wpdb;

    $table_kawasan 	= $wpdb->prefix . "ramadhan_kawasan";
    $table_waktu 	= $wpdb->prefix . "ramadhan_waktu";

    if($wpdb->get_var("show tables like '$table_kawasan'") != $table_kawasan) {
          
        $sql = "CREATE TABLE " . $table_kawasan . " (
            kod_kawasan varchar(10) NOT NULL,
            nama_kawasan varchar(150) NOT NULL
            );";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);

        $list_kawasan = data_kawasan();

        foreach ($list_kawasan as $kawasan) {           
            $rows_affected[] = $wpdb->insert( $table_kawasan, $kawasan );
        }
     
        add_option("ramadhan_kaw_db_version", "1.0");

    }

    if($wpdb->get_var("show tables like '$table_waktu'") != $table_waktu) {
          
        $sql = "CREATE TABLE " . $table_waktu . " (
            kod_kawasan varchar(10) NOT NULL,
            tarikh varchar(20) NOT NULL,
            hari varchar(10) NOT NULL,
            imsak varchar(10) NOT NULL,
            subuh varchar(10) NOT NULL,
	    syuruk varchar(10) NOT NULL,
	    zohor varchar(10) NOT NULL,
	    asar varchar(10) NOT NULL,
            maghrib varchar(10) NOT NULL,
	    isyak varchar(10) NOT NULL
            );";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);

        $list_waktu = data_waktu();

        foreach ($list_waktu as $waktu) {           
            $rows_affected[] = $wpdb->insert( $table_waktu, $waktu );
        }
     
        add_option("ramadhan_waktu_db_version", "2.0");

    } else {
	
	$db_version = get_option("ramadhan_waktu_db_version");

	if($db_version == "1.0") {

		$wpdb->query("DROP TABLE IF EXISTS $table_waktu");

		$sql = "CREATE TABLE " . $table_waktu . " (
		    kod_kawasan varchar(10) NOT NULL,
		    tarikh varchar(20) NOT NULL,
		    hari varchar(10) NOT NULL,
		    imsak varchar(10) NOT NULL,
		    subuh varchar(10) NOT NULL,
		    syuruk varchar(10) NOT NULL,
		    zohor varchar(10) NOT NULL,
		    asar varchar(10) NOT NULL,
		    maghrib varchar(10) NOT NULL,
		    isyak varchar(10) NOT NULL
		    );";

		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql);

		$list_waktu = data_waktu();

		foreach ($list_waktu as $waktu) {           
		    $rows_affected[] = $wpdb->insert( $table_waktu, $waktu );
		}
	     
		update_option("ramadhan_waktu_db_version", "2.0");
	}
    }
	
}

function waktu_berbuka_uninstall() {
	global $wpdb;

	$table_kawasan 	= $wpdb->prefix . "ramadhan_kawasan";
	$table_waktu 	= $wpdb->prefix . "ramadhan_waktu";

	$wpdb->query("DROP TABLE IF EXISTS $table_kawasan");
	$wpdb->query("DROP TABLE IF EXISTS $table_waktu");
}

function data_kawasan () {
    $kawasan = array(
            array('kod_kawasan' => 'JHR04', 'nama_kawasan' => 'Batu Pahat, Muar, Segamat, Gemas, JOHOR'),
            array('kod_kawasan' => 'JHR03', 'nama_kawasan' => 'Kluang dan Pontian, JOHOR'),
            array('kod_kawasan' => 'JHR02', 'nama_kawasan' => 'Kota Tinggi, Mersing, Johor Bahru, JOHOR'),
            array('kod_kawasan' => 'JHR01', 'nama_kawasan' => 'Pulau Aur dan Pemanggil, JOHOR'),
            array('kod_kawasan' => 'KDH01', 'nama_kawasan' => 'Baling, Sik, Padang Terap, KEDAH'),
            array('kod_kawasan' => 'KDH02', 'nama_kawasan' => 'Kubang Pasu, Kota Setar, Pendang, Kulim, Bandar Bharu, Kuala Muda, Yan, KEDAH'),
            array('kod_kawasan' => 'KDH06', 'nama_kawasan' => 'Kulim, Bandar Baharu, KEDAH'),
            array('kod_kawasan' => 'KDH04', 'nama_kawasan' => 'Langkawi, KEDAH'),
            array('kod_kawasan' => 'KDH05', 'nama_kawasan' => 'Pendang, Kuala Muda, Yan, KEDAH'),
            array('kod_kawasan' => 'KDH03', 'nama_kawasan' => 'Puncak Gunung Jerai, KEDAH'),
            array('kod_kawasan' => 'KTN03', 'nama_kawasan' => 'Jeli, Gua Musang (Mukim Galas, Bertam), Kelantan'),
            array('kod_kawasan' => 'KTN01', 'nama_kawasan' => 'Kota Bharu, Bachok, Pasir Puteh, Tumpat, Pasir Mas, Tanah Merah, Machang, Kuala Krai, Mukim Chiku (Jajahan Gua Musang), Kelantan'),
            array('kod_kawasan' => 'MLK01', 'nama_kawasan' => 'Bandar Melaka, Alor Gajah, Jasin, Masjid Tanah, Merlimau, Nyalas, MELAKA'),
            array('kod_kawasan' => 'NGS01', 'nama_kawasan' => 'Jempol, Tampin, NEGERI SEMBILAN'),
            array('kod_kawasan' => 'NGS02', 'nama_kawasan' => 'Port Dickson, Seremban, Kuala Pilah, Jelebu, Rembau, NEGERI SEMBILAN'),
            array('kod_kawasan' => 'PHG04', 'nama_kawasan' => 'Bentong, Raub, Kuala Lipis, PAHANG'),
            array('kod_kawasan' => 'PHG06', 'nama_kawasan' => 'Cameron Highland, PAHANG'),
            array('kod_kawasan' => 'PHG05', 'nama_kawasan' => 'Genting Highlands, Bukit Fraser, PAHANG'),
            array('kod_kawasan' => 'PHG02', 'nama_kawasan' => 'Kuantan, Pekan, Rompin, Muadzam Shah, PAHANG'),
            array('kod_kawasan' => 'PHG03', 'nama_kawasan' => 'Maran, Chenor, Temerloh, Bera, Jerantut, PAHANG'),
            array('kod_kawasan' => 'PHG01', 'nama_kawasan' => 'Pulau Tioman, PAHANG'),
            array('kod_kawasan' => 'PRK03', 'nama_kawasan' => 'Bukit Larut, PERAK'),
            array('kod_kawasan' => 'PRK01', 'nama_kawasan' => 'Ipoh, Batu Gajah, Kampar, Sg. Siput, Kuala Kangsar, PERAK'),
            array('kod_kawasan' => 'PRK05', 'nama_kawasan' => 'Pengkalan Hulu, Grik & Lenggong, PERAK'),
            array('kod_kawasan' => 'PRK02', 'nama_kawasan' => 'Selama, Taiping, Bagan Serai, Parit Buntar, PERAK'),
            array('kod_kawasan' => 'PRK04', 'nama_kawasan' => 'Tapah,Slim River & Tanjung Malim, PERAK'),
            array('kod_kawasan' => 'PRK07', 'nama_kawasan' => 'Teluk Intan, Bagan Datoh, Kg.Gajah,Sri Iskandar, Beruas,Parit,Lumut,Setiawan & Pulau Pangkor, PERAK'),
            array('kod_kawasan' => 'PRK06', 'nama_kawasan' => 'Temengor & Belum, PERAK'),
            array('kod_kawasan' => 'PLS01', 'nama_kawasan' => 'Kangar, Padang Besar, Arau, PERLIS'),
            array('kod_kawasan' => 'PNG01', 'nama_kawasan' => 'Seluruh Negeri Pulau Pinang, PULAU PINANG'),
            array('kod_kawasan' => 'SBH01', 'nama_kawasan' => 'Zon 1 - Sandakan, Bdr. Bkt. Garam, Semawang, Temanggong, Tambisan, Sabah'),
            array('kod_kawasan' => 'SBH02', 'nama_kawasan' => 'Zon 2 - Pinangah, Terusan, Beluran, Kuamut, Telupit, Sabah'),
            array('kod_kawasan' => 'SBH03', 'nama_kawasan' => 'Zon 3 - Lahad Datu, Kunak, Silabukan, Tungku, Sahabat, Semporna, Sabah'),
            array('kod_kawasan' => 'SBH04', 'nama_kawasan' => 'Zon 4 - Tawau, Balong, Merotai, Kalabakan, Sabah'),
            array('kod_kawasan' => 'SBH05', 'nama_kawasan' => 'Zon 5 - Kudat, Kota Marudu, Pitas, Pulau Banggi, Sabah'),
            array('kod_kawasan' => 'SBH06', 'nama_kawasan' => 'Zon 6 - Gunung Kinabalu, Sabah'),
            array('kod_kawasan' => 'SBH07', 'nama_kawasan' => 'Zon 7 - Papar, Ranau, Kota Belud, Tuaran, Penampang, Kota Kinabalu, Sabah'),
            array('kod_kawasan' => 'SBH08', 'nama_kawasan' => 'Zon 8 - Pensiangan, Keningau, Tambunan, Nabawan, Sabah'),
            array('kod_kawasan' => 'SBH09', 'nama_kawasan' => 'Zon 9 - Sipitang, Membakut, Beaufort, Kuala Penyu, Weston, Tenom, Long Pa Sia, Sabah'),
            array('kod_kawasan' => 'SWK01', 'nama_kawasan' => 'Zon 1 - Limbang, Sundar, Terusan, Lawas, Sarawak'),
            array('kod_kawasan' => 'SWK02', 'nama_kawasan' => 'Zon 2 - Niah, Belaga, Sibuti, Miri, Bekenu, Marudi, Sarawak'),
            array('kod_kawasan' => 'SWK03', 'nama_kawasan' => 'Zon 3 - Song, Belingan, Sebauh, Bintulu, Tatau, Kapit, Sarawak'),
            array('kod_kawasan' => 'SWK04', 'nama_kawasan' => 'Zon 4 - Igan, Kanowit, Sibu, Dalat, Oya, Sarawak'),
            array('kod_kawasan' => 'SWK05', 'nama_kawasan' => 'Zon 5 - Belawai, Matu, Daro, Sarikei, Julau, Bitangor, Rajang, Sarawak'),
            array('kod_kawasan' => 'SWK06', 'nama_kawasan' => 'Zon 6 - Kabong, Lingga, Sri Aman, Engkelili, Betong, Spaoh, Pusa, Saratok, Roban, Debak, Sarawak'),
            array('kod_kawasan' => 'SWK07', 'nama_kawasan' => 'Zon 7 - Samarahan, Simunjan, Serian, Sebuyau, Meludam, Sarawak'),
            array('kod_kawasan' => 'SWK08', 'nama_kawasan' => 'Zon 8 - Kuching, Bau, Lundu,Sematan, Sarawak'),
            array('kod_kawasan' => 'SGR01', 'nama_kawasan' => 'Gombak, Hulu Selangor, Rawang, Hulu Langat, Sepang, Petaling, Shah Alam, SELANGOR dan WILAYAH PERSEKUTUAN'),
            array('kod_kawasan' => 'SGR03', 'nama_kawasan' => 'Kuala Lumpur, SELANGOR dan WILAYAH PERSEKUTUAN'),
            array('kod_kawasan' => 'SGR04', 'nama_kawasan' => 'Putrajaya, SELANGOR dan WILAYAH PERSEKUTUAN'),
            array('kod_kawasan' => 'SGR02', 'nama_kawasan' => 'Sabak Bernam, Kuala Selangor, Klang, Kuala Langat, SELANGOR DAN WILAYAH PERSEKUTUAN'),
            array('kod_kawasan' => 'TRG02', 'nama_kawasan' => 'Besut, Setiu, Terengganu'),
            array('kod_kawasan' => 'TRG03', 'nama_kawasan' => 'Hulu Terengganu, Terengganu'),
            array('kod_kawasan' => 'TRG04', 'nama_kawasan' => 'Kemaman Dungun, Terengganu'),
            array('kod_kawasan' => 'TRG01', 'nama_kawasan' => 'Kuala Terengganu, Marang, Terengganu'),
            array('kod_kawasan' => 'WLY02', 'nama_kawasan' => 'Labuan, WILAYAH PERSEKUTUAN LABUAN')
        );
    return $kawasan;
}

function data_waktu () {
    $waktu = array(
			array('kod_kawasan' => 'JHR04', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:09','Zohor' => '13:18', 'Asar' => '16:39','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:09','Zohor' => '13:18', 'Asar' => '16:38','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:09','Zohor' => '13:18', 'Asar' => '16:38','Maghrib' => '19:22', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:09','Zohor' => '13:18', 'Asar' => '16:38','Maghrib' => '19:22', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:09','Zohor' => '13:18', 'Asar' => '16:37','Maghrib' => '19:22', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:09','Zohor' => '13:18', 'Asar' => '16:37','Maghrib' => '19:22', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:08','Zohor' => '13:18', 'Asar' => '16:37','Maghrib' => '19:22', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:08','Zohor' => '13:18', 'Asar' => '16:36','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:08','Zohor' => '13:17', 'Asar' => '16:36','Maghrib' => '19:21', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:08','Zohor' => '13:17', 'Asar' => '16:35','Maghrib' => '19:21', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:08','Zohor' => '13:17', 'Asar' => '16:35','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:08','Zohor' => '13:17', 'Asar' => '16:34','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:08','Zohor' => '13:17', 'Asar' => '16:34','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:08','Zohor' => '13:16', 'Asar' => '16:33','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:08','Zohor' => '13:16', 'Asar' => '16:33','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:08','Zohor' => '13:16', 'Asar' => '16:32','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:07','Zohor' => '13:16', 'Asar' => '16:32','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:07','Zohor' => '13:16', 'Asar' => '16:31','Maghrib' => '19:19', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:07','Zohor' => '13:15', 'Asar' => '16:31','Maghrib' => '19:19', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:07','Zohor' => '13:15', 'Asar' => '16:30','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:07','Zohor' => '13:15', 'Asar' => '16:29','Maghrib' => '19:18', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:07','Zohor' => '13:15', 'Asar' => '16:29','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:06','Zohor' => '13:14', 'Asar' => '16:28','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:06','Zohor' => '13:14', 'Asar' => '16:27','Maghrib' => '19:17', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:06','Zohor' => '13:14', 'Asar' => '16:27','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:38','Subuh' => '05:48', 'Syuruk' => '07:06','Zohor' => '13:14', 'Asar' => '16:26','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:38','Subuh' => '05:48', 'Syuruk' => '07:06','Zohor' => '13:14', 'Asar' => '16:25','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:38','Subuh' => '05:48', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:24','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:38','Subuh' => '05:48', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:23','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:38','Subuh' => '05:48', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:23','Maghrib' => '19:15', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:38','Subuh' => '05:48', 'Syuruk' => '07:05','Zohor' => '13:12', 'Asar' => '16:22','Maghrib' => '19:15', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'JHR04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:38','Subuh' => '05:48', 'Syuruk' => '07:05','Zohor' => '13:12', 'Asar' => '16:22','Maghrib' => '19:15', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:07','Zohor' => '13:16', 'Asar' => '16:36','Maghrib' => '19:19', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:07','Zohor' => '13:16', 'Asar' => '16:36','Maghrib' => '19:19', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:07','Zohor' => '13:15', 'Asar' => '16:36','Maghrib' => '19:19', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:07','Zohor' => '13:15', 'Asar' => '16:35','Maghrib' => '19:19', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:07','Zohor' => '13:15', 'Asar' => '16:35','Maghrib' => '19:19', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:07','Zohor' => '13:15', 'Asar' => '16:35','Maghrib' => '19:19', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:07','Zohor' => '13:15', 'Asar' => '16:34','Maghrib' => '19:18', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:06','Zohor' => '13:15', 'Asar' => '16:34','Maghrib' => '19:18', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:06','Zohor' => '13:15', 'Asar' => '16:33','Maghrib' => '19:18', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:06','Zohor' => '13:15', 'Asar' => '16:33','Maghrib' => '19:18', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:06','Zohor' => '13:14', 'Asar' => '16:33','Maghrib' => '19:18', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:06','Zohor' => '13:14', 'Asar' => '16:32','Maghrib' => '19:17', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:06','Zohor' => '13:14', 'Asar' => '16:32','Maghrib' => '19:17', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:06','Zohor' => '13:14', 'Asar' => '16:31','Maghrib' => '19:17', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:06','Zohor' => '13:14', 'Asar' => '16:31','Maghrib' => '19:17', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:05','Zohor' => '13:14', 'Asar' => '16:30','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:30','Maghrib' => '19:16', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:29','Maghrib' => '19:16', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:28','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:28','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:27','Maghrib' => '19:15', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:04','Zohor' => '13:12', 'Asar' => '16:26','Maghrib' => '19:15', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:04','Zohor' => '13:12', 'Asar' => '16:26','Maghrib' => '19:15', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:37','Subuh' => '05:47', 'Syuruk' => '07:04','Zohor' => '13:12', 'Asar' => '16:25','Maghrib' => '19:14', 'Isyak' => '20:24'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:04','Zohor' => '13:11', 'Asar' => '16:24','Maghrib' => '19:14', 'Isyak' => '20:24'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:04','Zohor' => '13:11', 'Asar' => '16:24','Maghrib' => '19:14', 'Isyak' => '20:24'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:03','Zohor' => '13:11', 'Asar' => '16:23','Maghrib' => '19:13', 'Isyak' => '20:23'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:03','Zohor' => '13:11', 'Asar' => '16:22','Maghrib' => '19:13', 'Isyak' => '20:23'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:03','Zohor' => '13:10', 'Asar' => '16:22','Maghrib' => '19:13', 'Isyak' => '20:22'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:03','Zohor' => '13:10', 'Asar' => '16:21','Maghrib' => '19:12', 'Isyak' => '20:22'),
			array('kod_kawasan' => 'JHR03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:02','Zohor' => '13:10', 'Asar' => '16:20','Maghrib' => '19:12', 'Isyak' => '20:22'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:35','Subuh' => '05:45', 'Syuruk' => '07:05','Zohor' => '13:14', 'Asar' => '16:35','Maghrib' => '19:18', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:35','Subuh' => '05:45', 'Syuruk' => '07:05','Zohor' => '13:14', 'Asar' => '16:35','Maghrib' => '19:18', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:05','Zohor' => '13:14', 'Asar' => '16:34','Maghrib' => '19:18', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:05','Zohor' => '13:14', 'Asar' => '16:34','Maghrib' => '19:18', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:05','Zohor' => '13:14', 'Asar' => '16:34','Maghrib' => '19:17', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:05','Zohor' => '13:14', 'Asar' => '16:33','Maghrib' => '19:17', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:05','Zohor' => '13:14', 'Asar' => '16:33','Maghrib' => '19:17', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:05','Zohor' => '13:14', 'Asar' => '16:33','Maghrib' => '19:17', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:32','Maghrib' => '19:17', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:32','Maghrib' => '19:17', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:31','Maghrib' => '19:16', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:31','Maghrib' => '19:16', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:05','Zohor' => '13:13', 'Asar' => '16:30','Maghrib' => '19:16', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:04','Zohor' => '13:13', 'Asar' => '16:30','Maghrib' => '19:16', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '15-08-2011', 'hari' => '05', 'Imsak' => '36','Subuh' => '05:46', 'Syuruk' => '07:04','Zohor' => '13:12', 'Asar' => '16:29','Maghrib' => '19:16', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:04','Zohor' => '13:12', 'Asar' => '16:29','Maghrib' => '19:15', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:04','Zohor' => '13:12', 'Asar' => '16:28','Maghrib' => '19:15', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:04','Zohor' => '13:12', 'Asar' => '16:28','Maghrib' => '19:15', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:04','Zohor' => '13:12', 'Asar' => '16:27','Maghrib' => '19:15', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:03','Zohor' => '13:11', 'Asar' => '16:27','Maghrib' => '19:14', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:36','Subuh' => '05:46', 'Syuruk' => '07:03','Zohor' => '13:11', 'Asar' => '16:26','Maghrib' => '19:14', 'Isyak' => '20:24'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:35','Subuh' => '05:45', 'Syuruk' => '07:03','Zohor' => '13:11', 'Asar' => '16:25','Maghrib' => '19:14', 'Isyak' => '20:24'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:35','Subuh' => '05:45', 'Syuruk' => '07:03','Zohor' => '13:11', 'Asar' => '16:25','Maghrib' => '19:13', 'Isyak' => '20:24'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:35','Subuh' => '05:45', 'Syuruk' => '07:03','Zohor' => '13:10', 'Asar' => '16:24','Maghrib' => '19:13', 'Isyak' => '20:23'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:35','Subuh' => '05:45', 'Syuruk' => '07:02','Zohor' => '13:10', 'Asar' => '16:23','Maghrib' => '19:13', 'Isyak' => '20:23'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:35','Subuh' => '05:45', 'Syuruk' => '07:02','Zohor' => '13:10', 'Asar' => '16:22','Maghrib' => '19:12', 'Isyak' => '20:22'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:35','Subuh' => '05:45', 'Syuruk' => '07:02','Zohor' => '13:10', 'Asar' => '16:22','Maghrib' => '19:12', 'Isyak' => '20:22'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:35','Subuh' => '05:45', 'Syuruk' => '07:02','Zohor' => '13:09', 'Asar' => '16:21','Maghrib' => '19:12', 'Isyak' => '20:22'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:35','Subuh' => '05:45', 'Syuruk' => '07:01','Zohor' => '13:09', 'Asar' => '16:20','Maghrib' => '19:11', 'Isyak' => '20:21'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:34','Subuh' => '05:44', 'Syuruk' => '07:01','Zohor' => '13:09', 'Asar' => '16:19','Maghrib' => '19:11', 'Isyak' => '20:21'),
			array('kod_kawasan' => 'JHR02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:34','Subuh' => '05:44', 'Syuruk' => '07:01','Zohor' => '13:08', 'Asar' => '16:19','Maghrib' => '19:11', 'Isyak' => '20:20'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '07:01','Zohor' => '13:11', 'Asar' => '16:32','Maghrib' => '19:16', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '07:01','Zohor' => '13:11', 'Asar' => '16:31','Maghrib' => '19:16', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '07:01','Zohor' => '13:11', 'Asar' => '16:31','Maghrib' => '19:16', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '07:01','Zohor' => '13:11', 'Asar' => '16:31','Maghrib' => '19:16', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '07:01','Zohor' => '13:11', 'Asar' => '16:30','Maghrib' => '19:15', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '07:01','Zohor' => '13:11', 'Asar' => '16:30','Maghrib' => '19:15', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:01','Zohor' => '13:11', 'Asar' => '16:30','Maghrib' => '19:15', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:01','Zohor' => '13:10', 'Asar' => '16:29','Maghrib' => '19:15', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:01','Zohor' => '13:10', 'Asar' => '16:29','Maghrib' => '19:15', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:01','Zohor' => '13:10', 'Asar' => '16:28','Maghrib' => '19:14', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:01','Zohor' => '13:10', 'Asar' => '16:28','Maghrib' => '19:14', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:01','Zohor' => '13:10', 'Asar' => '16:27','Maghrib' => '19:14', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:00','Zohor' => '13:10', 'Asar' => '16:27','Maghrib' => '19:14', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:00','Zohor' => '13:09', 'Asar' => '16:26','Maghrib' => '19:14', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:00','Zohor' => '13:09', 'Asar' => '16:26','Maghrib' => '19:13', 'Isyak' => '20:24'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:00','Zohor' => '13:09', 'Asar' => '16:25','Maghrib' => '19:13', 'Isyak' => '20:24'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:00','Zohor' => '13:09', 'Asar' => '16:25','Maghrib' => '19:13', 'Isyak' => '20:24'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:00','Zohor' => '13:09', 'Asar' => '16:24','Maghrib' => '19:13', 'Isyak' => '20:23'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '07:00','Zohor' => '13:08', 'Asar' => '16:23','Maghrib' => '19:12', 'Isyak' => '20:23'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '06:59','Zohor' => '13:08', 'Asar' => '16:23','Maghrib' => '19:12', 'Isyak' => '20:23'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:32','Subuh' => '05:42', 'Syuruk' => '06:59','Zohor' => '13:08', 'Asar' => '16:22','Maghrib' => '19:12', 'Isyak' => '20:22'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '06:59','Zohor' => '13:08', 'Asar' => '16:21','Maghrib' => '19:11', 'Isyak' => '20:22'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '06:59','Zohor' => '13:08', 'Asar' => '16:21','Maghrib' => '19:11', 'Isyak' => '20:21'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '06:59','Zohor' => '13:07', 'Asar' => '16:20','Maghrib' => '19:11', 'Isyak' => '20:21'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '06:59','Zohor' => '13:07', 'Asar' => '16:19','Maghrib' => '19:10', 'Isyak' => '20:20'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '06:58','Zohor' => '13:07', 'Asar' => '16:19','Maghrib' => '19:10', 'Isyak' => '20:20'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '06:58','Zohor' => '13:06', 'Asar' => '16:18','Maghrib' => '19:10', 'Isyak' => '20:20'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '06:58','Zohor' => '13:06', 'Asar' => '16:17','Maghrib' => '19:09', 'Isyak' => '20:19'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '06:58','Zohor' => '13:06', 'Asar' => '16:16','Maghrib' => '19:09', 'Isyak' => '20:19'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:31','Subuh' => '05:41', 'Syuruk' => '06:57','Zohor' => '13:06', 'Asar' => '16:15','Maghrib' => '19:09', 'Isyak' => '20:18'),
			array('kod_kawasan' => 'JHR01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:30','Subuh' => '05:40', 'Syuruk' => '06:57','Zohor' => '13:05', 'Asar' => '16:14','Maghrib' => '19:08', 'Isyak' => '20:18'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:27', 'Asar' => '16:47','Maghrib' => '19:38', 'Isyak' => '20:51'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:27', 'Asar' => '16:47','Maghrib' => '19:38', 'Isyak' => '20:51'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:11','Zohor' => '13:27', 'Asar' => '16:47','Maghrib' => '19:37', 'Isyak' => '20:51'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:27', 'Asar' => '16:46','Maghrib' => '19:37', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:27', 'Asar' => '16:46','Maghrib' => '19:37', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:27', 'Asar' => '16:45','Maghrib' => '19:37', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:27', 'Asar' => '16:45','Maghrib' => '19:37', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:44','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:44','Maghrib' => '19:36', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:43','Maghrib' => '19:36', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:43','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:42','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:41','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:41','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:40','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:39','Maghrib' => '19:34', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:11','Zohor' => '13:25', 'Asar' => '16:39','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:11','Zohor' => '13:25', 'Asar' => '16:38','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:25', 'Asar' => '16:37','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:37','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:36','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:35','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:34','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:33','Maghrib' => '19:31', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:32','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:32','Maghrib' => '19:30', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:31','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:30','Maghrib' => '19:29', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:29','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:28','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:27','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KDH01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:27','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:27', 'Asar' => '16:47','Maghrib' => '19:37', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:47','Maghrib' => '19:37', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:36', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:45','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:45','Maghrib' => '19:36', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:44','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:44','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:43','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:43','Maghrib' => '19:34', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:42','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:41','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:41','Maghrib' => '19:34', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:40','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:39','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:24', 'Asar' => '16:39','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:24', 'Asar' => '16:38','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:24', 'Asar' => '16:37','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:37','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:36','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:35','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:34','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:33','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:33','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:32','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:31','Maghrib' => '19:29', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:30','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:29','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:28','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:27','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'KDH02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:27','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:08','Zohor' => '13:26', 'Asar' => '16:47','Maghrib' => '19:41', 'Isyak' => '20:54'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:08','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:41', 'Isyak' => '20:54'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:09','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:40', 'Isyak' => '20:53'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:09','Zohor' => '13:26', 'Asar' => '16:45','Maghrib' => '19:40', 'Isyak' => '20:53'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:09','Zohor' => '13:26', 'Asar' => '16:45','Maghrib' => '19:40', 'Isyak' => '20:53'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:09','Zohor' => '13:26', 'Asar' => '16:45','Maghrib' => '19:40', 'Isyak' => '20:52'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:09','Zohor' => '13:26', 'Asar' => '16:44','Maghrib' => '19:39', 'Isyak' => '20:52'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:25', 'Asar' => '16:44','Maghrib' => '19:39', 'Isyak' => '20:52'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:25', 'Asar' => '16:43','Maghrib' => '19:39', 'Isyak' => '20:51'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:25', 'Asar' => '16:43','Maghrib' => '19:39', 'Isyak' => '20:51'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:25', 'Asar' => '16:42','Maghrib' => '19:38', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:25', 'Asar' => '16:41','Maghrib' => '19:38', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:25', 'Asar' => '16:41','Maghrib' => '19:38', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:25', 'Asar' => '16:40','Maghrib' => '19:37', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:24', 'Asar' => '16:40','Maghrib' => '19:37', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:08','Zohor' => '13:24', 'Asar' => '16:39','Maghrib' => '19:37', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:24', 'Asar' => '16:38','Maghrib' => '19:36', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:24', 'Asar' => '16:37','Maghrib' => '19:36', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:24', 'Asar' => '16:37','Maghrib' => '19:36', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:23', 'Asar' => '16:36','Maghrib' => '19:35', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:23', 'Asar' => '16:35','Maghrib' => '19:35', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:23', 'Asar' => '16:34','Maghrib' => '19:34', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:23', 'Asar' => '16:34','Maghrib' => '19:34', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:22', 'Asar' => '16:33','Maghrib' => '19:34', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:22', 'Asar' => '16:32','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:22', 'Asar' => '16:31','Maghrib' => '19:33', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:21', 'Asar' => '16:30','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:21', 'Asar' => '16:29','Maghrib' => '19:32', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:21', 'Asar' => '16:28','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:21', 'Asar' => '16:27','Maghrib' => '19:31', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:26','Maghrib' => '19:31', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH06', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:26','Maghrib' => '19:31', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:47','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:45','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:45','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:44','Maghrib' => '19:34', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:44','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:43','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:43','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:42','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:42','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:41','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:24', 'Asar' => '16:40','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:24', 'Asar' => '16:40','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:24', 'Asar' => '16:39','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:39','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:38','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:37','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:36','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:36','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:35','Maghrib' => '19:30', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:34','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:33','Maghrib' => '19:29', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:33','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:32','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:31','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:30','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:29','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:20', 'Asar' => '16:28','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:20', 'Asar' => '16:27','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'KDH04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:20', 'Asar' => '16:27','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:14','Zohor' => '13:29', 'Asar' => '16:50','Maghrib' => '19:40', 'Isyak' => '20:54'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:14','Zohor' => '13:29', 'Asar' => '16:49','Maghrib' => '19:40', 'Isyak' => '20:53'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:14','Zohor' => '13:29', 'Asar' => '16:49','Maghrib' => '19:40', 'Isyak' => '20:53'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:14','Zohor' => '13:29', 'Asar' => '16:48','Maghrib' => '19:40', 'Isyak' => '20:53'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:14','Zohor' => '13:29', 'Asar' => '16:48','Maghrib' => '19:39', 'Isyak' => '20:52'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:14','Zohor' => '13:29', 'Asar' => '16:47','Maghrib' => '19:39', 'Isyak' => '20:52'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:14','Zohor' => '13:29', 'Asar' => '16:47','Maghrib' => '19:39', 'Isyak' => '20:52'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:14','Zohor' => '13:29', 'Asar' => '16:46','Maghrib' => '19:39', 'Isyak' => '20:51'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:14','Zohor' => '13:29', 'Asar' => '16:46','Maghrib' => '19:38', 'Isyak' => '20:51'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:14','Zohor' => '13:28', 'Asar' => '16:45','Maghrib' => '19:38', 'Isyak' => '20:51'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:14','Zohor' => '13:28', 'Asar' => '16:45','Maghrib' => '19:38', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:14','Zohor' => '13:28', 'Asar' => '16:44','Maghrib' => '19:38', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:14','Zohor' => '13:28', 'Asar' => '16:44','Maghrib' => '19:37', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:14','Zohor' => '13:28', 'Asar' => '16:43','Maghrib' => '19:37', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:14','Zohor' => '13:28', 'Asar' => '16:42','Maghrib' => '19:37', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:14','Zohor' => '13:27', 'Asar' => '16:42','Maghrib' => '19:36', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:14','Zohor' => '13:27', 'Asar' => '16:41','Maghrib' => '19:36', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:14','Zohor' => '13:27', 'Asar' => '16:40','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:27', 'Asar' => '16:39','Maghrib' => '19:35', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:27', 'Asar' => '16:39','Maghrib' => '19:35', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:26', 'Asar' => '16:38','Maghrib' => '19:34', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:26', 'Asar' => '16:37','Maghrib' => '19:34', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:26', 'Asar' => '16:36','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:26', 'Asar' => '16:35','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:25', 'Asar' => '16:34','Maghrib' => '19:33', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:25', 'Asar' => '16:33','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:25', 'Asar' => '16:33','Maghrib' => '19:32', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:32','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:31','Maghrib' => '19:31', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:30','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:29','Maghrib' => '19:30', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'KDH05', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:47','Subuh' => '5:57', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:29','Maghrib' => '19:30', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:37', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:36', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:26', 'Asar' => '16:45','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:26', 'Asar' => '16:45','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:26', 'Asar' => '16:44','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:44','Maghrib' => '19:36', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:44','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:43','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:43','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:42','Maghrib' => '19:34', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:41','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:41','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:40','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:40','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:39','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:38','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:38','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:23', 'Asar' => '16:37','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:23', 'Asar' => '16:36','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:23', 'Asar' => '16:36','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:23', 'Asar' => '16:35','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:23', 'Asar' => '16:34','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:22', 'Asar' => '16:33','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:22', 'Asar' => '16:32','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:22', 'Asar' => '16:32','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:21', 'Asar' => '16:31','Maghrib' => '19:29', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:21', 'Asar' => '16:30','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:21', 'Asar' => '16:29','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:21', 'Asar' => '16:28','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:27','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:26','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'KDH03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:26','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:10','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:31', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:10','Zohor' => '13:22', 'Asar' => '16:42','Maghrib' => '19:31', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:10','Zohor' => '13:22', 'Asar' => '16:42','Maghrib' => '19:31', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:10','Zohor' => '13:22', 'Asar' => '16:42','Maghrib' => '19:30', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:10','Zohor' => '13:22', 'Asar' => '16:41','Maghrib' => '19:30', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:10','Zohor' => '13:22', 'Asar' => '16:41','Maghrib' => '19:30', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:40','Maghrib' => '19:30', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:40','Maghrib' => '19:29', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:39','Maghrib' => '19:29', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:39','Maghrib' => '19:29', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:38','Maghrib' => '19:29', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:38','Maghrib' => '19:28', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:37','Maghrib' => '19:28', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:10','Zohor' => '13:20', 'Asar' => '16:37','Maghrib' => '19:28', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:10','Zohor' => '13:20', 'Asar' => '16:36','Maghrib' => '19:28', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:10','Zohor' => '13:20', 'Asar' => '16:35','Maghrib' => '19:27', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:09','Zohor' => '13:20', 'Asar' => '16:35','Maghrib' => '19:27', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:09','Zohor' => '13:20', 'Asar' => '16:34','Maghrib' => '19:27', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:33','Maghrib' => '19:26', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:33','Maghrib' => '19:26', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:32','Maghrib' => '19:26', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:31','Maghrib' => '19:25', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:30','Maghrib' => '19:25', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:29','Maghrib' => '19:24', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:29','Maghrib' => '19:24', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:08','Zohor' => '13:18', 'Asar' => '16:28','Maghrib' => '19:24', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:27','Maghrib' => '19:23', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16;26','Maghrib' => '19:23', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:25','Maghrib' => '19:22', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:08','Zohor' => '13:16', 'Asar' => '16:24','Maghrib' => '19:22', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:08','Zohor' => '13:16', 'Asar' => '16:23','Maghrib' => '19:21', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'KTN03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:08','Zohor' => '13:16', 'Asar' => '16:23','Maghrib' => '19:21', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:40','Maghrib' => '19:30', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:40','Maghrib' => '19:30', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:40','Maghrib' => '19:30', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:39','Maghrib' => '19:30', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:39','Maghrib' => '19:30', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:38','Maghrib' => '19:29', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:19', 'Asar' => '16:38','Maghrib' => '19:29', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:19', 'Asar' => '16:37','Maghrib' => '19:29', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:19', 'Asar' => '16:37','Maghrib' => '19:29', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:19', 'Asar' => '16:36','Maghrib' => '19:28', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:19', 'Asar' => '16:36','Maghrib' => '19:28', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:19', 'Asar' => '16:35','Maghrib' => '19:28', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:07','Zohor' => '13:19', 'Asar' => '16:34','Maghrib' => '19:27', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:07','Zohor' => '13:18', 'Asar' => '16:34','Maghrib' => '19:27', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:07','Zohor' => '13:18', 'Asar' => '16:33','Maghrib' => '19:27', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:07','Zohor' => '13:18', 'Asar' => '16:32','Maghrib' => '19:26', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:07','Zohor' => '13:18', 'Asar' => '16:32','Maghrib' => '19:26', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:31','Maghrib' => '19:26', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:30','Maghrib' => '19:25', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:30','Maghrib' => '19:25', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:29','Maghrib' => '19:25', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:28','Maghrib' => '19:24', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:06','Zohor' => '13:16', 'Asar' => '16:27','Maghrib' => '19:24', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:06','Zohor' => '13:16', 'Asar' => '16:26','Maghrib' => '19:23', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:06','Zohor' => '13:16', 'Asar' => '16:25','Maghrib' => '19:23', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:06','Zohor' => '13:16', 'Asar' => '16:25','Maghrib' => '19:22', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:06','Zohor' => '13:15', 'Asar' => '16:24','Maghrib' => '19:22', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:23','Maghrib' => '19:22', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:22','Maghrib' => '19:21', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:05','Zohor' => '13:14', 'Asar' => '16:21','Maghrib' => '19:21', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:05','Zohor' => '13:14', 'Asar' => '16:20','Maghrib' => '19:20', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'KTN01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:05','Zohor' => '13:14', 'Asar' => '16:20','Maghrib' => '19:20', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:11','Zohor' => '13:20', 'Asar' => '16:41','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:11','Zohor' => '13:20', 'Asar' => '16:41','Maghrib' => '19:25', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:11','Zohor' => '13:20', 'Asar' => '16:41','Maghrib' => '19:25', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:11','Zohor' => '13:20', 'Asar' => '16:41','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:20', 'Asar' => '16:40','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:20', 'Asar' => '16:40','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:20', 'Asar' => '16:39','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:19', 'Asar' => '16:39','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:19', 'Asar' => '16:39','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:19', 'Asar' => '16:38','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:19', 'Asar' => '16:38','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:19', 'Asar' => '16:37','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:19', 'Asar' => '16:37','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:18', 'Asar' => '16:36','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:18', 'Asar' => '16:36','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:18', 'Asar' => '16:35','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:18', 'Asar' => '16:35','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:18', 'Asar' => '16:34','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:17', 'Asar' => '16:33','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:17', 'Asar' => '16:33','Maghrib' => '19:22', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:09','Zohor' => '13:17', 'Asar' => '16:32','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:09','Zohor' => '13:17', 'Asar' => '16:31','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:09','Zohor' => '13:16', 'Asar' => '16:31','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:09','Zohor' => '13:16', 'Asar' => '16:30','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:09','Zohor' => '13:16', 'Asar' => '16:29','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:16', 'Asar' => '16:29','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:15', 'Asar' => '16:28','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:15', 'Asar' => '16:27','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:15', 'Asar' => '16:26','Maghrib' => '19:19', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:07','Zohor' => '13:14', 'Asar' => '16:25','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:40','Subuh' => '05:50', 'Syuruk' => '07:07','Zohor' => '13:14', 'Asar' => '16:25','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'MLK01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:40','Subuh' => '05:50', 'Syuruk' => '07:07','Zohor' => '13:14', 'Asar' => '16:25','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:40','Maghrib' => '19:25', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:40','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:39','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:39','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:39','Maghrib' => '19:24', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:38','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:38','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:38','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:37','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:37','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:36','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:36','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:35','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:35','Maghrib' => '19:22', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:34','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:33','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:33','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:16', 'Asar' => '16:32','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:16', 'Asar' => '16:32','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:16', 'Asar' => '16:31','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:16', 'Asar' => '16:30','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:15', 'Asar' => '16:30','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:15', 'Asar' => '16:29','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:15', 'Asar' => '16:28','Maghrib' => '19:19', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:07','Zohor' => '13:15', 'Asar' => '16:27','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:07','Zohor' => '13:14', 'Asar' => '16:27','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:06','Zohor' => '13:14', 'Asar' => '16:26','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:06','Zohor' => '13:14', 'Asar' => '16:25','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:06','Zohor' => '13:13', 'Asar' => '16:24','Maghrib' => '19:18', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:06','Zohor' => '13:13', 'Asar' => '16:23','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:06','Zohor' => '13:13', 'Asar' => '16:23','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'NGS01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:06','Zohor' => '13:13', 'Asar' => '16:23','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:42','Maghrib' => '19:27', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:42','Maghrib' => '19:26', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:42','Maghrib' => '19:26', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:41','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:20', 'Asar' => '16:41','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:20', 'Asar' => '16:41','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:20', 'Asar' => '16:40','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:20', 'Asar' => '16:40','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:20', 'Asar' => '16:39','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:39','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:38','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:38','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:37','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:37','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:36','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:36','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:35','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:35','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:34','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:33','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:33','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:17', 'Asar' => '16:32','Maghrib' => '19:22', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:17', 'Asar' => '16:31','Maghrib' => '19:22', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:31','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:30','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:16', 'Asar' => '16:29','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:16', 'Asar' => '16:28','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:09','Zohor' => '13:16', 'Asar' => '16:28','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:08','Zohor' => '13:15', 'Asar' => '16:27','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:08','Zohor' => '13:15', 'Asar' => '16:26','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:08','Zohor' => '13:15', 'Asar' => '16:25','Maghrib' => '19:19', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'NGS02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:08','Zohor' => '13:15', 'Asar' => '16:25','Maghrib' => '19:19', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:42','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:42','Maghrib' => '19:28', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:42','Maghrib' => '19:28', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:41','Maghrib' => '19:28', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:41','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:40','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:10','Zohor' => '13:21', 'Asar' => '16:40','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:10','Zohor' => '13:20', 'Asar' => '16:39','Maghrib' => '19:27', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:10','Zohor' => '13:20', 'Asar' => '16:39','Maghrib' => '19:27', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:10','Zohor' => '13:20', 'Asar' => '16:39','Maghrib' => '19:27', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:10','Zohor' => '13:20', 'Asar' => '16:38','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:10','Zohor' => '13:20', 'Asar' => '16:38','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:10','Zohor' => '13:20', 'Asar' => '16:37','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:10','Zohor' => '13:20', 'Asar' => '16:36','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:10','Zohor' => '13:19', 'Asar' => '16:36','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:10','Zohor' => '13:19', 'Asar' => '16:35','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:10','Zohor' => '13:19', 'Asar' => '16:35','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:34','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:33','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:33','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:32','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:31','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:30','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:30','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:29','Maghrib' => '19:22', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:28','Maghrib' => '19:22', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:27','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:08','Zohor' => '13:16', 'Asar' => '16:26','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:08','Zohor' => '13:16', 'Asar' => '16:25','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:16', 'Asar' => '16:25','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:15', 'Asar' => '16:24','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:15', 'Asar' => '16:24','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:05','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:37', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:05','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:36', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:36', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:22', 'Asar' => '16:42','Maghrib' => '19:36', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:22', 'Asar' => '16:42','Maghrib' => '19:36', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:22', 'Asar' => '16:41','Maghrib' => '19:36', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:22', 'Asar' => '16:41','Maghrib' => '19:35', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:22', 'Asar' => '16:41','Maghrib' => '19:35', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:22', 'Asar' => '16:40','Maghrib' => '19:35', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:22', 'Asar' => '16:40','Maghrib' => '19:35', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:21', 'Asar' => '16:39','Maghrib' => '19:34', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:05','Zohor' => '13:21', 'Asar' => '16:39','Maghrib' => '19:34', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:05','Zohor' => '13:21', 'Asar' => '16:38','Maghrib' => '19:34', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:05','Zohor' => '13:21', 'Asar' => '16:37','Maghrib' => '19:33', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:05','Zohor' => '13:21', 'Asar' => '16:37','Maghrib' => '19:33', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:05','Zohor' => '13:21', 'Asar' => '16:36','Maghrib' => '19:33', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:05','Zohor' => '13:20', 'Asar' => '16:35','Maghrib' => '19:33', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:05','Zohor' => '13:20', 'Asar' => '16:35','Maghrib' => '19:32', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:04','Zohor' => '13:20', 'Asar' => '16:34','Maghrib' => '19:32', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:04','Zohor' => '13:20', 'Asar' => '16:33','Maghrib' => '19:31', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:04','Zohor' => '13:19', 'Asar' => '16:33','Maghrib' => '19:31', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:04','Zohor' => '13:19', 'Asar' => '16:32','Maghrib' => '19:31', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:04','Zohor' => '13:19', 'Asar' => '16:31','Maghrib' => '19:30', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:04','Zohor' => '13:19', 'Asar' => '16:30','Maghrib' => '19:30', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:04','Zohor' => '13:18', 'Asar' => '16:30','Maghrib' => '19:30', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:04','Zohor' => '13:18', 'Asar' => '16:29','Maghrib' => '19:29', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:03','Zohor' => '13:18', 'Asar' => '16:28','Maghrib' => '19:29', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:03','Zohor' => '13:18', 'Asar' => '16:27','Maghrib' => '19:28', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:03','Zohor' => '13:17', 'Asar' => '16:26','Maghrib' => '19:28', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:03','Zohor' => '13:17', 'Asar' => '16:25','Maghrib' => '19:28', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:03','Zohor' => '13:17', 'Asar' => '16:24','Maghrib' => '19:27', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'PHG06', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:03','Zohor' => '13:17', 'Asar' => '16:24','Maghrib' => '19:27', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:21', 'Asar' => '16:42','Maghrib' => '19:31', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:21', 'Asar' => '16:42','Maghrib' => '19:31', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:21', 'Asar' => '16:41','Maghrib' => '19:31', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:41','Maghrib' => '19:31', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:41','Maghrib' => '19:31', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:40','Maghrib' => '19:30', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:40','Maghrib' => '19:30', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:39','Maghrib' => '19:30', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:39','Maghrib' => '19:30', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:38','Maghrib' => '19:30', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:07','Zohor' => '13:20', 'Asar' => '16:38','Maghrib' => '19:29', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:06','Zohor' => '13:20', 'Asar' => '16:37','Maghrib' => '19:29', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:06','Zohor' => '13:19', 'Asar' => '16:37','Maghrib' => '19:29', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:06','Zohor' => '13:19', 'Asar' => '16:36','Maghrib' => '19:29', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:06','Zohor' => '13:19', 'Asar' => '16:36','Maghrib' => '19:28', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:06','Zohor' => '13:19', 'Asar' => '16:35','Maghrib' => '19:28', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:06','Zohor' => '13:19', 'Asar' => '16:35','Maghrib' => '19:28', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:34','Maghrib' => '19:27', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:33','Maghrib' => '19:27', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:33','Maghrib' => '19:27', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:18', 'Asar' => '16:32','Maghrib' => '19:26', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:18', 'Asar' => '16:31','Maghrib' => '19:26', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:17', 'Asar' => '16:31','Maghrib' => '19:26', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:17', 'Asar' => '16:30','Maghrib' => '19:25', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:17', 'Asar' => '16:29','Maghrib' => '19:25', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:28','Maghrib' => '19:25', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:04','Zohor' => '13:16', 'Asar' => '16:27','Maghrib' => '19:24', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:04','Zohor' => '13:16', 'Asar' => '16:27','Maghrib' => '19:24', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:04','Zohor' => '13:16', 'Asar' => '16:26','Maghrib' => '19:23', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:04','Zohor' => '13:15', 'Asar' => '16:25','Maghrib' => '19:23', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:04','Zohor' => '13:15', 'Asar' => '16:25','Maghrib' => '19:23', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'PHG05', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:04','Zohor' => '13:15', 'Asar' => '16:25','Maghrib' => '19:23', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:07','Zohor' => '13:17', 'Asar' => '16:38','Maghrib' => '19:23', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:07','Zohor' => '13:17', 'Asar' => '16:38','Maghrib' => '19:23', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:07','Zohor' => '13:17', 'Asar' => '16:38','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:07','Zohor' => '13:17', 'Asar' => '16:37','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:07','Zohor' => '13:17', 'Asar' => '16:37','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:07','Zohor' => '13:16', 'Asar' => '16:37','Maghrib' => '19:22', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:07','Zohor' => '13:16', 'Asar' => '16:36','Maghrib' => '19:22', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:07','Zohor' => '13:16', 'Asar' => '16:36','Maghrib' => '19:22', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:07','Zohor' => '13:16', 'Asar' => '16:35','Maghrib' => '19:22', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:07','Zohor' => '13:16', 'Asar' => '16:35','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:07','Zohor' => '13:16', 'Asar' => '16:34','Maghrib' => '19:21', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:07','Zohor' => '13:16', 'Asar' => '16:34','Maghrib' => '19:21', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:07','Zohor' => '13:16', 'Asar' => '16:33','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:07','Zohor' => '13:15', 'Asar' => '16:33','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:06','Zohor' => '13:15', 'Asar' => '16:32','Maghrib' => '19:20', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:06','Zohor' => '13:15', 'Asar' => '16:32','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:06','Zohor' => '13:15', 'Asar' => '16:31','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:06','Zohor' => '13:15', 'Asar' => '16:30','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:06','Zohor' => '13:14', 'Asar' => '16:30','Maghrib' => '19:19', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:06','Zohor' => '13:14', 'Asar' => '16:29','Maghrib' => '19:19', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:06','Zohor' => '13:14', 'Asar' => '16:28','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:05','Zohor' => '13:14', 'Asar' => '16:28','Maghrib' => '19:18', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:05','Zohor' => '13:13', 'Asar' => '16:27','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:38','Subuh' => '5:48', 'Syuruk' => '7:05','Zohor' => '13:13', 'Asar' => '16:26','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:13', 'Asar' => '16:26','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:13', 'Asar' => '16:25','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:12', 'Asar' => '16:24','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:12', 'Asar' => '16:23','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:12', 'Asar' => '16:22','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:12', 'Asar' => '16:21','Maghrib' => '19:15', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:11', 'Asar' => '16:21','Maghrib' => '19:15', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'PHG02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:11', 'Asar' => '16:21','Maghrib' => '19:15', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:20', 'Asar' => '16:41','Maghrib' => '19:26', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:40','Maghrib' => '19:26', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:40','Maghrib' => '19:26', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:40','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:39','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:39','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:39','Maghrib' => '19:25', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:38','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:38','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:37','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:19', 'Asar' => '16:37','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:36','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:36','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:35','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:35','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:09','Zohor' => '13:18', 'Asar' => '16:34','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:33','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:33','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:32','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:31','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:17', 'Asar' => '16:31','Maghrib' => '19:22', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:16', 'Asar' => '16:30','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:08','Zohor' => '13:16', 'Asar' => '16:29','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:16', 'Asar' => '16:29','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:16', 'Asar' => '16:28','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:15', 'Asar' => '16:27','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:15', 'Asar' => '16:26','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:15', 'Asar' => '16:25','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:40','Subuh' => '5:50', 'Syuruk' => '7:07','Zohor' => '13:14', 'Asar' => '16:25','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:06','Zohor' => '13:14', 'Asar' => '16:24','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:06','Zohor' => '13:14', 'Asar' => '16:23','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'PHG03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:39','Subuh' => '5:49', 'Syuruk' => '7:06','Zohor' => '13:14', 'Asar' => '16:23','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:33','Maghrib' => '19:17', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:33','Maghrib' => '19:17', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:32','Maghrib' => '19:17', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:32','Maghrib' => '19:17', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:32','Maghrib' => '19:17', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:31','Maghrib' => '19:17', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:31','Maghrib' => '19:17', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:30','Maghrib' => '19:16', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:30','Maghrib' => '19:16', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:29','Maghrib' => '19:16', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:02','Zohor' => '13:10', 'Asar' => '16:29','Maghrib' => '19:16', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:02','Zohor' => '13:10', 'Asar' => '16:29','Maghrib' => '19:15', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:02','Zohor' => '13:10', 'Asar' => '16:28','Maghrib' => '19:15', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:01','Zohor' => '13:10', 'Asar' => '16:27','Maghrib' => '19:15', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:01','Zohor' => '13:10', 'Asar' => '16:27','Maghrib' => '19:15', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:01','Zohor' => '13:10', 'Asar' => '16:26','Maghrib' => '19:14', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:01','Zohor' => '13:09', 'Asar' => '16:26','Maghrib' => '19:14', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:01','Zohor' => '13:09', 'Asar' => '16:25','Maghrib' => '19:14', 'Isyak' => '20:25'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:01','Zohor' => '13:09', 'Asar' => '16:25','Maghrib' => '19:14', 'Isyak' => '20:24'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:01','Zohor' => '13:09', 'Asar' => '16:24','Maghrib' => '19:13', 'Isyak' => '20:24'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:00','Zohor' => '13:08', 'Asar' => '16:23','Maghrib' => '19:13', 'Isyak' => '20:23'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '7:00','Zohor' => '13:08', 'Asar' => '16:23','Maghrib' => '19:13', 'Isyak' => '20:23'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '7:00','Zohor' => '13:08', 'Asar' => '16:22','Maghrib' => '19:12', 'Isyak' => '20:23'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '7:00','Zohor' => '13:08', 'Asar' => '16:21','Maghrib' => '19:12', 'Isyak' => '20:22'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '7:00','Zohor' => '13:07', 'Asar' => '16:20','Maghrib' => '19:12', 'Isyak' => '20:22'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '6:59','Zohor' => '13:07', 'Asar' => '16:20','Maghrib' => '19:11', 'Isyak' => '20:21'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '6:59','Zohor' => '13:07', 'Asar' => '16:19','Maghrib' => '19:11', 'Isyak' => '20:21'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '6:59','Zohor' => '13:07', 'Asar' => '16:18','Maghrib' => '19:11', 'Isyak' => '20:20'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '6:59','Zohor' => '13:06', 'Asar' => '16:17','Maghrib' => '19:10', 'Isyak' => '20:20'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '6:59','Zohor' => '13:06', 'Asar' => '16:16','Maghrib' => '19:10', 'Isyak' => '20:20'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '6:58','Zohor' => '13:06', 'Asar' => '16:16','Maghrib' => '19:09', 'Isyak' => '20:19'),
			array('kod_kawasan' => 'PHG01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:32','Subuh' => '5:42', 'Syuruk' => '6:58','Zohor' => '13:06', 'Asar' => '16:16','Maghrib' => '19:09', 'Isyak' => '20:19'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:45','Maghrib' => '19:34', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:45','Maghrib' => '19:34', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:44','Maghrib' => '19:34', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:44','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:43','Maghrib' => '19:33', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:43','Maghrib' => '19:33', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:42','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:42','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:41','Maghrib' => '19:32', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:41','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:23', 'Asar' => '16:40','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:23', 'Asar' => '16:40','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:10','Zohor' => '13:23', 'Asar' => '16:39','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:23', 'Asar' => '16:39','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:23', 'Asar' => '16:38','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:37','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:37','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:36','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:22', 'Asar' => '16:35','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:22', 'Asar' => '16:34','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:21', 'Asar' => '16:34','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:21', 'Asar' => '16:33','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:21', 'Asar' => '16:32','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:21', 'Asar' => '16:31','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:20', 'Asar' => '16:30','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:20', 'Asar' => '16:30','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:29','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:28','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:08','Zohor' => '13:19', 'Asar' => '16:27','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:08','Zohor' => '13:19', 'Asar' => '16:26','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:08','Zohor' => '13:19', 'Asar' => '16:25','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PRK03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:08','Zohor' => '13:19', 'Asar' => '16:25','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:45','Maghrib' => '19:32', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:44','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:44','Maghrib' => '19:31', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:44','Maghrib' => '19:31', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:43','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:43','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:42','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:42','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:41','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:41','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:40','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:40','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:39','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:39','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:38','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:37','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:37','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:36','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:36','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:35','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:34','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:20', 'Asar' => '16:33','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:20', 'Asar' => '16:33','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:20', 'Asar' => '16:32','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:20', 'Asar' => '16:31','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:19', 'Asar' => '16:30','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:19', 'Asar' => '16:29','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:08','Zohor' => '13:19', 'Asar' => '16:29','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:08','Zohor' => '13:18', 'Asar' => '16:28','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:08','Zohor' => '13:18', 'Asar' => '16:27','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:08','Zohor' => '13:18', 'Asar' => '16:26','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PRK01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:08','Zohor' => '13:18', 'Asar' => '16:26','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:13','Zohor' => '13:26', 'Asar' => '16:47','Maghrib' => '19:34', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:13','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:13','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:33', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:13','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:33', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:13','Zohor' => '13:26', 'Asar' => '16:45','Maghrib' => '19:33', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:13','Zohor' => '13:25', 'Asar' => '16:45','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:13','Zohor' => '13:25', 'Asar' => '16:45','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:44','Maghrib' => '19:32', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:44','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:43','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:43','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:42','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:24', 'Asar' => '16:41','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:24', 'Asar' => '16:41','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:46','Subuh' => '05:56', 'Syuruk' => '07:12','Zohor' => '13:24', 'Asar' => '16:40','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:46','Subuh' => '05:56', 'Syuruk' => '07:12','Zohor' => '13:24', 'Asar' => '16:40','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:46','Subuh' => '05:56', 'Syuruk' => '07:12','Zohor' => '13:24', 'Asar' => '16:39','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:46','Subuh' => '05:56', 'Syuruk' => '07:12','Zohor' => '13:23', 'Asar' => '16:38','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:46','Subuh' => '05:56', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:38','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:46','Subuh' => '05:56', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:37','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:46','Subuh' => '05:56', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:36','Maghrib' => '19:29', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:36','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:35','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:34','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:22', 'Asar' => '16:33','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:32','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:32','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:31','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:30','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:20', 'Asar' => '16:29','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:09','Zohor' => '13:20', 'Asar' => '16:28','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK05', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:09','Zohor' => '13:20', 'Asar' => '16:28','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:46','Maghrib' => '19:33', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:46','Maghrib' => '19:33', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:45','Maghrib' => '19:33', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:45','Maghrib' => '19:33', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:44','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:44','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:25', 'Asar' => '16:44','Maghrib' => '19:32', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:43','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:43','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:42','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:42','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:41','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:41','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:24', 'Asar' => '16:40','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:23', 'Asar' => '16:39','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:23', 'Asar' => '16:39','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:23', 'Asar' => '16:38','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:23', 'Asar' => '16:37','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:37','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:22', 'Asar' => '16:36','Maghrib' => '19:29', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:22', 'Asar' => '16:35','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:22', 'Asar' => '16:35','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:22', 'Asar' => '16:34','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:21', 'Asar' => '16:33','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:21', 'Asar' => '16:32','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:21', 'Asar' => '16:31','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:31','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:30','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:29','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:28','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:19', 'Asar' => '16:27','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PRK02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:19', 'Asar' => '16:27','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:08','Zohor' => '13:23', 'Asar' => '16:44','Maghrib' => '19:33', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:39','Subuh' => '05:49', 'Syuruk' => '07:08','Zohor' => '13:23', 'Asar' => '16:43','Maghrib' => '19:33', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:40','Subuh' => '05:50', 'Syuruk' => '07:08','Zohor' => '13:23', 'Asar' => '16:43','Maghrib' => '19:32', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:40','Subuh' => '05:50', 'Syuruk' => '07:08','Zohor' => '13:23', 'Asar' => '16:42','Maghrib' => '19:32', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:40','Subuh' => '05:50', 'Syuruk' => '07:08','Zohor' => '13:23', 'Asar' => '16:42','Maghrib' => '19:32', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:40','Subuh' => '05:50', 'Syuruk' => '07:08','Zohor' => '13:23', 'Asar' => '16:42','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:40','Subuh' => '05:50', 'Syuruk' => '07:08','Zohor' => '13:23', 'Asar' => '16:41','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:40','Subuh' => '05:50', 'Syuruk' => '07:08','Zohor' => '13:22', 'Asar' => '16:41','Maghrib' => '19:31', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:22', 'Asar' => '16:40','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:22', 'Asar' => '16:40','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:22', 'Asar' => '16:39','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:22', 'Asar' => '16:38','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:22', 'Asar' => '16:38','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:22', 'Asar' => '16:37','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:21', 'Asar' => '16:37','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:21', 'Asar' => '16:36','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:21', 'Asar' => '16:35','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:21', 'Asar' => '16:34','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:34','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:33','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:32','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:07','Zohor' => '13:20', 'Asar' => '16:31','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:07','Zohor' => '13:20', 'Asar' => '16:31','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:07','Zohor' => '13:19', 'Asar' => '16:30','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:07','Zohor' => '13:19', 'Asar' => '16:29','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:07','Zohor' => '13:19', 'Asar' => '16:28','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:07','Zohor' => '13:18', 'Asar' => '16:27','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:07','Zohor' => '13:18', 'Asar' => '16:26','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:07','Zohor' => '13:18', 'Asar' => '16:25','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:06','Zohor' => '13:18', 'Asar' => '16:24','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:06','Zohor' => '13:17', 'Asar' => '16:23','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PRK04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:41','Subuh' => '05:51', 'Syuruk' => '07:06','Zohor' => '13:17', 'Asar' => '16:23','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:09','Zohor' => '13:25', 'Asar' => '16:46','Maghrib' => '19:37', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:09','Zohor' => '13:25', 'Asar' => '16:45','Maghrib' => '19:37', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:42','Subuh' => '05:52', 'Syuruk' => '07:09','Zohor' => '13:25', 'Asar' => '16:45','Maghrib' => '19:37', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:25', 'Asar' => '16:44','Maghrib' => '19:37', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:24', 'Asar' => '16:44','Maghrib' => '19:37', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:24', 'Asar' => '16:44','Maghrib' => '19:36', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:24', 'Asar' => '16:43','Maghrib' => '19:36', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:24', 'Asar' => '16:43','Maghrib' => '19:36', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:24', 'Asar' => '16:42','Maghrib' => '19:36', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:24', 'Asar' => '16:42','Maghrib' => '19:35', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:24', 'Asar' => '16:41','Maghrib' => '19:35', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:09','Zohor' => '13:24', 'Asar' => '16:41','Maghrib' => '19:35', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:23', 'Asar' => '16:40','Maghrib' => '19:35', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:23', 'Asar' => '16:39','Maghrib' => '19:34', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:23', 'Asar' => '16:39','Maghrib' => '19:34', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:23', 'Asar' => '16:38','Maghrib' => '19:34', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:23', 'Asar' => '16:37','Maghrib' => '19:33', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:09','Zohor' => '13:22', 'Asar' => '16:37','Maghrib' => '19:33', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:22', 'Asar' => '16:36','Maghrib' => '19:33', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:22', 'Asar' => '16:35','Maghrib' => '19:32', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:22', 'Asar' => '16:35','Maghrib' => '19:32', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:21', 'Asar' => '16:34','Maghrib' => '19:32', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:21', 'Asar' => '16:33','Maghrib' => '19:31', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:21', 'Asar' => '16:32','Maghrib' => '19:31', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:21', 'Asar' => '16:31','Maghrib' => '19:30', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:08','Zohor' => '13:20', 'Asar' => '16:31','Maghrib' => '19:30', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:07','Zohor' => '13:20', 'Asar' => '16:30','Maghrib' => '19:30', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:07','Zohor' => '13:20', 'Asar' => '16:29','Maghrib' => '19:29', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:07','Zohor' => '13:19', 'Asar' => '16:28','Maghrib' => '19:29', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:07','Zohor' => '13:19', 'Asar' => '16:27','Maghrib' => '19:28', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:07','Zohor' => '13:19', 'Asar' => '16:26','Maghrib' => '19:28', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PRK07', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:07','Zohor' => '13:19', 'Asar' => '16:26','Maghrib' => '19:28', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:43','Subuh' => '05:53', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:47','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:47','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:46','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:45','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:45','Maghrib' => '19:34', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:44','Subuh' => '05:54', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:44','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:44','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:26', 'Asar' => '16:43','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:43','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:42','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:41','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:12','Zohor' => '13:25', 'Asar' => '16:41','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:25', 'Asar' => '16:40','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:40','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:39','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:38','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:38','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:24', 'Asar' => '16:37','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:36','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:35','Maghrib' => '19:30', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:35','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:11','Zohor' => '13:23', 'Asar' => '16:34','Maghrib' => '19:29', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:33','Maghrib' => '19:29', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:32','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:22', 'Asar' => '16:31','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:30','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:29','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:28','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:27','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PRK06', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:45','Subuh' => '05:55', 'Syuruk' => '07:10','Zohor' => '13:21', 'Asar' => '16:27','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:47','Maghrib' => '19:38', 'Isyak' => '20:51'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:47','Maghrib' => '19:38', 'Isyak' => '20:51'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:47','Maghrib' => '19:38', 'Isyak' => '20:51'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:46','Maghrib' => '19:37', 'Isyak' => '20:51'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:46','Maghrib' => '19:37', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:45','Maghrib' => '19:37', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:45','Maghrib' => '19:37', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:44','Maghrib' => '19:37', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:13','Zohor' => '13:26', 'Asar' => '16:44','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:26', 'Asar' => '16:43','Maghrib' => '19:36', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:26', 'Asar' => '16:42','Maghrib' => '19:36', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:26', 'Asar' => '16:42','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:26', 'Asar' => '16:41','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:26', 'Asar' => '16:41','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:25', 'Asar' => '16:40','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:25', 'Asar' => '16:39','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:25', 'Asar' => '16:38','Maghrib' => '19:34', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:25', 'Asar' => '16:38','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:25', 'Asar' => '16:37','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:24', 'Asar' => '16:36','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:24', 'Asar' => '16:35','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:24', 'Asar' => '16:35','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:24', 'Asar' => '16:34','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:23', 'Asar' => '16:33','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:23', 'Asar' => '16:32','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:12','Zohor' => '13:23', 'Asar' => '16:31','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:12','Zohor' => '13:23', 'Asar' => '16:30','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:29','Maghrib' => '19:29', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:28','Maghrib' => '19:29', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:27','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:26','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PLS01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:26','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:12','Zohor' => '13:27', 'Asar' => '16:48','Maghrib' => '19:37', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:12','Zohor' => '13:27', 'Asar' => '16:48','Maghrib' => '19:37', 'Isyak' => '20:50'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:47','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:47','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:46','Maghrib' => '19:36', 'Isyak' => '20:49'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:46','Maghrib' => '19:36', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:45','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:27', 'Asar' => '16:45','Maghrib' => '19:35', 'Isyak' => '20:48'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:26', 'Asar' => '16:44','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:26', 'Asar' => '16:44','Maghrib' => '19:35', 'Isyak' => '20:47'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:26', 'Asar' => '16:43','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:26', 'Asar' => '16:43','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:12','Zohor' => '13:26', 'Asar' => '16:42','Maghrib' => '19:34', 'Isyak' => '20:46'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:12','Zohor' => '13:26', 'Asar' => '16:42','Maghrib' => '19:34', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:12','Zohor' => '13:26', 'Asar' => '16:41','Maghrib' => '19:33', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:12','Zohor' => '13:25', 'Asar' => '16:40','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:12','Zohor' => '13:25', 'Asar' => '16:40','Maghrib' => '19:33', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:12','Zohor' => '13:25', 'Asar' => '16:39','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:12','Zohor' => '13:25', 'Asar' => '16:38','Maghrib' => '19:32', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:12','Zohor' => '13:25', 'Asar' => '16:37','Maghrib' => '19:32', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:12','Zohor' => '13:24', 'Asar' => '16:37','Maghrib' => '19:31', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:12','Zohor' => '13:24', 'Asar' => '16:36','Maghrib' => '19:31', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:12','Zohor' => '13:24', 'Asar' => '16:35','Maghrib' => '19:31', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:11','Zohor' => '13:24', 'Asar' => '16:34','Maghrib' => '19:30', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:11','Zohor' => '13:23', 'Asar' => '16:33','Maghrib' => '19:30', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:11','Zohor' => '13:23', 'Asar' => '16:33','Maghrib' => '19:29', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:46','Subuh' => '5:56', 'Syuruk' => '7:11','Zohor' => '13:23', 'Asar' => '16:32','Maghrib' => '19:29', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:11','Zohor' => '13:22', 'Asar' => '16:31','Maghrib' => '19:29', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:11','Zohor' => '13:22', 'Asar' => '16:30','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:11','Zohor' => '13:22', 'Asar' => '16:29','Maghrib' => '19:28', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:10','Zohor' => '13:22', 'Asar' => '16:28','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'PNG01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:10','Zohor' => '13:22', 'Asar' => '16:28','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:04','Zohor' => '12:17', 'Asar' => '15:37','Maghrib' => '18:26', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:04','Zohor' => '12:17', 'Asar' => '15:37','Maghrib' => '18:26', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:04','Zohor' => '12:17', 'Asar' => '15:37','Maghrib' => '18:26', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:34','Subuh' => '4:44', 'Syuruk' => '6:04','Zohor' => '12:17', 'Asar' => '15:36','Maghrib' => '18:26', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:34','Subuh' => '4:44', 'Syuruk' => '6:04','Zohor' => '12:16', 'Asar' => '15:36','Maghrib' => '18:26', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:34','Subuh' => '4:44', 'Syuruk' => '6:04','Zohor' => '12:16', 'Asar' => '15:35','Maghrib' => '18:26', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:34','Subuh' => '4:44', 'Syuruk' => '6:04','Zohor' => '12:16', 'Asar' => '15:35','Maghrib' => '18:25', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:34','Subuh' => '4:44', 'Syuruk' => '6:04','Zohor' => '12:16', 'Asar' => '15:35','Maghrib' => '18:25', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:34','Subuh' => '4:44', 'Syuruk' => '6:04','Zohor' => '12:16', 'Asar' => '15:34','Maghrib' => '18:25', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:34','Subuh' => '4:44', 'Syuruk' => '6:04','Zohor' => '12:16', 'Asar' => '15:34','Maghrib' => '18:25', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:04','Zohor' => '12:16', 'Asar' => '15:33','Maghrib' => '18:24', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:04','Zohor' => '12:16', 'Asar' => '15:32','Maghrib' => '18:24', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:04','Zohor' => '12:15', 'Asar' => '15:32','Maghrib' => '18:24', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:04','Zohor' => '12:15', 'Asar' => '15:31','Maghrib' => '18:23', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:04','Zohor' => '12:15', 'Asar' => '15:31','Maghrib' => '18:23', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:04','Zohor' => '12:15', 'Asar' => '15:30','Maghrib' => '18:23', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:04','Zohor' => '12:15', 'Asar' => '15:29','Maghrib' => '18:22', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:04','Zohor' => '12:14', 'Asar' => '15:29','Maghrib' => '18:22', 'Isyak' => '19:33'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:04','Zohor' => '12:14', 'Asar' => '15:28','Maghrib' => '18:22', 'Isyak' => '19:33'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:04','Zohor' => '12:14', 'Asar' => '15:27','Maghrib' => '18:21', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:03','Zohor' => '12:14', 'Asar' => '15:26','Maghrib' => '18:21', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:03','Zohor' => '12:14', 'Asar' => '15:26','Maghrib' => '18:21', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:03','Zohor' => '12:13', 'Asar' => '15:25','Maghrib' => '18:20', 'Isyak' => '19:31'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:03','Zohor' => '12:13', 'Asar' => '15:24','Maghrib' => '18:20', 'Isyak' => '19:31'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:03','Zohor' => '12:13', 'Asar' => '15:23','Maghrib' => '18:19', 'Isyak' => '19:30'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:03','Zohor' => '12:12', 'Asar' => '15:22','Maghrib' => '18:19', 'Isyak' => '19:30'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:03','Zohor' => '12:12', 'Asar' => '15:22','Maghrib' => '18:19', 'Isyak' => '19:29'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:03','Zohor' => '12:12', 'Asar' => '15:21','Maghrib' => '18:18', 'Isyak' => '19:28'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:02','Zohor' => '12:12', 'Asar' => '15:20','Maghrib' => '18:18', 'Isyak' => '19:28'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:02','Zohor' => '12:11', 'Asar' => '15:19','Maghrib' => '18:17', 'Isyak' => '19:27'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:02','Zohor' => '12:11', 'Asar' => '15:18','Maghrib' => '18:17', 'Isyak' => '19:27'),
			array('kod_kawasan' => 'SBH01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:02','Zohor' => '12:11', 'Asar' => '15:18','Maghrib' => '18:17', 'Isyak' => '19:27'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:08','Zohor' => '12:21', 'Asar' => '15:42','Maghrib' => '18:30', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:08','Zohor' => '12:21', 'Asar' => '15:41','Maghrib' => '18:30', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:08','Zohor' => '12:21', 'Asar' => '15:41','Maghrib' => '18:30', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:08','Zohor' => '12:20', 'Asar' => '15:40','Maghrib' => '18:30', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:08','Zohor' => '12:20', 'Asar' => '15:40','Maghrib' => '18:29', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:08','Zohor' => '12:20', 'Asar' => '15:40','Maghrib' => '18:29', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:08','Zohor' => '12:20', 'Asar' => '15:39','Maghrib' => '18:29', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:08','Zohor' => '12:20', 'Asar' => '15:39','Maghrib' => '18:29', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:20', 'Asar' => '15:38','Maghrib' => '18:28', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:20', 'Asar' => '15:38','Maghrib' => '18:28', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:20', 'Asar' => '15:37','Maghrib' => '18:28', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:20', 'Asar' => '15:37','Maghrib' => '18:28', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:19', 'Asar' => '15:36','Maghrib' => '18:27', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:19', 'Asar' => '15:35','Maghrib' => '18:27', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:19', 'Asar' => '15:35','Maghrib' => '18:27', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:19', 'Asar' => '15:34','Maghrib' => '18:26', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:19', 'Asar' => '15:33','Maghrib' => '18:26', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:18', 'Asar' => '15:33','Maghrib' => '18:26', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:18', 'Asar' => '15:32','Maghrib' => '18:25', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:18', 'Asar' => '15:31','Maghrib' => '18:25', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:18', 'Asar' => '15:31','Maghrib' => '18:25', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:08','Zohor' => '12:17', 'Asar' => '15:30','Maghrib' => '18:24', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:07','Zohor' => '12:17', 'Asar' => '15:29','Maghrib' => '18:24', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:07','Zohor' => '12:17', 'Asar' => '15:28','Maghrib' => '18:24', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:07','Zohor' => '12:17', 'Asar' => '15:27','Maghrib' => '18:23', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:07','Zohor' => '12:16', 'Asar' => '15:27','Maghrib' => '18:23', 'Isyak' => '19:33'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:07','Zohor' => '12:16', 'Asar' => '15:26','Maghrib' => '18:22', 'Isyak' => '19:33'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:07','Zohor' => '12:16', 'Asar' => '15:25','Maghrib' => '18:22', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:07','Zohor' => '12:16', 'Asar' => '15:24','Maghrib' => '18:21', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:06','Zohor' => '12:15', 'Asar' => '15:23','Maghrib' => '18:21', 'Isyak' => '19:31'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:06','Zohor' => '12:15', 'Asar' => '15:22','Maghrib' => '18:21', 'Isyak' => '19:31'),
			array('kod_kawasan' => 'SBH02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:06','Zohor' => '12:15', 'Asar' => '15:22','Maghrib' => '18:21', 'Isyak' => '19:31'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:32','Subuh' => '4:42', 'Syuruk' => '6:02','Zohor' => '12:15', 'Asar' => '15:36','Maghrib' => '18:24', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:32','Subuh' => '4:42', 'Syuruk' => '6:02','Zohor' => '12:15', 'Asar' => '15:35','Maghrib' => '18:24', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:32','Subuh' => '4:42', 'Syuruk' => '6:03','Zohor' => '12:14', 'Asar' => '15:35','Maghrib' => '18:23', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:32','Subuh' => '4:42', 'Syuruk' => '6:03','Zohor' => '12:14', 'Asar' => '15:34','Maghrib' => '18:23', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:32','Subuh' => '4:42', 'Syuruk' => '6:03','Zohor' => '12:14', 'Asar' => '15:34','Maghrib' => '18:23', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:32','Subuh' => '4:42', 'Syuruk' => '6:03','Zohor' => '12:14', 'Asar' => '15:34','Maghrib' => '18:23', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:03','Zohor' => '12:14', 'Asar' => '15:33','Maghrib' => '18:23', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:03','Zohor' => '12:14', 'Asar' => '15:33','Maghrib' => '18:22', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:03','Zohor' => '12:14', 'Asar' => '15:32','Maghrib' => '18:22', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:03','Zohor' => '12:14', 'Asar' => '15:32','Maghrib' => '18:22', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:02','Zohor' => '12:14', 'Asar' => '15:31','Maghrib' => '18:22', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:02','Zohor' => '12:13', 'Asar' => '15:31','Maghrib' => '18:21', 'Isyak' => '19:33'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:02','Zohor' => '12:13', 'Asar' => '15:30','Maghrib' => '18:21', 'Isyak' => '19:33'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:02','Zohor' => '12:13', 'Asar' => '15:29','Maghrib' => '18:21', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:02','Zohor' => '12:13', 'Asar' => '15:29','Maghrib' => '18:20', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:02','Zohor' => '12:13', 'Asar' => '15:28','Maghrib' => '18:20', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:02','Zohor' => '12:13', 'Asar' => '15:28','Maghrib' => '18:20', 'Isyak' => '19:31'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:02','Zohor' => '12:12', 'Asar' => '15:27','Maghrib' => '18:19', 'Isyak' => '19:31'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:02','Zohor' => '12:12', 'Asar' => '15:26','Maghrib' => '18:19', 'Isyak' => '19:30'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:02','Zohor' => '12:12', 'Asar' => '15:26','Maghrib' => '18:19', 'Isyak' => '19:30'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:34','Subuh' => '4:44', 'Syuruk' => '6:02','Zohor' => '12:12', 'Asar' => '15:25','Maghrib' => '18:18', 'Isyak' => '19:29'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:34','Subuh' => '4:44', 'Syuruk' => '6:02','Zohor' => '12:11', 'Asar' => '15:24','Maghrib' => '18:18', 'Isyak' => '19:29'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:02','Zohor' => '12:11', 'Asar' => '15:23','Maghrib' => '18:18', 'Isyak' => '19:28'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:01','Zohor' => '12:11', 'Asar' => '15:22','Maghrib' => '18:17', 'Isyak' => '19:28'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:01','Zohor' => '12:11', 'Asar' => '15:22','Maghrib' => '18:17', 'Isyak' => '19:27'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:01','Zohor' => '12:10', 'Asar' => '15:21','Maghrib' => '18:17', 'Isyak' => '19:27'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:01','Zohor' => '12:10', 'Asar' => '15:20','Maghrib' => '18:16', 'Isyak' => '19:26'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:01','Zohor' => '12:10', 'Asar' => '15:19','Maghrib' => '18:16', 'Isyak' => '19:26'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:01','Zohor' => '12:09', 'Asar' => '15:18','Maghrib' => '18:15', 'Isyak' => '19:25'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:00','Zohor' => '12:09', 'Asar' => '15:17','Maghrib' => '18:15', 'Isyak' => '19:25'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:00','Zohor' => '12:09', 'Asar' => '15:16','Maghrib' => '18:14', 'Isyak' => '19:24'),
			array('kod_kawasan' => 'SBH03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:33','Subuh' => '4:43', 'Syuruk' => '6:00','Zohor' => '12:09', 'Asar' => '15:16','Maghrib' => '18:14', 'Isyak' => '19:24'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:36','Subuh' => '4:46', 'Syuruk' => '6:07','Zohor' => '12:18', 'Asar' => '15:39','Maghrib' => '18:26', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:36','Subuh' => '4:46', 'Syuruk' => '6:07','Zohor' => '12:18', 'Asar' => '15:39','Maghrib' => '18:26', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:36','Subuh' => '4:46', 'Syuruk' => '6:07','Zohor' => '12:18', 'Asar' => '15:38','Maghrib' => '18:26', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:36','Subuh' => '4:46', 'Syuruk' => '6:07','Zohor' => '12:18', 'Asar' => '15:38','Maghrib' => '18:26', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:07','Zohor' => '12:18', 'Asar' => '15:38','Maghrib' => '18:26', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:07','Zohor' => '12:18', 'Asar' => '15:37','Maghrib' => '18:25', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:07','Zohor' => '12:17', 'Asar' => '15:37','Maghrib' => '18:25', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:07','Zohor' => '12:17', 'Asar' => '15:36','Maghrib' => '18:25', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:07','Zohor' => '12:17', 'Asar' => '15:36','Maghrib' => '18:25', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:07','Zohor' => '12:17', 'Asar' => '15:35','Maghrib' => '18:25', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:07','Zohor' => '12:17', 'Asar' => '15:35','Maghrib' => '18:24', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:17', 'Asar' => '15:34','Maghrib' => '18:24', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:17', 'Asar' => '15:34','Maghrib' => '18:24', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:16', 'Asar' => '15:33','Maghrib' => '18:23', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:16', 'Asar' => '15:33','Maghrib' => '18:23', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:16', 'Asar' => '15:32','Maghrib' => '18:23', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:16', 'Asar' => '15:31','Maghrib' => '18:23', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:16', 'Asar' => '15:31','Maghrib' => '18:22', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:06','Zohor' => '12:15', 'Asar' => '15:30','Maghrib' => '18:22', 'Isyak' => '19:33'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:06','Zohor' => '12:15', 'Asar' => '15:29','Maghrib' => '18:22', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:15', 'Asar' => '15:29','Maghrib' => '18:21', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:05','Zohor' => '12:15', 'Asar' => '15:28','Maghrib' => '18:21', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:05','Zohor' => '12:14', 'Asar' => '15:27','Maghrib' => '18:21', 'Isyak' => '19:31'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:05','Zohor' => '12:14', 'Asar' => '15:26','Maghrib' => '18:20', 'Isyak' => '19:31'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:05','Zohor' => '12:14', 'Asar' => '15:26','Maghrib' => '18:20', 'Isyak' => '19:30'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:05','Zohor' => '12:14', 'Asar' => '15:25','Maghrib' => '18:19', 'Isyak' => '19:30'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:05','Zohor' => '12:13', 'Asar' => '15:24','Maghrib' => '18:19', 'Isyak' => '19:29'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:05','Zohor' => '12:13', 'Asar' => '15:23','Maghrib' => '18:19', 'Isyak' => '19:29'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:04','Zohor' => '12:13', 'Asar' => '15:22','Maghrib' => '18:18', 'Isyak' => '19:28'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:04','Zohor' => '12:13', 'Asar' => '15:21','Maghrib' => '18:18', 'Isyak' => '19:28'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:04','Zohor' => '12:12', 'Asar' => '15:20','Maghrib' => '18:17', 'Isyak' => '19:27'),
			array('kod_kawasan' => 'SBH04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:04','Zohor' => '12:12', 'Asar' => '15:20','Maghrib' => '18:17', 'Isyak' => '19:27'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:06','Zohor' => '12:21', 'Asar' => '15:41','Maghrib' => '18:32', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:06','Zohor' => '12:21', 'Asar' => '15:40','Maghrib' => '18:32', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:06','Zohor' => '12:20', 'Asar' => '15:40','Maghrib' => '18:32', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:06','Zohor' => '12:20', 'Asar' => '15:39','Maghrib' => '18:32', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:35','Subuh' => '4:45', 'Syuruk' => '6:06','Zohor' => '12:20', 'Asar' => '15:39','Maghrib' => '18:31', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:36','Subuh' => '4:46', 'Syuruk' => '6:06','Zohor' => '12:20', 'Asar' => '15:39','Maghrib' => '18:31', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:36','Subuh' => '4:46', 'Syuruk' => '6:06','Zohor' => '12:20', 'Asar' => '15:38','Maghrib' => '18:31', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:36','Subuh' => '4:46', 'Syuruk' => '6:06','Zohor' => '12:20', 'Asar' => '15:38','Maghrib' => '18:31', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:36','Subuh' => '4:46', 'Syuruk' => '6:06','Zohor' => '12:20', 'Asar' => '15:37','Maghrib' => '18:30', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:36','Subuh' => '4:46', 'Syuruk' => '6:06','Zohor' => '12:20', 'Asar' => '15:36','Maghrib' => '18:30', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:36','Subuh' => '4:46', 'Syuruk' => '6:06','Zohor' => '12:20', 'Asar' => '15:36','Maghrib' => '18:30', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:19', 'Asar' => '15:35','Maghrib' => '18:29', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:19', 'Asar' => '15:35','Maghrib' => '18:29', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:19', 'Asar' => '15:34','Maghrib' => '18:29', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:19', 'Asar' => '15:33','Maghrib' => '18:28', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:19', 'Asar' => '15:33','Maghrib' => '18:28', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:19', 'Asar' => '15:32','Maghrib' => '18:28', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:18', 'Asar' => '15:31','Maghrib' => '18:27', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:18', 'Asar' => '15:30','Maghrib' => '18:27', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:18', 'Asar' => '15:30','Maghrib' => '18:27', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:18', 'Asar' => '15:29','Maghrib' => '18:26', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:06','Zohor' => '12:17', 'Asar' => '15:28','Maghrib' => '18:26', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:06','Zohor' => '12:17', 'Asar' => '15:27','Maghrib' => '18:25', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:06','Zohor' => '12:17', 'Asar' => '15:26','Maghrib' => '18:25', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:06','Zohor' => '12:17', 'Asar' => '15:25','Maghrib' => '18:24', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:06','Zohor' => '12:16', 'Asar' => '15:25','Maghrib' => '18:24', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:06','Zohor' => '12:16', 'Asar' => '15:24','Maghrib' => '18:23', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:05','Zohor' => '12:16', 'Asar' => '15:23','Maghrib' => '18:23', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:05','Zohor' => '12:15', 'Asar' => '15:22','Maghrib' => '18:23', 'Isyak' => '19:33'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:05','Zohor' => '12:15', 'Asar' => '15:21','Maghrib' => '18:22', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:05','Zohor' => '12:15', 'Asar' => '15:20','Maghrib' => '18:22', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH05', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:05','Zohor' => '12:15', 'Asar' => '15:20','Maghrib' => '18:22', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:00','Zohor' => '12:22', 'Asar' => '15:42','Maghrib' => '18:40', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:37','Subuh' => '4:47', 'Syuruk' => '6:00','Zohor' => '12:22', 'Asar' => '15:42','Maghrib' => '18:40', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:00','Zohor' => '12:22', 'Asar' => '15:42','Maghrib' => '18:40', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:00','Zohor' => '12:22', 'Asar' => '15:41','Maghrib' => '18:40', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:00','Zohor' => '12:22', 'Asar' => '15:41','Maghrib' => '18:39', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:01','Zohor' => '12:21', 'Asar' => '15:40','Maghrib' => '18:39', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:01','Zohor' => '12:21', 'Asar' => '15:40','Maghrib' => '18:39', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:38','Subuh' => '4:48', 'Syuruk' => '6:01','Zohor' => '12:21', 'Asar' => '15:39','Maghrib' => '18:39', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:01','Zohor' => '12:21', 'Asar' => '15:39','Maghrib' => '18:38', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:01','Zohor' => '12:21', 'Asar' => '15:38','Maghrib' => '18:38', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:01','Zohor' => '12:21', 'Asar' => '15:38','Maghrib' => '18:38', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:01','Zohor' => '12:21', 'Asar' => '15:37','Maghrib' => '18:38', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:01','Zohor' => '12:20', 'Asar' => '15:36','Maghrib' => '18:37', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:01','Zohor' => '12:20', 'Asar' => '15:36','Maghrib' => '18:37', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:01','Zohor' => '12:20', 'Asar' => '15:35','Maghrib' => '18:37', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:01','Zohor' => '12:20', 'Asar' => '15:35','Maghrib' => '18:36', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:00','Zohor' => '12:20', 'Asar' => '15:34','Maghrib' => '18:36', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:00','Zohor' => '12:20', 'Asar' => '15:33','Maghrib' => '18:35', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:00','Zohor' => '12:19', 'Asar' => '15:32','Maghrib' => '18:35', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '6:00','Zohor' => '12:19', 'Asar' => '15:32','Maghrib' => '18:35', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:00','Zohor' => '12:19', 'Asar' => '15:31','Maghrib' => '18:34', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:00','Zohor' => '12:19', 'Asar' => '15:30','Maghrib' => '18:34', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:00','Zohor' => '12:18', 'Asar' => '15:29','Maghrib' => '18:34', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:00','Zohor' => '12:18', 'Asar' => '15:28','Maghrib' => '18:33', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:00','Zohor' => '12:18', 'Asar' => '15:28','Maghrib' => '18:33', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:00','Zohor' => '12:18', 'Asar' => '15:27','Maghrib' => '18:32', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:00','Zohor' => '12:17', 'Asar' => '15:26','Maghrib' => '18:32', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:00','Zohor' => '12:17', 'Asar' => '15:25','Maghrib' => '18:31', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '5:59','Zohor' => '12:17', 'Asar' => '15:24','Maghrib' => '18:31', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '5:59','Zohor' => '12:16', 'Asar' => '15:23','Maghrib' => '18:30', 'Isyak' => '19:33'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '5:59','Zohor' => '12:16', 'Asar' => '15:22','Maghrib' => '18:30', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH06', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:39','Subuh' => '4:49', 'Syuruk' => '5:59','Zohor' => '12:16', 'Asar' => '15:22','Maghrib' => '18:30', 'Isyak' => '19:32'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:11','Zohor' => '12:24', 'Asar' => '15:45','Maghrib' => '18:34', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:11','Zohor' => '12:24', 'Asar' => '15:44','Maghrib' => '18:34', 'Isyak' => '19:47'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:11','Zohor' => '12:24', 'Asar' => '15:44','Maghrib' => '18:34', 'Isyak' => '19:47'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:24', 'Asar' => '15:44','Maghrib' => '18:34', 'Isyak' => '19:47'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:24', 'Asar' => '15:43','Maghrib' => '18:34', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:24', 'Asar' => '15:43','Maghrib' => '18:33', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:24', 'Asar' => '15:42','Maghrib' => '18:33', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:24', 'Asar' => '15:42','Maghrib' => '18:33', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:41','Maghrib' => '18:33', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:41','Maghrib' => '18:32', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:40','Maghrib' => '18:32', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:40','Maghrib' => '18:32', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:39','Maghrib' => '18:31', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:39','Maghrib' => '18:31', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:38','Maghrib' => '18:31', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:22', 'Asar' => '15:37','Maghrib' => '18:30', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:22', 'Asar' => '15:37','Maghrib' => '18:30', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:22', 'Asar' => '15:36','Maghrib' => '18:30', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:22', 'Asar' => '15:35','Maghrib' => '18:29', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:21', 'Asar' => '15:34','Maghrib' => '18:29', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:21', 'Asar' => '15:34','Maghrib' => '18:29', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:21', 'Asar' => '15:33','Maghrib' => '18:28', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:21', 'Asar' => '15:32','Maghrib' => '18:28', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:20', 'Asar' => '15:31','Maghrib' => '18:27', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:20', 'Asar' => '15:30','Maghrib' => '18:27', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:20', 'Asar' => '15:30','Maghrib' => '18:27', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:20', 'Asar' => '15:29','Maghrib' => '18:26', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:19', 'Asar' => '15:28','Maghrib' => '18:26', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:19', 'Asar' => '15:27','Maghrib' => '18:25', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:19', 'Asar' => '15:26','Maghrib' => '18:25', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:09','Zohor' => '12:18', 'Asar' => '15:25','Maghrib' => '18:24', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH07', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:09','Zohor' => '12:18', 'Asar' => '15:25','Maghrib' => '18:24', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:44','Maghrib' => '18:33', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:44','Maghrib' => '18:33', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:43','Maghrib' => '18:32', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:43','Maghrib' => '18:32', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:40','Subuh' => '4:50', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:43','Maghrib' => '18:32', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:42','Maghrib' => '18:32', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:42','Maghrib' => '18:32', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:41','Maghrib' => '18:31', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:23', 'Asar' => '15:41','Maghrib' => '18:31', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:22', 'Asar' => '15:40','Maghrib' => '18:31', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:22', 'Asar' => '15:40','Maghrib' => '18:31', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:22', 'Asar' => '15:39','Maghrib' => '18:30', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:11','Zohor' => '12:22', 'Asar' => '15:39','Maghrib' => '18:30', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:22', 'Asar' => '15:38','Maghrib' => '18:30', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:22', 'Asar' => '15:37','Maghrib' => '18:29', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:11','Zohor' => '12:21', 'Asar' => '15:37','Maghrib' => '18:29', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:21', 'Asar' => '15:36','Maghrib' => '18:29', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:21', 'Asar' => '15:35','Maghrib' => '18:28', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:21', 'Asar' => '15:35','Maghrib' => '18:28', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:21', 'Asar' => '15:34','Maghrib' => '18:28', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:20', 'Asar' => '15:33','Maghrib' => '18:27', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:20', 'Asar' => '15:32','Maghrib' => '18:27', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:20', 'Asar' => '15:32','Maghrib' => '18:27', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:20', 'Asar' => '15:31','Maghrib' => '18:26', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:19', 'Asar' => '15:30','Maghrib' => '18:26', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:10','Zohor' => '12:19', 'Asar' => '15:29','Maghrib' => '18:25', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:09','Zohor' => '12:19', 'Asar' => '15:28','Maghrib' => '18:25', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:09','Zohor' => '12:18', 'Asar' => '15:27','Maghrib' => '18:25', 'Isyak' => '19:35'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:09','Zohor' => '12:18', 'Asar' => '15:26','Maghrib' => '18:24', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:42','Subuh' => '4:52', 'Syuruk' => '6:09','Zohor' => '12:18', 'Asar' => '15:26','Maghrib' => '18:24', 'Isyak' => '19:34'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:09','Zohor' => '12:18', 'Asar' => '15:25','Maghrib' => '18:23', 'Isyak' => '19:33'),
			array('kod_kawasan' => 'SBH08', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:41','Subuh' => '4:51', 'Syuruk' => '6:09','Zohor' => '12:18', 'Asar' => '15:25','Maghrib' => '18:23', 'Isyak' => '19:33'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:43','Subuh' => '4:53', 'Syuruk' => '6:13','Zohor' => '12:26', 'Asar' => '15:47','Maghrib' => '18:35', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:43','Subuh' => '4:53', 'Syuruk' => '6:14','Zohor' => '12:26', 'Asar' => '15:46','Maghrib' => '18:35', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:43','Subuh' => '4:53', 'Syuruk' => '6:14','Zohor' => '12:26', 'Asar' => '15:46','Maghrib' => '18:35', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:43','Subuh' => '4:53', 'Syuruk' => '6:14','Zohor' => '12:26', 'Asar' => '15:46','Maghrib' => '18:34', 'Isyak' => '19:47'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:43','Subuh' => '4:53', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:45','Maghrib' => '18:34', 'Isyak' => '19:47'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:43','Subuh' => '4:53', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:45','Maghrib' => '18:34', 'Isyak' => '19:47'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:44','Maghrib' => '18:34', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:44','Maghrib' => '18:34', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:43','Maghrib' => '18:33', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:43','Maghrib' => '18:33', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:42','Maghrib' => '18:33', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:42','Maghrib' => '18:33', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:13','Zohor' => '12:24', 'Asar' => '15:41','Maghrib' => '18:32', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:13','Zohor' => '12:24', 'Asar' => '15:41','Maghrib' => '18:32', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:13','Zohor' => '12:24', 'Asar' => '15:40','Maghrib' => '18:32', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:13','Zohor' => '12:24', 'Asar' => '15:39','Maghrib' => '18:31', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:13','Zohor' => '12:24', 'Asar' => '15:39','Maghrib' => '18:31', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:13','Zohor' => '12:23', 'Asar' => '15:38','Maghrib' => '18:31', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:13','Zohor' => '12:23', 'Asar' => '15:37','Maghrib' => '18:30', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:13','Zohor' => '12:23', 'Asar' => '15:37','Maghrib' => '18:30', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:13','Zohor' => '12:23', 'Asar' => '15:36','Maghrib' => '18:30', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:13','Zohor' => '12:23', 'Asar' => '15:35','Maghrib' => '18:29', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:13','Zohor' => '12:22', 'Asar' => '15:34','Maghrib' => '18:29', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:12','Zohor' => '12:22', 'Asar' => '15:34','Maghrib' => '18:28', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:12','Zohor' => '12:22', 'Asar' => '15:33','Maghrib' => '18:28', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:12','Zohor' => '12:21', 'Asar' => '15:32','Maghrib' => '18:28', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:12','Zohor' => '12:21', 'Asar' => '15:31','Maghrib' => '18:27', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:12','Zohor' => '12:21', 'Asar' => '15:30','Maghrib' => '18:27', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:12','Zohor' => '12:21', 'Asar' => '15:29','Maghrib' => '18:26', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:12','Zohor' => '12:20', 'Asar' => '15:28','Maghrib' => '18:26', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:11','Zohor' => '12:20', 'Asar' => '15:27','Maghrib' => '18:26', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SBH09', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:11','Zohor' => '12:20', 'Asar' => '15:27','Maghrib' => '18:26', 'Isyak' => '19:36'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '04:50','Subuh' => '05:00', 'Syuruk' => '06:19','Zohor' => '12:32', 'Asar' => '15:53','Maghrib' => '18:40', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '04:50','Subuh' => '05:00', 'Syuruk' => '06:20','Zohor' => '12:32', 'Asar' => '15:53','Maghrib' => '18:40', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '04:50','Subuh' => '05:00', 'Syuruk' => '06:20','Zohor' => '12:32', 'Asar' => '15:52','Maghrib' => '18:40', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '04:50','Subuh' => '05:00', 'Syuruk' => '06:20','Zohor' => '12:32', 'Asar' => '15:52','Maghrib' => '18:40', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '04:50','Subuh' => '05:00', 'Syuruk' => '06:20','Zohor' => '12:32', 'Asar' => '15:51','Maghrib' => '18:40', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:20','Zohor' => '12:32', 'Asar' => '15:51','Maghrib' => '18:39', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:20','Zohor' => '12:31', 'Asar' => '15:51','Maghrib' => '18:39', 'Isyak' => '19:51'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:20','Zohor' => '12:31', 'Asar' => '15:50','Maghrib' => '18:39', 'Isyak' => '19:51'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:19','Zohor' => '12:31', 'Asar' => '15:50','Maghrib' => '18:39', 'Isyak' => '19:51'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:19','Zohor' => '12:31', 'Asar' => '15:49','Maghrib' => '18:38', 'Isyak' => '19:50'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:19','Zohor' => '12:31', 'Asar' => '15:49','Maghrib' => '18:38', 'Isyak' => '19:50'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:19','Zohor' => '12:31', 'Asar' => '15:48','Maghrib' => '18:38', 'Isyak' => '19:50'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:19','Zohor' => '12:31', 'Asar' => '15:47','Maghrib' => '18:38', 'Isyak' => '19:49'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:19','Zohor' => '12:30', 'Asar' => '15:47','Maghrib' => '18:37', 'Isyak' => '19:49'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:19','Zohor' => '12:30', 'Asar' => '15:46','Maghrib' => '18:37', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:19','Zohor' => '12:30', 'Asar' => '15:46','Maghrib' => '18:37', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:19','Zohor' => '12:30', 'Asar' => '15:45','Maghrib' => '18:36', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:19','Zohor' => '12:30', 'Asar' => '15:44','Maghrib' => '18:36', 'Isyak' => '19:47'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:19','Zohor' => '12:29', 'Asar' => '15:44','Maghrib' => '18:36', 'Isyak' => '19:47'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:19','Zohor' => '12:29', 'Asar' => '15:43','Maghrib' => '18:35', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:18','Zohor' => '12:29', 'Asar' => '15:42','Maghrib' => '18:35', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:18','Zohor' => '12:29', 'Asar' => '15:41','Maghrib' => '18:35', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:18','Zohor' => '12:28', 'Asar' => '15:41','Maghrib' => '18:34', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:18','Zohor' => '12:28', 'Asar' => '15:40','Maghrib' => '18:34', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:18','Zohor' => '12:28', 'Asar' => '15:39','Maghrib' => '18:34', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:18','Zohor' => '12:28', 'Asar' => '15:38','Maghrib' => '18:33', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:18','Zohor' => '12:27', 'Asar' => '15:37','Maghrib' => '18:33', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:17','Zohor' => '12:27', 'Asar' => '15:37','Maghrib' => '18:32', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:17','Zohor' => '12:27', 'Asar' => '15:36','Maghrib' => '18:32', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:17','Zohor' => '12:26', 'Asar' => '15:35','Maghrib' => '18:32', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:17','Zohor' => '12:26', 'Asar' => '15:34','Maghrib' => '18:31', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SWK01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '04:51','Subuh' => '05:01', 'Syuruk' => '06:17','Zohor' => '12:26', 'Asar' => '15:34','Maghrib' => '18:31', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:25','Zohor' => '12:36', 'Asar' => '15:57','Maghrib' => '18:43', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:25','Zohor' => '12:36', 'Asar' => '15:57','Maghrib' => '18:43', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:25','Zohor' => '12:36', 'Asar' => '15:57','Maghrib' => '18:43', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:25','Zohor' => '12:36', 'Asar' => '15:56','Maghrib' => '18:43', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:25','Zohor' => '12:36', 'Asar' => '15:56','Maghrib' => '18:43', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:25','Zohor' => '12:36', 'Asar' => '15:56','Maghrib' => '18:43', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:25','Zohor' => '12:36', 'Asar' => '15:55','Maghrib' => '18:42', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:25','Zohor' => '12:36', 'Asar' => '15:55','Maghrib' => '18:42', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:25','Zohor' => '12:35', 'Asar' => '15:54','Maghrib' => '18:42', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:25','Zohor' => '12:35', 'Asar' => '15:54','Maghrib' => '18:42', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:25','Zohor' => '12:35', 'Asar' => '15:53','Maghrib' => '18:41', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:25','Zohor' => '12:35', 'Asar' => '15:53','Maghrib' => '18:41', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:25','Zohor' => '12:35', 'Asar' => '15:52','Maghrib' => '18:41', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:24','Zohor' => '12:35', 'Asar' => '15:52','Maghrib' => '18:41', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:24','Zohor' => '12:34', 'Asar' => '15:51','Maghrib' => '18:40', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:24','Zohor' => '12:34', 'Asar' => '15:51','Maghrib' => '18:40', 'Isyak' => '19:51'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:24','Zohor' => '12:34', 'Asar' => '15:50','Maghrib' => '18:40', 'Isyak' => '19:51'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:24','Zohor' => '12:34', 'Asar' => '15:49','Maghrib' => '18:40', 'Isyak' => '19:50'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:24','Zohor' => '12:34', 'Asar' => '15:49','Maghrib' => '18:39', 'Isyak' => '19:50'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:24','Zohor' => '12:33', 'Asar' => '15:48','Maghrib' => '18:39', 'Isyak' => '19:50'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:24','Zohor' => '12:33', 'Asar' => '15:47','Maghrib' => '18:39', 'Isyak' => '19:49'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:23','Zohor' => '12:33', 'Asar' => '15:47','Maghrib' => '18:38', 'Isyak' => '19:49'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '04:57','Subuh' => '05:07', 'Syuruk' => '06:23','Zohor' => '12:33', 'Asar' => '15:46','Maghrib' => '18:38', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:23','Zohor' => '12:32', 'Asar' => '15:45','Maghrib' => '18:38', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:23','Zohor' => '12:32', 'Asar' => '15:44','Maghrib' => '18:37', 'Isyak' => '19:47'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:23','Zohor' => '12:32', 'Asar' => '15:44','Maghrib' => '18:37', 'Isyak' => '19:47'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:23','Zohor' => '12:32', 'Asar' => '15:43','Maghrib' => '18:36', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:22','Zohor' => '12:31', 'Asar' => '15:42','Maghrib' => '18:36', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:22','Zohor' => '12:31', 'Asar' => '15:41','Maghrib' => '18:36', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:22','Zohor' => '12:31', 'Asar' => '15:40','Maghrib' => '18:35', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:22','Zohor' => '12:30', 'Asar' => '15:39','Maghrib' => '18:35', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SWK02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '04:56','Subuh' => '05:06', 'Syuruk' => '06:22','Zohor' => '12:30', 'Asar' => '15:39','Maghrib' => '18:35', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:30','Zohor' => '12:40', 'Asar' => '16:01','Maghrib' => '18:46', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:30','Zohor' => '12:40', 'Asar' => '16:01','Maghrib' => '18:46', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:30','Zohor' => '12:40', 'Asar' => '16:01','Maghrib' => '18:45', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:30','Zohor' => '12:40', 'Asar' => '16:00','Maghrib' => '18:45', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:30','Zohor' => '12:40', 'Asar' => '16:00','Maghrib' => '18:45', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:30','Zohor' => '12:39', 'Asar' => '16:00','Maghrib' => '18:45', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:30','Zohor' => '12:39', 'Asar' => '15:59','Maghrib' => '18:45', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:30','Zohor' => '12:39', 'Asar' => '15:59','Maghrib' => '18:45', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:30','Zohor' => '12:39', 'Asar' => '15:58','Maghrib' => '18:44', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:30','Zohor' => '12:39', 'Asar' => '15:58','Maghrib' => '18:44', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:02','Subuh' => '05:12', 'Syuruk' => '06:29','Zohor' => '12:39', 'Asar' => '15:58','Maghrib' => '18:44', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:02','Subuh' => '05:12', 'Syuruk' => '06:29','Zohor' => '12:39', 'Asar' => '15:57','Maghrib' => '18:44', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:02','Subuh' => '05:12', 'Syuruk' => '06:29','Zohor' => '12:38', 'Asar' => '15:57','Maghrib' => '18:44', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:02','Subuh' => '05:12', 'Syuruk' => '06:29','Zohor' => '12:38', 'Asar' => '15:56','Maghrib' => '18:43', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:02','Subuh' => '05:12', 'Syuruk' => '06:29','Zohor' => '12:38', 'Asar' => '15:55','Maghrib' => '18:43', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:02','Subuh' => '05:12', 'Syuruk' => '06:29','Zohor' => '12:38', 'Asar' => '15:55','Maghrib' => '18:43', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:02','Subuh' => '05:12', 'Syuruk' => '06:29','Zohor' => '12:38', 'Asar' => '15:54','Maghrib' => '18:42', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:29','Zohor' => '12:37', 'Asar' => '15:54','Maghrib' => '18:42', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:28','Zohor' => '12:37', 'Asar' => '15:53','Maghrib' => '18:42', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:28','Zohor' => '12:37', 'Asar' => '15:52','Maghrib' => '18:42', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:28','Zohor' => '12:37', 'Asar' => '15:52','Maghrib' => '18:41', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:28','Zohor' => '12:37', 'Asar' => '15:51','Maghrib' => '18:41', 'Isyak' => '19:51'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:28','Zohor' => '12:36', 'Asar' => '15:50','Maghrib' => '18:41', 'Isyak' => '19:51'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:28','Zohor' => '12:36', 'Asar' => '15:50','Maghrib' => '18:40', 'Isyak' => '19:51'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:27','Zohor' => '12:36', 'Asar' => '15:49','Maghrib' => '18:40', 'Isyak' => '19:50'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:27','Zohor' => '12:35', 'Asar' => '15:48','Maghrib' => '18:40', 'Isyak' => '19:50'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:27','Zohor' => '12:35', 'Asar' => '15:47','Maghrib' => '18:39', 'Isyak' => '19:49'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:01','Subuh' => '05:11', 'Syuruk' => '06:27','Zohor' => '12:35', 'Asar' => '15:47','Maghrib' => '18:39', 'Isyak' => '19:49'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:00','Subuh' => '05:10', 'Syuruk' => '06:26','Zohor' => '12:35', 'Asar' => '15:46','Maghrib' => '18:39', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:00','Subuh' => '05:10', 'Syuruk' => '06:26','Zohor' => '12:34', 'Asar' => '15:45','Maghrib' => '18:38', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:00','Subuh' => '05:10', 'Syuruk' => '06:26','Zohor' => '12:34', 'Asar' => '15:44','Maghrib' => '18:38', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SWK03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:00','Subuh' => '05:10', 'Syuruk' => '06:26','Zohor' => '12:34', 'Asar' => '15:44','Maghrib' => '18:38', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:03','Subuh' => '05:13', 'Syuruk' => '06:31','Zohor' => '12:42', 'Asar' => '16:04','Maghrib' => '18:50', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:03','Subuh' => '05:13', 'Syuruk' => '06:31','Zohor' => '12:42', 'Asar' => '16:03','Maghrib' => '18:50', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:03','Subuh' => '05:13', 'Syuruk' => '06:31','Zohor' => '12:42', 'Asar' => '16:03','Maghrib' => '18:50', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:42', 'Asar' => '16:03','Maghrib' => '18:50', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:42', 'Asar' => '16:02','Maghrib' => '18:49', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:42', 'Asar' => '16:02','Maghrib' => '18:49', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:42', 'Asar' => '16:02','Maghrib' => '18:49', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:42', 'Asar' => '16:01','Maghrib' => '18:49', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:42', 'Asar' => '16:01','Maghrib' => '18:49', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:41', 'Asar' => '16:00','Maghrib' => '18:49', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:41', 'Asar' => '16:00','Maghrib' => '18:48', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:41', 'Asar' => '15:59','Maghrib' => '18:48', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:41', 'Asar' => '15:59','Maghrib' => '18:48', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:41', 'Asar' => '15:58','Maghrib' => '18:48', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:30','Zohor' => '12:41', 'Asar' => '15:58','Maghrib' => '18:47', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:30','Zohor' => '12:40', 'Asar' => '15:57','Maghrib' => '18:47', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:30','Zohor' => '12:40', 'Asar' => '15:57','Maghrib' => '18:47', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:30','Zohor' => '12:40', 'Asar' => '15:56','Maghrib' => '18:47', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:30','Zohor' => '12:40', 'Asar' => '15:56','Maghrib' => '18:46', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:30','Zohor' => '12:39', 'Asar' => '15:55','Maghrib' => '18:46', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:30','Zohor' => '12:39', 'Asar' => '15:54','Maghrib' => '18:46', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:29','Zohor' => '12:39', 'Asar' => '15:54','Maghrib' => '18:45', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:29','Zohor' => '12:39', 'Asar' => '15:53','Maghrib' => '18:45', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:03','Subuh' => '05:13', 'Syuruk' => '06:29','Zohor' => '12:38', 'Asar' => '15:52','Maghrib' => '18:45', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:03','Subuh' => '05:13', 'Syuruk' => '06:29','Zohor' => '12:38', 'Asar' => '15:51','Maghrib' => '18:44', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:03','Subuh' => '05:13', 'Syuruk' => '06:29','Zohor' => '12:38', 'Asar' => '15:51','Maghrib' => '18:44', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:03','Subuh' => '05:13', 'Syuruk' => '06:28','Zohor' => '12:38', 'Asar' => '15:50','Maghrib' => '18:44', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:03','Subuh' => '05:13', 'Syuruk' => '06:28','Zohor' => '12:37', 'Asar' => '15:49','Maghrib' => '18:43', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:03','Subuh' => '05:13', 'Syuruk' => '06:28','Zohor' => '12:37', 'Asar' => '15:48','Maghrib' => '18:43', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:03','Subuh' => '05:13', 'Syuruk' => '06:28','Zohor' => '12:37', 'Asar' => '15:47','Maghrib' => '18:43', 'Isyak' => '19:51'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:03','Subuh' => '05:13', 'Syuruk' => '06:27','Zohor' => '12:36', 'Asar' => '15:47','Maghrib' => '18:42', 'Isyak' => '19:51'),
			array('kod_kawasan' => 'SWK04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:03','Subuh' => '05:13', 'Syuruk' => '06:27','Zohor' => '12:36', 'Asar' => '15:47','Maghrib' => '18:42', 'Isyak' => '19:51'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:35','Zohor' => '12:44', 'Asar' => '16:05','Maghrib' => '18:51', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:35','Zohor' => '12:44', 'Asar' => '16:05','Maghrib' => '18:51', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:35','Zohor' => '12:44', 'Asar' => '16:04','Maghrib' => '18:50', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:35','Zohor' => '12:44', 'Asar' => '16:04','Maghrib' => '18:50', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:35','Zohor' => '12:44', 'Asar' => '16:04','Maghrib' => '18:50', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:35','Zohor' => '12:44', 'Asar' => '16:03','Maghrib' => '18:50', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:35','Zohor' => '12:44', 'Asar' => '16:03','Maghrib' => '18:50', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:35','Zohor' => '12:44', 'Asar' => '16:03','Maghrib' => '18:50', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:06','Subuh' => '05:16', 'Syuruk' => '06:35','Zohor' => '12:44', 'Asar' => '16:02','Maghrib' => '18:50', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:06','Subuh' => '05:16', 'Syuruk' => '06:35','Zohor' => '12:44', 'Asar' => '16:02','Maghrib' => '18:49', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:06','Subuh' => '05:16', 'Syuruk' => '06:34','Zohor' => '12:43', 'Asar' => '16:01','Maghrib' => '18:49', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:06','Subuh' => '05:16', 'Syuruk' => '06:34','Zohor' => '12:43', 'Asar' => '16:01','Maghrib' => '18:49', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:06','Subuh' => '05:16', 'Syuruk' => '06:34','Zohor' => '12:43', 'Asar' => '16:00','Maghrib' => '18:49', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:06','Subuh' => '05:16', 'Syuruk' => '06:34','Zohor' => '12:43', 'Asar' => '16:00','Maghrib' => '18:48', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:06','Subuh' => '05:16', 'Syuruk' => '06:34','Zohor' => '12:43', 'Asar' => '15:59','Maghrib' => '18:48', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:06','Subuh' => '05:16', 'Syuruk' => '06:34','Zohor' => '12:42', 'Asar' => '15:59','Maghrib' => '18:48', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:34','Zohor' => '12:42', 'Asar' => '15:58','Maghrib' => '18:48', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:34','Zohor' => '12:42', 'Asar' => '15:58','Maghrib' => '18:47', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:33','Zohor' => '12:42', 'Asar' => '15:57','Maghrib' => '18:47', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:33','Zohor' => '12:42', 'Asar' => '15:56','Maghrib' => '18:47', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:33','Zohor' => '12:41', 'Asar' => '15:56','Maghrib' => '18:47', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:33','Zohor' => '12:41', 'Asar' => '15:55','Maghrib' => '18:46', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:33','Zohor' => '12:41', 'Asar' => '15:54','Maghrib' => '18:46', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:32','Zohor' => '12:41', 'Asar' => '15:54','Maghrib' => '18:46', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:32','Zohor' => '12:40', 'Asar' => '15:53','Maghrib' => '18:45', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:32','Zohor' => '12:40', 'Asar' => '15:52','Maghrib' => '18:45', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:05','Subuh' => '05:15', 'Syuruk' => '06:32','Zohor' => '12:40', 'Asar' => '15:51','Maghrib' => '18:45', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:32','Zohor' => '12:39', 'Asar' => '15:51','Maghrib' => '18:44', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:39', 'Asar' => '15:50','Maghrib' => '18:44', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:39', 'Asar' => '15:49','Maghrib' => '18:44', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:39', 'Asar' => '15:48','Maghrib' => '18:43', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK05', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:04','Subuh' => '05:14', 'Syuruk' => '06:31','Zohor' => '12:39', 'Asar' => '15:48','Maghrib' => '18:43', 'Isyak' => '19:52'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:38','Zohor' => '12:46', 'Asar' => '16:07','Maghrib' => '18:50', 'Isyak' => '20:03'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:38','Zohor' => '12:46', 'Asar' => '16:07','Maghrib' => '18:50', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:38','Zohor' => '12:46', 'Asar' => '16:07','Maghrib' => '18:50', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:38','Zohor' => '12:45', 'Asar' => '16:06','Maghrib' => '18:50', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:38','Zohor' => '12:45', 'Asar' => '16:06','Maghrib' => '18:50', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:38','Zohor' => '12:45', 'Asar' => '16:06','Maghrib' => '18:49', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:38','Zohor' => '12:45', 'Asar' => '16:05','Maghrib' => '18:49', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:38','Zohor' => '12:45', 'Asar' => '16:05','Maghrib' => '18:49', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:38','Zohor' => '12:45', 'Asar' => '16:05','Maghrib' => '18:49', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:38','Zohor' => '12:45', 'Asar' => '16:04','Maghrib' => '18:49', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:37','Zohor' => '12:45', 'Asar' => '16:04','Maghrib' => '18:49', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:37','Zohor' => '12:44', 'Asar' => '16:03','Maghrib' => '18:48', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:37','Zohor' => '12:44', 'Asar' => '16:03','Maghrib' => '18:48', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:37','Zohor' => '12:44', 'Asar' => '16:02','Maghrib' => '18:48', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:37','Zohor' => '12:44', 'Asar' => '16:02','Maghrib' => '18:48', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:37','Zohor' => '12:44', 'Asar' => '16:01','Maghrib' => '18:48', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:37','Zohor' => '12:43', 'Asar' => '16:01','Maghrib' => '18:47', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:36','Zohor' => '12:43', 'Asar' => '16:00','Maghrib' => '18:47', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:36','Zohor' => '12:43', 'Asar' => '16:00','Maghrib' => '18:47', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:36','Zohor' => '12:43', 'Asar' => '15:59','Maghrib' => '18:46', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:36','Zohor' => '12:43', 'Asar' => '15:58','Maghrib' => '18:46', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:36','Zohor' => '12:42', 'Asar' => '15:58','Maghrib' => '18:46', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:35','Zohor' => '12:42', 'Asar' => '15:57','Maghrib' => '18:46', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:35','Zohor' => '12:42', 'Asar' => '15:56','Maghrib' => '18:45', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:35','Zohor' => '12:42', 'Asar' => '15:56','Maghrib' => '18:45', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:08','Subuh' => '05:18', 'Syuruk' => '06:35','Zohor' => '12:41', 'Asar' => '15:55','Maghrib' => '18:45', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:07','Subuh' => '05:17', 'Syuruk' => '06:34','Zohor' => '12:41', 'Asar' => '15:54','Maghrib' => '18:44', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:07','Subuh' => '05:17', 'Syuruk' => '06:34','Zohor' => '12:41', 'Asar' => '15:54','Maghrib' => '18:44', 'Isyak' => '19:54'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:07','Subuh' => '05:17', 'Syuruk' => '06:34','Zohor' => '12:40', 'Asar' => '15:53','Maghrib' => '18:44', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:07','Subuh' => '05:17', 'Syuruk' => '06:34','Zohor' => '12:40', 'Asar' => '15:52','Maghrib' => '18:43', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:07','Subuh' => '05:17', 'Syuruk' => '06:33','Zohor' => '12:40', 'Asar' => '15:51','Maghrib' => '18:43', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK06', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:07','Subuh' => '05:17', 'Syuruk' => '06:33','Zohor' => '12:40', 'Asar' => '15:51','Maghrib' => '18:43', 'Isyak' => '19:53'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:42','Zohor' => '12:48', 'Asar' => '16:09','Maghrib' => '18:52', 'Isyak' => '20:04'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:42','Zohor' => '12:48', 'Asar' => '16:09','Maghrib' => '18:52', 'Isyak' => '20:04'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:41','Zohor' => '12:48', 'Asar' => '16:09','Maghrib' => '18:52', 'Isyak' => '20:04'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:41','Zohor' => '12:48', 'Asar' => '16:09','Maghrib' => '18:52', 'Isyak' => '20:04'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:41','Zohor' => '12:47', 'Asar' => '16:08','Maghrib' => '18:51', 'Isyak' => '20:04'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:41','Zohor' => '12:47', 'Asar' => '16:08','Maghrib' => '18:51', 'Isyak' => '20:03'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:41','Zohor' => '12:47', 'Asar' => '16:08','Maghrib' => '18:51', 'Isyak' => '20:03'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:41','Zohor' => '12:47', 'Asar' => '16:07','Maghrib' => '18:51', 'Isyak' => '20:03'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:41','Zohor' => '12:47', 'Asar' => '16:07','Maghrib' => '18:51', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:41','Zohor' => '12:47', 'Asar' => '16:06','Maghrib' => '18:51', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:41','Zohor' => '12:47', 'Asar' => '16:06','Maghrib' => '18:51', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:41','Zohor' => '12:47', 'Asar' => '16:06','Maghrib' => '18:50', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:41','Zohor' => '12:46', 'Asar' => '16:05','Maghrib' => '18:50', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:40','Zohor' => '12:46', 'Asar' => '16:05','Maghrib' => '18:50', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:40','Zohor' => '12:46', 'Asar' => '16:04','Maghrib' => '18:50', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:40','Zohor' => '12:46', 'Asar' => '16:04','Maghrib' => '18:49', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:40','Zohor' => '12:46', 'Asar' => '16:03','Maghrib' => '18:49', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:40','Zohor' => '12:45', 'Asar' => '16:02','Maghrib' => '18:49', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:40','Zohor' => '12:45', 'Asar' => '16:02','Maghrib' => '18:49', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:39','Zohor' => '12:45', 'Asar' => '16:01','Maghrib' => '18:48', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:10','Subuh' => '05:20', 'Syuruk' => '06:39','Zohor' => '12:45', 'Asar' => '16:01','Maghrib' => '18:48', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:10','Subuh' => '05:20', 'Syuruk' => '06:39','Zohor' => '12:44', 'Asar' => '16:00','Maghrib' => '18:48', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:10','Subuh' => '05:20', 'Syuruk' => '06:39','Zohor' => '12:44', 'Asar' => '15:59','Maghrib' => '18:48', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:10','Subuh' => '05:20', 'Syuruk' => '06:38','Zohor' => '12:44', 'Asar' => '15:59','Maghrib' => '18:47', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:10','Subuh' => '05:20', 'Syuruk' => '06:38','Zohor' => '12:44', 'Asar' => '15:58','Maghrib' => '18:47', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:10','Subuh' => '05:20', 'Syuruk' => '06:38','Zohor' => '12:43', 'Asar' => '15:57','Maghrib' => '18:47', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:10','Subuh' => '05:20', 'Syuruk' => '06:38','Zohor' => '12:43', 'Asar' => '15:57','Maghrib' => '18:46', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:10','Subuh' => '05:20', 'Syuruk' => '06:37','Zohor' => '12:43', 'Asar' => '15:56','Maghrib' => '18:46', 'Isyak' => '19:56'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:37','Zohor' => '12:43', 'Asar' => '15:55','Maghrib' => '18:46', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:37','Zohor' => '12:42', 'Asar' => '15:54','Maghrib' => '18:45', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:37','Zohor' => '12:42', 'Asar' => '15:54','Maghrib' => '18:45', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK07', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:09','Subuh' => '05:19', 'Syuruk' => '06:37','Zohor' => '12:42', 'Asar' => '15:54','Maghrib' => '18:45', 'Isyak' => '19:55'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:43','Zohor' => '12:50', 'Asar' => '16:12','Maghrib' => '18:55', 'Isyak' => '20:07'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:43','Zohor' => '12:50', 'Asar' => '16:11','Maghrib' => '18:54', 'Isyak' => '20:07'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:43','Zohor' => '12:50', 'Asar' => '16:11','Maghrib' => '18:54', 'Isyak' => '20:07'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:42','Zohor' => '12:50', 'Asar' => '16:11','Maghrib' => '18:54', 'Isyak' => '20:06'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:42','Zohor' => '12:50', 'Asar' => '16:11','Maghrib' => '18:54', 'Isyak' => '20:06'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:42','Zohor' => '12:50', 'Asar' => '16:10','Maghrib' => '18:54', 'Isyak' => '20:06'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:42','Zohor' => '12:50', 'Asar' => '16:10','Maghrib' => '18:54', 'Isyak' => '20:06'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:42','Zohor' => '12:49', 'Asar' => '16:09','Maghrib' => '18:54', 'Isyak' => '20:05'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:42','Zohor' => '12:49', 'Asar' => '16:09','Maghrib' => '18:53', 'Isyak' => '20:05'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:42','Zohor' => '12:49', 'Asar' => '16:09','Maghrib' => '18:53', 'Isyak' => '20:05'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:42','Zohor' => '12:49', 'Asar' => '16:08','Maghrib' => '18:53', 'Isyak' => '20:04'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:42','Zohor' => '12:49', 'Asar' => '16:08','Maghrib' => '18:53', 'Isyak' => '20:04'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:42','Zohor' => '12:49', 'Asar' => '16:07','Maghrib' => '18:53', 'Isyak' => '20:04'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:41','Zohor' => '12:49', 'Asar' => '16:07','Maghrib' => '18:52', 'Isyak' => '20:04'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:41','Zohor' => '12:48', 'Asar' => '16:06','Maghrib' => '18:52', 'Isyak' => '20:03'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:41','Zohor' => '12:48', 'Asar' => '16:06','Maghrib' => '18:52', 'Isyak' => '20:03'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:41','Zohor' => '12:48', 'Asar' => '16:05','Maghrib' => '18:52', 'Isyak' => '20:03'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:41','Zohor' => '12:48', 'Asar' => '16:05','Maghrib' => '18:51', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:41','Zohor' => '12:47', 'Asar' => '16:04','Maghrib' => '18:51', 'Isyak' => '20:02'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:40','Zohor' => '12:47', 'Asar' => '16:03','Maghrib' => '18:51', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:13','Subuh' => '05:23', 'Syuruk' => '06:40','Zohor' => '12:47', 'Asar' => '16:03','Maghrib' => '18:51', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:12','Subuh' => '05:22', 'Syuruk' => '06:40','Zohor' => '12:47', 'Asar' => '16:02','Maghrib' => '18:50', 'Isyak' => '20:01'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:12','Subuh' => '05:22', 'Syuruk' => '06:40','Zohor' => '12:47', 'Asar' => '16:02','Maghrib' => '18:50', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:12','Subuh' => '05:22', 'Syuruk' => '06:40','Zohor' => '12:46', 'Asar' => '16:01','Maghrib' => '18:50', 'Isyak' => '20:00'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '05:12','Subuh' => '05:22', 'Syuruk' => '06:39','Zohor' => '12:46', 'Asar' => '16:00','Maghrib' => '18:49', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '05:12','Subuh' => '05:22', 'Syuruk' => '06:39','Zohor' => '12:46', 'Asar' => '15:59','Maghrib' => '18:49', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '05:12','Subuh' => '05:22', 'Syuruk' => '06:39','Zohor' => '12:45', 'Asar' => '15:59','Maghrib' => '18:49', 'Isyak' => '19:59'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '05:12','Subuh' => '05:22', 'Syuruk' => '06:39','Zohor' => '12:45', 'Asar' => '15:58','Maghrib' => '18:48', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '05:12','Subuh' => '05:22', 'Syuruk' => '06:38','Zohor' => '12:45', 'Asar' => '15:57','Maghrib' => '18:48', 'Isyak' => '19:58'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:38','Zohor' => '12:45', 'Asar' => '15:56','Maghrib' => '18:48', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:38','Zohor' => '12:44', 'Asar' => '15:56','Maghrib' => '18:47', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SWK08', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '05:11','Subuh' => '05:21', 'Syuruk' => '06:38','Zohor' => '12:44', 'Asar' => '15:56','Maghrib' => '18:47', 'Isyak' => '19:57'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:44','Maghrib' => '19:30', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:29', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:29', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:42','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:42','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:41','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:41','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:40','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:40','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:39','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:39','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:38','Maghrib' => '19:27', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:21', 'Asar' => '16:38','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:21', 'Asar' => '16:37','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:37','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:36','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:35','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:35','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:34','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:33','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:10','Zohor' => '13:19', 'Asar' => '16:33','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:10','Zohor' => '13:19', 'Asar' => '16:32','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:19', 'Asar' => '16:31','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:30','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:30','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:29','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:28','Maghrib' => '19:22', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:27','Maghrib' => '19:22', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:26','Maghrib' => '19:22', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:25','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'SGR01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:25','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:44','Maghrib' => '19:30', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:29', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:29', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:42','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:42','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:41','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:41','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:40','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:40','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:39','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:39','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:38','Maghrib' => '19:27', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:21', 'Asar' => '16:38','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:21', 'Asar' => '16:37','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:37','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:36','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:35','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:35','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:34','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:33','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:10','Zohor' => '13:19', 'Asar' => '16:33','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:10','Zohor' => '13:19', 'Asar' => '16:32','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:19', 'Asar' => '16:31','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:30','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:30','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:29','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:28','Maghrib' => '19:22', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:27','Maghrib' => '19:22', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:26','Maghrib' => '19:22', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:25','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'SGR03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:25','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:41','Subuh' => '5:51', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:44','Maghrib' => '19:30', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:29', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:43','Maghrib' => '19:29', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:42','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:42','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:41','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:41','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:40','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:12','Zohor' => '13:22', 'Asar' => '16:40','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:39','Maghrib' => '19:28', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:39','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:38','Maghrib' => '19:27', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:21', 'Asar' => '16:38','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:21', 'Asar' => '16:37','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:37','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:36','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:35','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:35','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:20', 'Asar' => '16:34','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:33','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:10','Zohor' => '13:19', 'Asar' => '16:33','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:10','Zohor' => '13:19', 'Asar' => '16:32','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:19', 'Asar' => '16:31','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:30','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:30','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:10','Zohor' => '13:18', 'Asar' => '16:29','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:28','Maghrib' => '19:22', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:27','Maghrib' => '19:22', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:26','Maghrib' => '19:22', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:25','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'SGR04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:42','Subuh' => '5:52', 'Syuruk' => '7:09','Zohor' => '13:17', 'Asar' => '16:25','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:43','Subuh' => '5:53', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:46','Maghrib' => '19:32', 'Isyak' => '20:45'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:45','Maghrib' => '19:32', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:45','Maghrib' => '19:31', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:45','Maghrib' => '19:31', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:44','Maghrib' => '19:31', 'Isyak' => '20:44'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:44','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:43','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:43','Maghrib' => '19:31', 'Isyak' => '20:43'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:42','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:14','Zohor' => '13:24', 'Asar' => '16:42','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:14','Zohor' => '13:23', 'Asar' => '16:41','Maghrib' => '19:30', 'Isyak' => '20:42'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:14','Zohor' => '13:23', 'Asar' => '16:41','Maghrib' => '19:30', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:23', 'Asar' => '16:40','Maghrib' => '19:29', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:23', 'Asar' => '16:40','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:23', 'Asar' => '16:39','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:22', 'Asar' => '16:39','Maghrib' => '19:29', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:22', 'Asar' => '16:38','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:22', 'Asar' => '16:37','Maghrib' => '19:28', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:22', 'Asar' => '16:37','Maghrib' => '19:28', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:22', 'Asar' => '16:36','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:13','Zohor' => '13:21', 'Asar' => '16:35','Maghrib' => '19:27', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:45','Subuh' => '5:55', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:35','Maghrib' => '19:27', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:34','Maghrib' => '19:26', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:12','Zohor' => '13:21', 'Asar' => '16:33','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:12','Zohor' => '13:20', 'Asar' => '16:32','Maghrib' => '19:26', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:12','Zohor' => '13:20', 'Asar' => '16:32','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:12','Zohor' => '13:20', 'Asar' => '16:31','Maghrib' => '19:25', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:30','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:29','Maghrib' => '19:24', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:28','Maghrib' => '19:24', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:27','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'SGR02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:44','Subuh' => '5:54', 'Syuruk' => '7:11','Zohor' => '13:19', 'Asar' => '16:27','Maghrib' => '19:23', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:39','Maghrib' => '19:28', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:38','Maghrib' => '19:28', 'Isyak' => '20:41'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:38','Maghrib' => '19:27', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:38','Maghrib' => '19:27', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:37','Maghrib' => '19:27', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:37','Maghrib' => '19:27', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:36','Maghrib' => '19:27', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:36','Maghrib' => '19:26', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:35','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:35','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:34','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:34','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:33','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:32','Maghrib' => '19:25', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:05','Zohor' => '13:17', 'Asar' => '16:32','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:31','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:30','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:30','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:29','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:28','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:28','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:27','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:26','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:14', 'Asar' => '16:25','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:14', 'Asar' => '16:24','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:14', 'Asar' => '16:23','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:14', 'Asar' => '16:23','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:13', 'Asar' => '16:22','Maghrib' => '19:19', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:13', 'Asar' => '16:21','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:13', 'Asar' => '16:20','Maghrib' => '19:18', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:12', 'Asar' => '16:19','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'TRG02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:12', 'Asar' => '16:19','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:39','Maghrib' => '19:27', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:38','Maghrib' => '19:27', 'Isyak' => '20:40'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:38','Maghrib' => '19:26', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:37','Maghrib' => '19:26', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:18', 'Asar' => '16:37','Maghrib' => '19:26', 'Isyak' => '20:39'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:37','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:36','Maghrib' => '19:26', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:36','Maghrib' => '19:25', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:35','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:35','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:34','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:17', 'Asar' => '16:34','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:16', 'Asar' => '16:33','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:06','Zohor' => '13:16', 'Asar' => '16:32','Maghrib' => '19:24', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:32','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:31','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:30','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:30','Maghrib' => '19:22', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:29','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:28','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:28','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:14', 'Asar' => '16:27','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:05','Zohor' => '13:14', 'Asar' => '16:26','Maghrib' => '19:21', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:14', 'Asar' => '16:25','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:14', 'Asar' => '16:24','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:13', 'Asar' => '16:24','Maghrib' => '19:19', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:37','Subuh' => '5:47', 'Syuruk' => '7:04','Zohor' => '13:13', 'Asar' => '16:23','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:13', 'Asar' => '16:22','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:13', 'Asar' => '16:21','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:12', 'Asar' => '16:20','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:03','Zohor' => '13:12', 'Asar' => '16:19','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'TRG03', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:03','Zohor' => '13:12', 'Asar' => '16:19','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:37','Maghrib' => '19:25', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:37','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:37','Maghrib' => '19:24', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:36','Maghrib' => '19:24', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:36','Maghrib' => '19:24', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:35','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:35','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:35','Maghrib' => '19:23', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:34','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:05','Zohor' => '13:16', 'Asar' => '16:34','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:33','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:32','Maghrib' => '19:22', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:32','Maghrib' => '19:22', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:31','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:31','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:05','Zohor' => '13:15', 'Asar' => '16:30','Maghrib' => '19:21', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:14', 'Asar' => '16:29','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:14', 'Asar' => '16:29','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:14', 'Asar' => '16:28','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:14', 'Asar' => '16:27','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:13', 'Asar' => '16:27','Maghrib' => '19:20', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:13', 'Asar' => '16:26','Maghrib' => '19:19', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:13', 'Asar' => '16:25','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:04','Zohor' => '13:13', 'Asar' => '16:24','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:03','Zohor' => '13:12', 'Asar' => '16:24','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:03','Zohor' => '13:12', 'Asar' => '16:23','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:03','Zohor' => '13:12', 'Asar' => '16:22','Maghrib' => '19:17', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:36','Subuh' => '5:46', 'Syuruk' => '7:03','Zohor' => '13:12', 'Asar' => '16:21','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:03','Zohor' => '13:11', 'Asar' => '16:20','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:03','Zohor' => '13:11', 'Asar' => '16:19','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:18','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'TRG04', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:18','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:04','Zohor' => '13:16', 'Asar' => '16:37','Maghrib' => '19:25', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:04','Zohor' => '13:16', 'Asar' => '16:36','Maghrib' => '19:25', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:04','Zohor' => '13:16', 'Asar' => '16:36','Maghrib' => '19:25', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:04','Zohor' => '13:16', 'Asar' => '16:36','Maghrib' => '19:25', 'Isyak' => '20:38'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:33','Subuh' => '5:43', 'Syuruk' => '7:04','Zohor' => '13:16', 'Asar' => '16:35','Maghrib' => '19:25', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:04','Zohor' => '13:16', 'Asar' => '16:35','Maghrib' => '19:24', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:04','Zohor' => '13:16', 'Asar' => '16:34','Maghrib' => '19:24', 'Isyak' => '20:37'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:04','Zohor' => '13:15', 'Asar' => '16:34','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:04','Zohor' => '13:15', 'Asar' => '16:33','Maghrib' => '19:24', 'Isyak' => '20:36'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:04','Zohor' => '13:15', 'Asar' => '16:33','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:04','Zohor' => '13:15', 'Asar' => '16:32','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:04','Zohor' => '13:15', 'Asar' => '16:32','Maghrib' => '19:23', 'Isyak' => '20:35'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:04','Zohor' => '13:15', 'Asar' => '16:31','Maghrib' => '19:23', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:04','Zohor' => '13:14', 'Asar' => '16:30','Maghrib' => '19:22', 'Isyak' => '20:34'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:35','Subuh' => '5:44', 'Syuruk' => '7:03','Zohor' => '13:14', 'Asar' => '16:30','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:03','Zohor' => '13:14', 'Asar' => '16:29','Maghrib' => '19:22', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:03','Zohor' => '13:14', 'Asar' => '16:28','Maghrib' => '19:21', 'Isyak' => '20:33'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:03','Zohor' => '13:14', 'Asar' => '16:28','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:03','Zohor' => '13:13', 'Asar' => '16:27','Maghrib' => '19:21', 'Isyak' => '20:32'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:03','Zohor' => '13:13', 'Asar' => '16:26','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:03','Zohor' => '13:13', 'Asar' => '16:26','Maghrib' => '19:20', 'Isyak' => '20:31'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:03','Zohor' => '13:13', 'Asar' => '16:25','Maghrib' => '19:19', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:03','Zohor' => '13:12', 'Asar' => '16:24','Maghrib' => '19:19', 'Isyak' => '20:30'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:03','Zohor' => '13:12', 'Asar' => '16:23','Maghrib' => '19:19', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:02','Zohor' => '13:12', 'Asar' => '16:22','Maghrib' => '19:18', 'Isyak' => '20:29'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:02','Zohor' => '13:12', 'Asar' => '16:21','Maghrib' => '19:18', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '5:35','Subuh' => '5:45', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:21','Maghrib' => '19:17', 'Isyak' => '20:28'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:20','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '19:19','Maghrib' => '19:17', 'Isyak' => '20:27'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:02','Zohor' => '13:11', 'Asar' => '16:18','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:01','Zohor' => '13:10', 'Asar' => '16:17','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'TRG01', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '5:34','Subuh' => '5:44', 'Syuruk' => '7:01','Zohor' => '13:10', 'Asar' => '16:17','Maghrib' => '19:16', 'Isyak' => '20:26'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '01-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:14','Zohor' => '12:27', 'Asar' => '15:48','Maghrib' => '18:36', 'Isyak' => '19:49'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '02-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:15','Zohor' => '12:27', 'Asar' => '15:47','Maghrib' => '18:36', 'Isyak' => '19:49'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '03-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:15','Zohor' => '12:27', 'Asar' => '15:47','Maghrib' => '18:36', 'Isyak' => '19:49'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '04-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:15','Zohor' => '12:27', 'Asar' => '15:46','Maghrib' => '18:36', 'Isyak' => '19:49'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '05-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:15','Zohor' => '12:27', 'Asar' => '15:46','Maghrib' => '18:36', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '06-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:44','Subuh' => '4:54', 'Syuruk' => '6:15','Zohor' => '12:27', 'Asar' => '15:46','Maghrib' => '18:35', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '07-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:15','Zohor' => '12:27', 'Asar' => '15:45','Maghrib' => '18:35', 'Isyak' => '19:48'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '08-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:15','Zohor' => '12:26', 'Asar' => '15:45','Maghrib' => '18:35', 'Isyak' => '19:47'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '09-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:15','Zohor' => '12:26', 'Asar' => '15:44','Maghrib' => '18:35', 'Isyak' => '19:47'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '10-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:15','Zohor' => '12:26', 'Asar' => '15:44','Maghrib' => '18:34', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '11-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:15','Zohor' => '12:26', 'Asar' => '15:43','Maghrib' => '18:34', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '12-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:15','Zohor' => '12:26', 'Asar' => '15:43','Maghrib' => '18:34', 'Isyak' => '19:46'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '13-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:14','Zohor' => '12:26', 'Asar' => '15:42','Maghrib' => '18:34', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '14-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:41','Maghrib' => '18:33', 'Isyak' => '19:45'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '15-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:41','Maghrib' => '18:33', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '16-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:40','Maghrib' => '18:33', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '17-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:39','Maghrib' => '18:32', 'Isyak' => '19:44'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '18-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:46','Subuh' => '4:56', 'Syuruk' => '6:14','Zohor' => '12:25', 'Asar' => '15:39','Maghrib' => '18:32', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '19-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:46','Subuh' => '4:56', 'Syuruk' => '6:14','Zohor' => '12:24', 'Asar' => '15:38','Maghrib' => '18:32', 'Isyak' => '19:43'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '20-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:46','Subuh' => '4:56', 'Syuruk' => '6:14','Zohor' => '12:24', 'Asar' => '15:37','Maghrib' => '18:31', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '21-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:46','Subuh' => '4:56', 'Syuruk' => '6:14','Zohor' => '12:24', 'Asar' => '15:36','Maghrib' => '18:31', 'Isyak' => '19:42'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '22-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:46','Subuh' => '4:56', 'Syuruk' => '6:14','Zohor' => '12:24', 'Asar' => '15:36','Maghrib' => '18:30', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '23-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:46','Subuh' => '4:56', 'Syuruk' => '6:14','Zohor' => '12:23', 'Asar' => '15:35','Maghrib' => '18:30', 'Isyak' => '19:41'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '24-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:46','Subuh' => '4:56', 'Syuruk' => '6:13','Zohor' => '12:23', 'Asar' => '15:34','Maghrib' => '18:30', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '25-08-2011', 'hari' => 'Khamis', 'Imsak' => '4:46','Subuh' => '4:56', 'Syuruk' => '6:13','Zohor' => '12:23', 'Asar' => '15:33','Maghrib' => '18:29', 'Isyak' => '19:40'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '26-08-2011', 'hari' => 'Jumaat', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:13','Zohor' => '12:23', 'Asar' => '15:32','Maghrib' => '18:29', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '27-08-2011', 'hari' => 'Sabtu', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:13','Zohor' => '12:22', 'Asar' => '15:32','Maghrib' => '18:28', 'Isyak' => '19:39'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '28-08-2011', 'hari' => 'Ahad', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:13','Zohor' => '12:22', 'Asar' => '15:31','Maghrib' => '18:28', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '29-08-2011', 'hari' => 'Isnin', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:13','Zohor' => '12:22', 'Asar' => '15:30','Maghrib' => '18:28', 'Isyak' => '19:38'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '30-08-2011', 'hari' => 'Selasa', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:13','Zohor' => '12:21', 'Asar' => '15:29','Maghrib' => '18:27', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:12','Zohor' => '12:21', 'Asar' => '15:28','Maghrib' => '18:27', 'Isyak' => '19:37'),
			array('kod_kawasan' => 'WLY02', 'tarikh' => '31-08-2011', 'hari' => 'Rabu', 'Imsak' => '4:45','Subuh' => '4:55', 'Syuruk' => '6:12','Zohor' => '12:21', 'Asar' => '15:28','Maghrib' => '18:27', 'Isyak' => '19:37'),
			);

        return $waktu;
    }	
?>
