<?php
/**
 * Plugin Name: W3S API Extension
 * Description: Enhances your store's REST API by adding powerful, flexible endpoints. Stay tuned more Endpoints are coming!
 * Version: 1.0.1
 * Requires at least: 6.0
 * Tested up to: 6.8
 * Requires PHP: 7.4
 * Requires Plugins: woocommerce
 * Author: w3specialists.com
 * Author URI: https://www.w3specialists.com/
 * Text Domain: w3s-api-extension
 * Domain Path: /languages/
 * WC requires at least: 3.5
 * WC tested up to: 9.8.5
 * License: GPLv3
 * License URI: https://www.gnu.org/licenses/gpl-3.0.html
 */
if ( ! defined( 'WPINC' ) ) {
	die;
}

class W3S_Woo_API_Extension {
    const VERSION = '1.0.0';
    private static $instance = null;

    public static function instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        $this->includes();
        add_action( 'rest_api_init', array( $this, 'register_routes' ) );
        register_activation_hook( __FILE__, array( __CLASS__, 'activate' ) );
        register_deactivation_hook( __FILE__, array( __CLASS__, 'deactivate' ) );
        
        add_action( 'before_woocommerce_init', function() {
            if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
                \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables',__FILE__,true);
            }
        } ); 
    }

    private function includes() {
        $ext_files = array(
            'w3s-woo-api-add-category.php',
            'w3s-woo-api-remove-category.php',
            'w3s-woo-api-batch-remove-category.php',
            'w3s-woo-api-batch-add-category.php'
        );
        $ext_dir = plugin_dir_path( __FILE__ ) . 'extensions/';
        foreach ( $ext_files as $file ) {
            require_once $ext_dir . $file;
        }
    }

    public function register_routes() {
        if ( class_exists( 'W3S_Woo_API_Add_Category_Extension' ) ) {
            W3S_Woo_API_Add_Category_Extension::register_route();
        }
        if ( class_exists( 'W3S_Woo_API_Remove_Category_Extension' ) ) {
            W3S_Woo_API_Remove_Category_Extension::register_route();
        }
        if ( class_exists( 'W3S_Woo_API_Batch_Add_Category_Extension' ) ) {
            W3S_Woo_API_Batch_Add_Category_Extension::register_route();
        }
        if ( class_exists( 'W3S_Woo_API_Batch_Remove_Category_Extension' ) ) {
            W3S_Woo_API_Batch_Remove_Category_Extension::register_route();
        }
    }

    public static function activate() {
        flush_rewrite_rules();
    }

    public static function deactivate() {
        self::$instance = null;
        flush_rewrite_rules();
    }
}

W3S_Woo_API_Extension::instance();