<?php

class W3S_Woo_API_Remove_Category_Extension {
    public static function register_route() {
        register_rest_route(
            'wc/v3', 
            '/products/(?P<product_id>\d+)/categories/(?P<identifier>[a-z0-9-]+)/?', 
            array(
                'methods'             => WP_REST_Server::DELETABLE,
                'callback'            => array(__CLASS__, 'remove_category'),
                'permission_callback' => array(__CLASS__, 'permissions_check'),
                'args'                => array(
                    'product_id' => array(
                        'validate_callback' => array(__CLASS__, 'validate_numeric')
                    ),
                    'identifier' => array(
                        'validate_callback' => array(__CLASS__, 'validate_identifier')
                    ),
                ),
            )
        );
    }

    public static function validate_numeric($param, $request, $key) {
        return is_numeric($param);
    }

    public static function validate_identifier($param, $request, $key) {
        return is_numeric($param) || preg_match('/^[a-z0-9-]+$/', $param);
    }

    public static function permissions_check($request) {
        return current_user_can('edit_products');
    }

    public static function remove_category($request) {
        $product_id = absint($request['product_id']);
        $identifier = sanitize_text_field( wp_unslash( $request['identifier'] ) );

        if (is_numeric($identifier)) {
            $cat_id = absint($identifier);
        } else {
            $term = get_term_by('slug', sanitize_title($identifier), 'product_cat');
            if (!$term) {
                return new WP_Error(
                    'w3s_api_extension_invalid_product_category',
                    __('Category does not exist.', 'w3s-api-extension'),
                    array('status' => 404)
                );
            }
            $cat_id = $term->term_id;
        }

        $product = wc_get_product($product_id);
        if (!$product) {
            return new WP_Error(
                'w3s_api_extension_invalid_product',
                __('Product does not exist.', 'w3s-api-extension'),
                array('status' => 404)
            );
        }

        $existing_ids = wp_get_post_terms($product_id, 'product_cat', array('fields' => 'ids'));
        $new_ids = array_diff($existing_ids, array($cat_id));
        $result = wp_set_post_terms($product_id, $new_ids, 'product_cat', false);
        if (is_wp_error($result)) {
            return $result;
        }

        $terms = wp_get_post_terms($product_id, 'product_cat', array('fields' => 'all'));
        return rest_ensure_response($terms);
    }
}