<?php

class W3S_Woo_API_Batch_Add_Category_Extension {
    public static function register_route() {
        register_rest_route(
            'wc/v3',
            '/products/(?P<product_id>\d+)/categories',
            array(
                'methods'             => WP_REST_Server::EDITABLE,
                'callback'            => array(__CLASS__, 'add_categories'),
                'permission_callback' => array(__CLASS__, 'permissions_check'),
                'args'                => array(
                    'product_id' => array(
                        'validate_callback' => array(__CLASS__, 'validate_numeric')
                    ),
                ),
            )
        );
    }

    public static function validate_numeric($param, $request, $key) {
        return is_numeric($param);
    }

    public static function permissions_check($request) {
        return current_user_can('edit_products');
    }

    public static function add_categories($request) {
        $product_id = absint($request['product_id']);
        $body = $request->get_json_params();

        $product = wc_get_product($product_id);
        if (!$product) {
            return new WP_Error(
                'w3s_api_extension_invalid_product',
                __('Product does not exist.', 'w3s-api-extension'),
                array('status' => 404)
            );
        }

        if (empty($body['categories']) || !is_array($body['categories'])) {
            return new WP_Error(
                'w3s_api_extension_invalid_product_category',
                __('Request body must contain a "categories" array.', 'w3s-api-extension'),
                array('status' => 400)
            );
        }

        $add_ids = array();
        foreach ($body['categories'] as $identifier) {
            $id_or_slug = sanitize_text_field( wp_unslash( $identifier ) );
            if (is_numeric($id_or_slug)) {
                $add_ids[] = absint($id_or_slug);
            } else {
                $term = get_term_by('slug', sanitize_title($id_or_slug), 'product_cat');
                if (!$term) {
                    return new WP_Error(
                        'w3s_api_extension_invalid_product_category',
                        /* translators: %s: Identifier of category */
                        sprintf(__('Category does not exist: %s', 'w3s-api-extension'), $id_or_slug),
                        array('status' => 404)
                    );
                }
                $add_ids[] = $term->term_id;
            }
        }

        $existing = wp_get_post_terms($product_id, 'product_cat', array('fields' => 'ids'));
        $new_ids = array_unique(array_merge($existing, $add_ids));

        $updated = wp_set_post_terms($product_id, $new_ids, 'product_cat', false);
        if (is_wp_error($updated)) {
            return $updated;
        }

        $terms = wp_get_post_terms($product_id, 'product_cat', array('fields' => 'all'));
        return rest_ensure_response($terms);
    }
}