<?php if ( ! defined( 'ABSPATH' ) ) { exit; } ?>
<div class="wrap vulnity-setup-wrap">
    <div class="vulnity-setup-shell">
        <section class="vulnity-setup-hero">
            <div class="vulnity-setup-hero-copy">
                <h1>Vulnity Security Setup</h1>
                <p>Connect this site to Vulnity SIEM to enable monitoring, synchronization, and mitigation workflows.</p>
            </div>
            <div class="vulnity-setup-hero-meta">
                <span class="vulnity-chip vulnity-chip-neutral">Step 1 of 1</span>
                <span class="vulnity-chip vulnity-chip-soft">SIEM Pairing</span>
            </div>
        </section>

        <div id="vulnity-messages"></div>

        <div class="vulnity-setup-grid">
            <section class="card vulnity-setup-card vulnity-setup-connect">
                <header class="vulnity-setup-card-header">
                    <h2>Connect to Vulnity SIEM</h2>
                    <p>Use the credentials generated in your Vulnity SIEM dashboard.</p>
                </header>

                <form id="vulnity-form" class="vulnity-setup-form">
                    <input type="hidden" name="nonce" value="<?php echo esc_attr( wp_create_nonce( 'vulnity_nonce' ) ); ?>" />

                    <div class="vulnity-setup-field">
                        <label for="site_id">Site ID</label>
                        <input type="text" id="site_id" name="site_id" class="vulnity-setup-input" placeholder="e.g. 3181e8c6-b338-4426-adc6-24a2b1b9aa17" required />
                        <p class="description">Paste the Site ID exactly as shown in SIEM.</p>
                    </div>

                    <div class="vulnity-setup-field">
                        <label for="pair_code">Pairing Code</label>
                        <input type="text" id="pair_code" name="pair_code" class="vulnity-setup-input" placeholder="8 character code" maxlength="8" required />
                        <p class="description">Enter the one-time 8 character pairing code.</p>
                        <p class="description">
                            Need help finding your Site ID or Pairing Code?
                            <a href="<?php echo esc_url('https://vulnity.io'); ?>" target="_blank" rel="noopener noreferrer">Vulnity</a>
                            or the
                            <a href="<?php echo esc_url('https://vulnity.gitbook.io/vulnity-docs/instalaciones/quickstart'); ?>" target="_blank" rel="noopener noreferrer">Quickstart guide</a>.
                        </p>
                    </div>

                    <div class="vulnity-setup-field">
                        <label for="public_ip_whitelist">Which public IP should always be allowed?</label>
                        <input type="text" id="public_ip_whitelist" name="public_ip_whitelist" class="vulnity-setup-input" placeholder="e.g. 203.0.113.10 or 2001:db8::1" />
                        <p class="description">Optional. If provided, this IP is added to the whitelist immediately after pairing.</p>
                    </div>

                    <div class="vulnity-setup-actions">
                        <button type="submit" class="button button-primary vulnity-setup-submit">Connect Plugin</button>
                    </div>
                </form>
            </section>

            <aside class="card vulnity-setup-card vulnity-setup-help">
                <header class="vulnity-setup-card-header">
                    <h3>How to get your credentials</h3>
                    <p>Follow this flow from your SIEM dashboard.</p>
                </header>
                <ol class="vulnity-setup-steps">
                    <li>Sign in to Vulnity SIEM.</li>
                    <li>Open Sites and create a new site record.</li>
                    <li>Copy the Site ID and Pairing Code.</li>
                    <li>Paste both values here and connect.</li>
                </ol>
                <div class="vulnity-setup-note">
                    <h4>Before you connect</h4>
                    <ul>
                        <li>Use credentials from the same SIEM environment.</li>
                        <li>Do not add extra spaces before or after values.</li>
                        <li>Keep this page open until you see the success message.</li>
                    </ul>
                </div>
            </aside>
        </div>
    </div>
</div>
