<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class Vulnity_Theme_Change_Alert extends Vulnity_Alert_Base {
    
    public function __construct() {
        $this->alert_type = 'theme_change';
        parent::__construct();
    }
    
    protected function register_hooks() {
        add_action('switch_theme', array($this, 'on_theme_switched'), 10, 3);
        add_action('upgrader_process_complete', array($this, 'on_theme_updated'), 10, 2);
        add_action('deleted_theme', array($this, 'on_theme_deleted'), 10, 2);
    }
    
    public function on_theme_switched($new_name, $new_theme, $old_theme) {
        $this->evaluate(array(
            'action' => 'switched',
            'new_theme' => $new_name,
            'old_theme' => $old_theme ? $old_theme->get('Name') : 'Unknown'
        ));
    }
    
    public function on_theme_updated($upgrader, $hook_extra) {
        if ($hook_extra['type'] !== 'theme') {
            return;
        }
        
        if ($hook_extra['action'] === 'install') {
            $this->evaluate(array(
                'action' => 'installed',
                'themes' => isset($hook_extra['themes']) ? $hook_extra['themes'] : array()
            ));
        } elseif ($hook_extra['action'] === 'update') {
            $this->evaluate(array(
                'action' => 'updated',
                'themes' => isset($hook_extra['themes']) ? $hook_extra['themes'] : array()
            ));
        }
    }
    
    public function on_theme_deleted($stylesheet, $deleted) {
        if ($deleted) {
            $this->evaluate(array(
                'action' => 'deleted',
                'theme' => $stylesheet
            ));
        }
    }
    
    protected function evaluate($data) {
        $current_user_info = $this->get_current_user_info();
        
        $severity = 'medium';
        $title = '';
        $message = '';
        
        switch ($data['action']) {
            case 'switched':
                $severity = 'high';
                $title = 'Theme Changed';
                $message = sprintf(
                    'Theme changed from "%s" to "%s" by user "%s" from IP %s',
                    $data['old_theme'],
                    $data['new_theme'],
                    $current_user_info['user_login'],
                    $current_user_info['user_ip']
                );
                break;
                
            case 'installed':
                $severity = 'high';
                $title = 'New Theme Installed';
                $message = sprintf(
                    'New theme was installed by user "%s" from IP %s',
                    $current_user_info['user_login'],
                    $current_user_info['user_ip']
                );
                break;
                
            case 'updated':
                $severity = 'low';
                $title = 'Theme Updated';
                $message = sprintf(
                    'Theme was updated by user "%s" from IP %s',
                    $current_user_info['user_login'],
                    $current_user_info['user_ip']
                );
                break;
                
            case 'deleted':
                $severity = 'medium';
                $title = 'Theme Deleted';
                $message = sprintf(
                    'Theme "%s" was deleted by user "%s" from IP %s',
                    $data['theme'],
                    $current_user_info['user_login'],
                    $current_user_info['user_ip']
                );
                break;
        }
        
        if (empty($title)) {
            return;
        }
        
        $this->create_alert(array(
            'severity' => $severity,
            'title' => $title,
            'message' => $message,
            'details' => array(
                'action' => $data['action'],
                'theme_data' => $data,
                'user_id' => $current_user_info['user_id'],
                'user_login' => $current_user_info['user_login'],
                'user_email' => $current_user_info['user_email'],
                'user_ip' => $current_user_info['user_ip'],
                'timestamp' => current_time('mysql')
            )
        ));
    }
}
