# Changelog - Vulnity Security

## [1.1.8] - 2026-02-12

### Fix Wrning error
- **Fixed:** Warning message was displayed on every load; now it is shown only once.

## [1.1.7] - 2026-02-12

### Deactivation & Cleanup Fixes
- **Fixed:** 4 missing cron hooks not cleared on deactivation (`vulnity_sync_mitigation_config`, `vulnity_cleanup_flood_data`, `vulnity_process_brute_force_windows`, `vulnity_triggered_inventory_sync`)
- **Fixed:** Cron events re-scheduled by late-firing alert hooks (e.g. plugin-change alerts triggering inventory sync) now cleared via `final_deactivation_cleanup` at priority 9999
- **Fixed:** Replaced `wp_clear_scheduled_hook` with `wp_unschedule_hook` to properly clear single events with arguments
- **Fixed:** `.htaccess` marker removal now has native PHP fallback when WP_Filesystem is unavailable during deactivation
- **Fixed:** Plugin Check error — replaced direct `is_writable()` call with `vulnity_path_is_writable()` and `WP_Filesystem_Direct`

## [1.1.6] - 2026-02-11

### 🔴 Critical Bug Fixes

#### Race Conditions & Concurrency
- **Fixed:** Race condition in log rotation that could cause data loss when multiple processes rotate logs simultaneously
  - Added atomic file locking with `flock(LOCK_EX | LOCK_NB)`
  - Implemented double-check pattern after lock acquisition
  - Files: `vulnity.php:471-518`

- **Fixed:** Race condition in `save_local_alert()` that could lose critical alerts
  - Implemented transient-based locking with 10s timeout
  - Added try-finally block to ensure lock release
  - Files: `includes/alerts/class-alert-base.php:138-177`

#### Memory Exhaustion
- **Fixed:** Memory exhaustion when counting lines in large log files (100MB+)
  - Replaced full file loading with streaming using `fgets()`
  - Now processes files line-by-line without loading into RAM
  - Files: `vulnity.php:425-448`

#### Stack Overflow & Performance
- **Fixed:** Recursive retry logic with blocking `sleep()` causing stack overflow and timeouts (up to 75s)
  - Converted recursive function to iterative loop
  - Removed blocking `sleep()` calls
  - Delegated retries to asynchronous cron jobs
  - Files: `includes/alerts/class-alert-base.php:153-186`

- **Fixed:** Fatal error when calling `wp_get_theme()->get('Name')` on missing theme
  - Created safe helper method `get_safe_theme_name()` with validation
  - Returns 'Unknown' instead of crashing
  - Files: `includes/class-security-monitor.php:510-521`

### 🟠 Security Improvements

#### Input Sanitization (Plugin Check Compliance)
- **Added:** Global helper function `vulnity_get_server_var()` using `filter_input(INPUT_SERVER)`
  - Complies with WordPress Plugin Check standards
  - Includes fallback for CLI/test environments
  - Files: `vulnity.php:533-579`

- **Improved:** Replaced 15+ direct `$_SERVER` accesses with sanitized helper
  - `includes/alerts/class-alert-base.php` - 6 locations
  - `includes/class-static-security.php` - 5 locations
  - `includes/alerts/class-file-editor-alert.php` - 2 locations
  - `includes/alerts/class-suspicious-query-alert.php` - 2 locations

#### Code Quality
- **Fixed:** Weak comparison (`==`) changed to strict comparison (`===`)
  - Files: `includes/class-anti-collapse.php:114`

### 🔵 Apache/Nginx Compatibility

#### Server Detection & Configuration
- **Added:** Server type detection (`detect_server_type()`)
  - Detects Apache, Nginx, LiteSpeed, or Unknown
  - Files: `includes/class-static-security.php`

- **Added:** Nginx configuration snippet generator (`get_nginx_config_snippet()`)
  - Dynamically generates Nginx config based on active features
  - Includes login URL rewriting, path protection, firewall bootstrap, and log protection
  - Files: `includes/class-static-security.php`

- **Added:** New admin view for server configuration
  - Auto-detects server type and shows appropriate instructions
  - Copy-to-clipboard functionality for Nginx config
  - Step-by-step installation guide
  - Files: `views/admin-server-config.php` (NEW)

#### PHP-Only Protection Fallback
- **Improved:** Enhanced `protect_common_paths()` with universal PHP fallback
  - Always protects Vulnity logs directory (`/wp-content/uploads/vulnity-logs/`)
  - Always protects firewall data directory (`/wp-content/vulnity-firewall/`)
  - Works on all servers (Apache, Nginx, LiteSpeed, etc.)
  - Files: `includes/class-static-security.php:777-821`

### 🟡 Internationalization (i18n)

- **Added:** Translation support for admin dashboard
  - 20+ strings wrapped in `__()`, `esc_html__()` functions
  - Files: `views/admin-dashboard.php`

- **Added:** Complete i18n support for server configuration view
  - 100% translatable with proper text domain
  - Files: `views/admin-server-config.php`

### ⚡ Performance Optimizations

- **Added:** Performance limit in alert processing
  - Limited to last 200 alerts to prevent timeouts
  - Prevents memory exhaustion with large alert history
  - Files: `includes/class-mitigation-manager.php:735-738`

---

## Technical Details

### Files Modified (10)
1. `vulnity.php` - Core functions and helpers
2. `includes/alerts/class-alert-base.php` - Alert system improvements
3. `includes/class-security-monitor.php` - Safe theme detection
4. `includes/class-anti-collapse.php` - Strict comparisons
5. `includes/class-static-security.php` - Nginx support + hardening
6. `includes/class-mitigation-manager.php` - Performance limits
7. `includes/alerts/class-file-editor-alert.php` - Input sanitization
8. `includes/alerts/class-suspicious-query-alert.php` - Input sanitization
9. `views/admin-dashboard.php` - Internationalization
10. `views/admin-server-config.php` - **NEW FILE**

### New Functions & Methods
- `vulnity_get_server_var()` - Global helper for sanitized `$_SERVER` access
- `Vulnity_Static_Security::detect_server_type()` - Server detection
- `Vulnity_Static_Security::get_nginx_config_snippet()` - Nginx config generator
- `Vulnity_Static_Security::get_apache_config_info()` - Apache info
- `Vulnity_Security_Monitor::get_safe_theme_name()` - Safe theme name retrieval

### Statistics
- **Lines Modified:** ~500
- **Lines Added:** ~350
- **Bugs Fixed:** 8 critical + 7 high priority
- **Security Issues:** 15+ locations sanitized
- **New Features:** 4 (server detection, config generator, PHP fallback, new admin view)

---

## Upgrade Notes

### Breaking Changes
None. This is a backward-compatible release.

### Action Required for Nginx Users
If you're running Nginx, visit **Settings > Vulnity > Server Configuration** to get your custom configuration snippet and installation instructions.

### Recommendations
1. If using Nginx, configure server-level rules for optimal security
2. Review new server configuration page at **Settings > Vulnity > Server Configuration**
3. Test alert generation to verify lock improvements work correctly

---

## Previous Releases

### [1.1.5] - Previous version
- Initial SIEM integration features
- Basic alert system
- Login URL renaming
- Common paths protection

---

**Full Changelog:** https://github.com/vulnity/vulnity-wp-plugin/compare/1.1.5...1.1.6
