<?php
/**
 * Plugin Name: VulnDex Beacon
 * Description: Automatically sync your WordPress versions, plugins, and themes with VulnDex for continuous vulnerability insights.
 * Version: 1.0.0
 * Author: VulnDex
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * Text Domain: vulndex-beacon
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
	exit;
}



define( 'VULNDEX__PLUGIN_DIR', plugin_dir_path( __FILE__ ) );

require_once VULNDEX__PLUGIN_DIR . '/class/VulnDexBeacon.php';

add_action('vulndex-beacon_single_burst', function() {
	if (class_exists('VulnDexBeacon')) {
		VulnDexBeacon::instance()->send_report(true);
	}
});
register_activation_hook(__FILE__, ['VulnDexBeacon', 'on_activation']);
register_deactivation_hook(__FILE__, ['VulnDexBeacon', 'on_deactivation']);
register_uninstall_hook(__FILE__, ['VulnDexBeacon', 'on_uninstall']);

VulnDexBeacon::instance();
