<?php
/**
 * Plugin Name: Voxfor AI Content Summary
 * Plugin URI: https://wordpress.org/plugins/voxfor-ai-content-summary/
 * Description: Generates accurate, faithful summaries of post content using AI. Strict adherence to source material - no external knowledge, interpretation, or fabrication.
 * Version: 1.2.0
 * Author: Voxfor
 * Author URI: https://voxfor.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: voxfor-ai-content-summary
 * Requires at least: 5.8
 * Requires PHP: 8.0
 * 
 * Note: Plugin URI points to WordPress.org as plugin is not yet published.
 * Folder name matches text domain for WordPress coding standards compliance.
 */

if (!defined('ABSPATH')) {
    exit;
}

define('VOXFOR_AI_SUMMARY_VERSION', '1.2.0');
define('VOXFOR_AI_SUMMARY_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('VOXFOR_AI_SUMMARY_PLUGIN_URL', plugin_dir_url(__FILE__));

require_once VOXFOR_AI_SUMMARY_PLUGIN_DIR . 'includes/class-content-extractor.php';
require_once VOXFOR_AI_SUMMARY_PLUGIN_DIR . 'includes/class-ai-provider.php';
require_once VOXFOR_AI_SUMMARY_PLUGIN_DIR . 'includes/class-summary-generator.php';
require_once VOXFOR_AI_SUMMARY_PLUGIN_DIR . 'includes/class-database-handler.php';
require_once VOXFOR_AI_SUMMARY_PLUGIN_DIR . 'includes/class-frontend-display.php';
require_once VOXFOR_AI_SUMMARY_PLUGIN_DIR . 'admin/class-admin-settings.php';
require_once VOXFOR_AI_SUMMARY_PLUGIN_DIR . 'admin/class-meta-box.php';

class Voxfor_AI_Content_Summary {
    private static $instance = null;
    
    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        $this->init_hooks();
    }
    
    private function init_hooks() {
        register_activation_hook(__FILE__, [$this, 'activate']);
        register_deactivation_hook(__FILE__, [$this, 'deactivate']);
        
        add_action('plugins_loaded', [$this, 'init_admin_components']);
    }
    
    public function init_admin_components() {
        Voxfor_Frontend_Display::get_instance();
        
        if (is_admin()) {
            Voxfor_Admin_Settings::get_instance();
            Voxfor_Meta_Box::get_instance();
        }
    }
    
    public function activate() {
        Voxfor_Database_Handler::create_tables();
        flush_rewrite_rules();
    }
    
    public function deactivate() {
        flush_rewrite_rules();
    }
}

Voxfor_AI_Content_Summary::get_instance();
