<?php
/**
 * Uninstall script for Voxfor AI Content Summary
 * 
 * This file is executed when the plugin is deleted via WordPress admin.
 * It removes all plugin data from the database.
 *
 * @package Voxfor_AI_Content_Summary
 */

if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

global $wpdb;

// Delete plugin options
delete_option('voxfor_ai_summary_settings');
delete_option('voxfor_ai_summary_db_version');

// Delete all post meta created by the plugin
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for uninstall cleanup; no caching needed for delete operations.
$wpdb->query( "DELETE FROM {$wpdb->postmeta} WHERE meta_key = '_voxfor_display_summary'" );

// Drop custom table
$voxfor_table_name = esc_sql( $wpdb->prefix . 'voxfor_ai_summaries' );
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Required for uninstall cleanup; table name safely constructed and escaped.
$wpdb->query( "DROP TABLE IF EXISTS {$voxfor_table_name}" );

// Delete all transients created by the plugin
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for uninstall cleanup; no caching needed for delete operations.
$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s OR option_name LIKE %s OR option_name LIKE %s",
        $wpdb->esc_like('_transient_voxfor_') . '%',
        $wpdb->esc_like('_transient_timeout_voxfor_') . '%',
        $wpdb->esc_like('_transient_voxfor_rate_limit_') . '%'
    )
);

// Clear any cached data
wp_cache_flush();
