(function($) {
    'use strict';
    
    $(document).ready(function() {
        $('.voxfor-summary-button').on('click', function() {
            const button = $(this);
            const postId = button.data('post-id');
            const container = $('#voxfor-summary-container-' + postId);
            const buttonText = button.find('.voxfor-button-text');
            const spinner = button.find('.voxfor-spinner');
            
            if (container.is(':visible')) {
                container.slideUp(300);
                buttonText.text('AI Summary');
                return;
            }
            
            if (container.data('loaded')) {
                container.slideDown(300);
                buttonText.text('Hide Summary');
                return;
            }
            
            button.prop('disabled', true);
            buttonText.text(voxforSummary.strings.loading);
            spinner.show();
            
            $.ajax({
                url: voxforSummary.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'voxfor_get_summary_frontend',
                    post_id: postId,
                    nonce: voxforSummary.nonce
                },
                success: function(response) {
                    if (response.success) {
                        container.html(response.data.html);
                        container.data('loaded', true);
                        container.slideDown(300);
                        buttonText.text('Hide Summary');
                    } else {
                        alert(response.data.message || voxforSummary.strings.error);
                        buttonText.text('AI Summary');
                    }
                },
                error: function() {
                    alert(voxforSummary.strings.error);
                    buttonText.text('AI Summary');
                },
                complete: function() {
                    button.prop('disabled', false);
                    spinner.hide();
                }
            });
        });
    });
    
})(jQuery);

