(function($) {
    'use strict';
    
    $(document).ready(function() {
        const wrapper = $('.voxfor-meta-box-wrapper');
        
        if (!wrapper.length) {
            return;
        }
        
        function showLoading() {
            wrapper.find('.voxfor-no-summary, .voxfor-summary-display, .voxfor-error').hide();
            wrapper.find('.voxfor-loading').show();
        }
        
        function hideLoading() {
            wrapper.find('.voxfor-loading').hide();
        }
        
        function showError(message) {
            hideLoading();
            const errorDiv = wrapper.find('.voxfor-error');
            errorDiv.find('p').text(message);
            errorDiv.show();
        }
        
        function displaySummary(data) {
            hideLoading();
            wrapper.find('.voxfor-no-summary, .voxfor-error').hide();
            
            const postId = wrapper.find('[data-post-id]').data('post-id');
            
            const summaryHtml = `
                <div class="voxfor-summary-display">
                    <div class="voxfor-summary-meta">
                        <p style="margin: 0 0 10px 0; font-size: 12px; color: #666;">
                            <strong>${voxforAiSummary.strings.generated || 'Generated'}:</strong>
                            ${data.generated_at}
                        </p>
                        <p style="margin: 0 0 10px 0; font-size: 12px; color: #666;">
                            <strong>Provider:</strong>
                            ${data.provider}
                        </p>
                    </div>
                    
                    <div class="voxfor-summary-content" style="padding: 15px; background: #f6f7f7; border-left: 4px solid #2271b1; margin: 10px 0;">
                        <p style="margin: 0; line-height: 1.6; white-space: pre-wrap;">${escapeHtml(data.summary)}</p>
                    </div>
                    
                    <div class="voxfor-summary-actions" style="margin-top: 15px;">
                        <button type="button" class="button button-primary voxfor-regenerate-summary" data-post-id="${postId}">
                            Regenerate Summary
                        </button>
                        <button type="button" class="button voxfor-delete-summary" data-post-id="${postId}" style="margin-left: 5px;">
                            Delete Summary
                        </button>
                        ${data.original_content ? `
                        <button type="button" class="button voxfor-compare-summary" data-post-id="${postId}" style="margin-top: 10px; width: 100%;">
                            Compare with Original
                        </button>
                        ` : ''}
                    </div>
                    
                    <div class="voxfor-comparison-view" style="display: none; margin-top: 15px; padding: 15px; background: #fff; border: 1px solid #ddd;">
                        <h4 style="margin-top: 0;">Original Content</h4>
                        <div class="voxfor-original-content" style="max-height: 300px; overflow-y: auto; padding: 10px; background: #f9f9f9; font-size: 12px; line-height: 1.6;">${escapeHtml(data.original_content || '')}</div>
                        <button type="button" class="button voxfor-hide-comparison" style="margin-top: 10px;">
                            Hide
                        </button>
                    </div>
                </div>
            `;
            
            wrapper.find('.voxfor-summary-display').remove();
            wrapper.find('.voxfor-no-summary').remove();
            wrapper.find('.voxfor-loading').before(summaryHtml);
        }
        
        function escapeHtml(text) {
            const div = document.createElement('div');
            div.textContent = text;
            return div.innerHTML;
        }
        
        $(document).on('click', '.voxfor-generate-summary', function() {
            const postId = $(this).data('post-id');
            
            showLoading();
            
            $.ajax({
                url: voxforAiSummary.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'voxfor_generate_summary',
                    post_id: postId,
                    regenerate: 'false',
                    nonce: voxforAiSummary.nonce
                },
                success: function(response) {
                    if (response.success) {
                        displaySummary(response.data);
                    } else {
                        showError(response.data.message || voxforAiSummary.strings.error);
                    }
                },
                error: function() {
                    showError(voxforAiSummary.strings.error);
                }
            });
        });
        
        $(document).on('click', '.voxfor-regenerate-summary', function() {
            const postId = $(this).data('post-id');
            
            if (!confirm(voxforAiSummary.strings.confirm_regenerate)) {
                return;
            }
            
            showLoading();
            
            $.ajax({
                url: voxforAiSummary.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'voxfor_generate_summary',
                    post_id: postId,
                    regenerate: 'true',
                    nonce: voxforAiSummary.nonce
                },
                success: function(response) {
                    if (response.success) {
                        displaySummary(response.data);
                    } else {
                        showError(response.data.message || voxforAiSummary.strings.error);
                    }
                },
                error: function() {
                    showError(voxforAiSummary.strings.error);
                }
            });
        });
        
        $(document).on('click', '.voxfor-delete-summary', function() {
            const postId = $(this).data('post-id');
            
            if (!confirm('Are you sure you want to delete this summary?')) {
                return;
            }
            
            showLoading();
            
            $.ajax({
                url: voxforAiSummary.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'voxfor_delete_summary',
                    post_id: postId,
                    nonce: voxforAiSummary.nonce
                },
                success: function(response) {
                    if (response.success) {
                        hideLoading();
                        wrapper.find('.voxfor-summary-display, .voxfor-error').remove();
                        
                        const noSummaryHtml = `
                            <div class="voxfor-no-summary">
                                <p>No summary generated yet.</p>
                                <p style="font-size: 12px; color: #666; line-height: 1.6;">
                                    The AI will create an accurate, faithful summary based solely on the actual content of this post.
                                </p>
                                <button type="button" class="button button-primary voxfor-generate-summary" data-post-id="${postId}">
                                    Generate Summary
                                </button>
                            </div>
                        `;
                        
                        wrapper.find('.voxfor-loading').before(noSummaryHtml);
                    } else {
                        showError(response.data.message || 'Failed to delete summary.');
                    }
                },
                error: function() {
                    showError('Failed to delete summary.');
                }
            });
        });
        
        $(document).on('click', '.voxfor-compare-summary', function() {
            wrapper.find('.voxfor-comparison-view').slideDown();
        });
        
        $(document).on('click', '.voxfor-hide-comparison', function() {
            wrapper.find('.voxfor-comparison-view').slideUp();
        });
    });
    
})(jQuery);

