# Voxfor AI Content Summary

A WordPress plugin that generates accurate, faithful summaries of post content using AI. Built with strict adherence to source material - no external knowledge, interpretation, or fabrication.

## Features

- **Accuracy-First Approach**: Every summary is 100% based on actual content
- **Dual AI Provider Support**: Choose between Claude Haiku 4.5 or ChatGPT 5.2
- **Intelligent Content Extraction**: Clean extraction of text, headings, lists, and quotes
- **Database Storage**: Summaries are saved for comparison and verification
- **Smart Caching**: Automatic detection of content changes
- **User-Friendly Interface**: Simple meta box in post editor

## What Gets Summarized

✓ Post title  
✓ Text paragraphs  
✓ Headings (H2, H3, etc.)  
✓ Lists (bullets and numbered)  
✓ Quotes in the text  
✓ Facts, dates, names (if present)  

## What Is Excluded

✗ HTML/CSS/JavaScript  
✗ Buttons and forms  
✗ Dynamic content  
✗ External knowledge or interpretation  

## Installation

1. Upload the `voxfor-ai-content-summary` folder to `/wp-content/plugins/`
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to Settings > AI Content Summary
4. Configure your API keys (Claude or ChatGPT)
5. Edit any post and use the "AI Content Summary" meta box

## Requirements

- WordPress 5.8 or higher
- PHP 8.0 or higher
- Claude API key OR OpenAI API key

## API Keys

### Claude (Haiku 4.5)
Get your API key from: https://console.anthropic.com/  
Key format: `sk-ant-...`

### ChatGPT (GPT 5.2)
Get your API key from: https://platform.openai.com/  
Key format: `sk-...`

## Supreme Rule

The AI only summarizes information that actually appears in the text. Every word in the summary must be verifiable from the original content.

No:
- Drawing conclusions
- Generalizations
- Interpretation
- External knowledge
- "Marketing" wording
- Filling gaps

## Support

For support and documentation, visit: https://voxfor.com

## License

GPL v2 or later
