<?php
/**
 * Plugin Name: Voomo Blog to Video
 * Plugin URI:  https://voomo.ai
 * Description: Converts WordPress blog posts into shareable videos powered by Voomo.ai.
 * Version:     0.1.2
 * Author:      Voomo.ai
 * License:     GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: voomo-blog-to-video
 * Domain Path: /languages
 *
 * @package WP_Blog_To_Video
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'WPBTV_VERSION', '0.1.2' );
define( 'WPBTV_PLUGIN_FILE', __FILE__ );
define( 'WPBTV_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'WPBTV_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'WPBTV_API_BASE', 'https://dashboard-api.voomo.ai' );
define( 'WPBTV_APP_BASE', 'https://app.voomo.ai' );

require_once WPBTV_PLUGIN_DIR . 'includes/class-wpbtv-plugin.php';

/**
 * Plugin activation callback.
 *
 * @return void
 */
function wpbtv_activate() {
	if ( ! current_user_can( 'activate_plugins' ) ) {
		return;
	}
}

/**
 * Plugin deactivation callback.
 *
 * @return void
 */
function wpbtv_deactivate() {
	if ( ! current_user_can( 'activate_plugins' ) ) {
		return;
	}
}

/**
 * Plugin uninstall callback.
 *
 * @return void
 */
function wpbtv_uninstall() {
	if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
		return;
	}

	wpbtv_delete_saved_credentials();
}

/**
 * Delete stored credential options.
 *
 * @return void
 */
function wpbtv_delete_saved_credentials() {
	delete_option( 'wpbtv_organization_id' );
	delete_option( 'wpbtv_api_key' );
	delete_option( 'wpbtv_auto_embed' );
}

register_activation_hook( WPBTV_PLUGIN_FILE, 'wpbtv_activate' );
register_deactivation_hook( WPBTV_PLUGIN_FILE, 'wpbtv_deactivate' );
register_uninstall_hook( WPBTV_PLUGIN_FILE, 'wpbtv_uninstall' );

add_action(
	'plugins_loaded',
	static function () {
		WPBTV_Plugin::get_instance();
	}
);


