<?php
/**
 * Main plugin orchestrator class.
 *
 * @package WP_Blog_To_Video
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Bootstraps the plugin components.
 */
class WPBTV_Plugin {

	/**
	 * Singleton instance.
	 *
	 * @var WPBTV_Plugin|null
	 */
	private static $instance = null;

	/**
	 * Admin handler.
	 *
	 * @var WPBTV_Admin
	 */
	private $admin;

	/**
	 * Video manager handler.
	 *
	 * @var WPBTV_Video_Manager
	 */
	private $video_manager;

	/**
	 * REST controller handler.
	 *
	 * @var WPBTV_REST_Controller
	 */
	private $rest_controller;

	/**
	 * Get singleton instance.
	 *
	 * @return WPBTV_Plugin
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * WPBTV_Plugin constructor.
	 */
	private function __construct() {
		$this->load_dependencies();

		$this->admin          = new WPBTV_Admin();
		$this->video_manager  = new WPBTV_Video_Manager();
		$this->rest_controller = new WPBTV_REST_Controller( $this->video_manager );
	}

	/**
	 * Load plugin dependencies.
	 *
	 * @return void
	 */
	private function load_dependencies() {
		require_once WPBTV_PLUGIN_DIR . 'includes/class-wpbtv-admin.php';
		require_once WPBTV_PLUGIN_DIR . 'includes/class-wpbtv-video-manager.php';
		require_once WPBTV_PLUGIN_DIR . 'includes/class-wpbtv-rest-controller.php';
	}

}

