<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://example.com
 * @since             1.0.0
 * @package           Voodux_Bookings
 *
 * @wordpress-plugin
 * Plugin Name:       Voodux Bookings
 * Description:       Allow customers to make bookings, appointments, etc., on their own.
 * Version:           1.0.0
 * Author:            Voodux
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       voodux-bookings
 * Domain Path:       /languages
 * Requires Plugins:  woocommerce
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'VOODUX_BOOKINGSVERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-voodux-bookings-activator.php
 */
function vdx_bks_activate_voodux_bookings() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-voodux-bookings-activator.php';
	vdx_bks_activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-voodux-bookings-deactivator.php
 */
function vdx_bks_deactivate_voodux_bookings() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-voodux-bookings-deactivator.php';
	vdx_bks_deactivator::deactivate();
}

register_activation_hook( __FILE__, 'vdx_bks_activate_voodux_bookings' );
register_deactivation_hook( __FILE__, 'vdx_bks_deactivate_voodux_bookings' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-voodux-bookings.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function vdx_bks_run_voodux_bookings() {

	$plugin = new Voodux_Bookings();
	$plugin->vdx_bks_run();

}
vdx_bks_run_voodux_bookings();
