<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       http://example.com
 * @since      1.0.0
 *
 * @package    Voodux_Bookings
 * @subpackage Voodux_Bookings/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Voodux_Bookings
 * @subpackage Voodux_Bookings/public
 * @author     Your Name <email@example.com>
 */

defined( 'ABSPATH' ) || exit(); // Exit if accessed directly.

if ( ! class_exists( 'vdx_bks_voodux_bookings_public' ) ) {

	class vdx_bks_voodux_bookings_public {

		/**
		 * The ID of this plugin.
		 *
		 * @since    1.0.0
		 * @access   private
		 * @var      string    $voodux_bookings    The ID of this plugin.
		 */
		private $voodux_bookings;

		/**
		 * The version of this plugin.
		 *
		 * @since    1.0.0
		 * @access   private
		 * @var      string    $version    The current version of this plugin.
		 */
		private $version;

		/**
		 * Initialize the class and set its properties.
		 *
		 * @since    1.0.0
		 * @param      string    $voodux_bookings       The name of the plugin.
		 * @param      string    $version    The version of this plugin.
		 */
		public function __construct( $voodux_bookings, $version ) {

			$this->voodux_bookings = $voodux_bookings;
			$this->version = $version;

		}

		/**
		 * Register the stylesheets for the public-facing side of the site.
		 *
		 * @since    1.0.0
		 */
		public function vdx_bks_enqueue_styles() {

			/**
			 * This function is provided for demonstration purposes only.
			 *
			 * An instance of this class should be passed to the vdx_bks_run() function
			 * defined in vdx_bks_voodux_bookings_loaders as all of the hooks are defined
			 * in that particular class.
			 *
			 * The vdx_bks_voodux_bookings_loaders will then create the relationship
			 * between the defined hooks and the functions defined in this
			 * class.
			 */

			wp_enqueue_style( $this->voodux_bookings, plugin_dir_url( __FILE__ ) . 'css/voodux-bookings-public.css', array(), $this->version, 'all' );

		}

		/**
		 * Register the JavaScript for the public-facing side of the site.
		 *
		 * @since    1.0.0
		 */
		public function vdx_bks_enqueue_scripts() {

			/**
			 * This function is provided for demonstration purposes only.
			 *
			 * An instance of this class should be passed to the vdx_bks_run() function
			 * defined in vdx_bks_voodux_bookings_loaders as all of the hooks are defined
			 * in that particular class.
			 *
			 * The vdx_bks_voodux_bookings_loaders will then create the relationship
			 * between the defined hooks and the functions defined in this
			 * class.
			 */

			wp_enqueue_script( $this->voodux_bookings, plugin_dir_url( __FILE__ ) . 'js/voodux-bookings-public.js', array( 'jquery' ), $this->version, false );

		}
	}

}
