<?php
    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    $form_submission_success = false;
    if ( !isset($booking_form_fields_message) || empty($booking_form_fields_message) ) $booking_form_fields_message = "";

    // Get business start and end times from the admin page.
    if ( is_product() ) {
        global $product;

        $mon_from_time = get_post_meta($product->get_id(), 'mon_from_time', true);
        $mon_untill_time = get_post_meta($product->get_id(), 'mon_untill_time', true);
        $tue_from_time = get_post_meta($product->get_id(), 'tue_from_time', true);
        $tue_untill_time = get_post_meta($product->get_id(), 'tue_untill_time', true);
        $wed_from_time = get_post_meta($product->get_id(), 'wed_from_time', true);
        $wed_untill_time = get_post_meta($product->get_id(), 'wed_untill_time', true);
        $thu_from_time = get_post_meta($product->get_id(), 'thu_from_time', true);
        $thu_untill_time = get_post_meta($product->get_id(), 'thu_untill_time', true);
        $fri_from_time = get_post_meta($product->get_id(), 'fri_from_time', true);
        $fri_untill_time = get_post_meta($product->get_id(), 'fri_untill_time', true);
        $sat_from_time = get_post_meta($product->get_id(), 'sat_from_time', true);
        $sat_untill_time = get_post_meta($product->get_id(), 'sat_untill_time', true);
        $sun_from_time = get_post_meta($product->get_id(), 'sun_from_time', true);
        $sun_untill_time = get_post_meta($product->get_id(), 'sun_untill_time', true);

        // Get the options values.
        $first_day_of_week = get_option('vdx_bks_first_day_of_week');    
    }
    
    // After the form is submitted create a WooCommerce order.    
    if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST' 
        && isset($_POST['action']) && $_POST['action'] === 'vdx_bks_create_woocommerce_order') {

        // Sanitize and validate input
        $first_name = isset($_POST['first_name']) ? sanitize_text_field(wp_unslash($_POST['first_name'])) : '';
        $last_name = isset($_POST['last_name']) ? sanitize_text_field(wp_unslash($_POST['last_name'])) : '';
        $email = isset($_POST['email']) ? sanitize_text_field(wp_unslash($_POST['email'])) : '';
        $phone = isset($_POST['phone']) ? sanitize_text_field(wp_unslash($_POST['phone'])) : '';
        $order_comments = isset($_POST['order_comments']) ? sanitize_textarea_field(wp_unslash($_POST['order_comments'])) : '';
        
        $booking_date = isset($_POST['booking_date']) ? sanitize_text_field(wp_unslash($_POST['booking_date'])) : '';
        $booking_time = isset($_POST['booking_time']) ? sanitize_text_field(wp_unslash($_POST['booking_time'])) : '';
        

        $dateTime = new DateTime($booking_date);                
        $order_price = floatval(get_post_meta(get_the_ID(), strtolower($dateTime->format('D')) . '_price', true));
        $form_submission_success = false;

        $booking_form_validator = new vdx_bks_voodux_booking_form_validator();

        // Get the product book per hour/day setting.
        global $product;
        $booking_per_hour = get_post_meta($product->get_id(), 'book_per_hour', true);
        
        // Validate the booking form field values.
        $booking_fields = [
            ['name' => 'email address', 'value' => $email],
            ['name' => 'booking date', 'value' => $booking_date]
        ];
        $results = $booking_form_validator->vdx_bks_validate_booking_fields($booking_per_hour, $booking_fields, $booking_date, $booking_time);
        $form_submission_success = $results[0];
        $booking_form_fields_message = $results[1];       

        if ($form_submission_success) {

            try {
                // Create the order
                $order = wc_create_order();
                if ( !$order ) {
                    throw new Exception('Failed to create the order.');
                }
            
                // Add product to the order
                global $product;
                $product_id = $product->get_id(); // Replace with your product ID
                $product = wc_get_product($product_id);
                if ( !$product ) {
                    throw new Exception('Invalid product ID.');
                }
                $order->add_product($product, 1);
            
                // Set billing address
                $billing_address = array(
                    'first_name' => $first_name,
                    'last_name'  => $last_name,
                    'email'      => $email,
                    'phone'      => $phone,
                );
                $order->set_address($billing_address, 'billing');
            
                // Add order comments
                if (!empty($order_comments)) {
                    $order->set_customer_note($order_comments);
                }
            
                // Update order item totals
                $items = $order->get_items();
                foreach ($items as $item_id => $item) {
                    $item->set_subtotal($order_price);
                    $item->set_total($order_price);
                    $item->save();
                }
            
                // Add booking date and time fields
                if (!empty($booking_date)) {
                    $order->update_meta_data('booking_date', $booking_date);
                }
                if (!empty($booking_time)) {
                    $order->update_meta_data('booking_time', $booking_time);
                } else {
                    $order->update_meta_data('booking_time', "");
                }
            
                // Calculate totals
                $order->calculate_totals();
            
                // Save the order
                $order->save();
            
            } catch (Exception $e) {                
                $form_submission_success = false;    
                $booking_form_fields_message = esc_html(__("Sorry, there was a problem creating your order. Please try again later.", "voodux-bookings"));
            }            
            
        }        
    }

?>

<div id="voodux-booking-calendar">
    <h2><?php echo esc_html( __("Booking Calendar", "voodux-bookings") ); ?></h2>
    <div class="calendar">
        <header>
            <button id="prevMonth">&#9664;</button>
            <h2 id="monthYear"></h2>
            <button id="nextMonth">&#9654;</button>
        </header>
        <div class="calendar-grid"> 
            <?php if ( $first_day_of_week == 'monday' ) { ?>
                <div class="day-name"><?php echo esc_html(__('Mon', "voodux-bookings")); ?></div>
                <div class="day-name"><?php echo esc_html(__('Tue', "voodux-bookings")); ?></div>
                <div class="day-name"><?php echo esc_html(__('Wed', "voodux-bookings")); ?></div>
                <div class="day-name"><?php echo esc_html(__('Thu', "voodux-bookings")); ?></div>
                <div class="day-name"><?php echo esc_html(__('Fri', "voodux-bookings")); ?></div>
                <div class="day-name"><?php echo esc_html(__('Sat', "voodux-bookings")); ?></div>
                <div class="day-name"><?php echo esc_html(__('Sun', "voodux-bookings")); ?></div>
            <?php } else { ?>
                <div class="day-name"><?php echo esc_html(__('Sun', "voodux-bookings")); ?></div>
                <div class="day-name"><?php echo esc_html(__('Mon', "voodux-bookings")); ?></div>
                <div class="day-name"><?php echo esc_html(__('Tue', "voodux-bookings")); ?></div>
                <div class="day-name"><?php echo esc_html(__('Wed', "voodux-bookings")); ?></div>
                <div class="day-name"><?php echo esc_html(__('Thu', "voodux-bookings")); ?></div>
                <div class="day-name"><?php echo esc_html(__('Fri', "voodux-bookings")); ?></div>
                <div class="day-name"><?php echo esc_html(__('Sat', "voodux-bookings")); ?></div>
            <?php } ?>
        </div>
        <div id="calendarDays" class="calendar-days"></div>
    </div>
    <div class="form-field form-field-wide book-per-hour">
        <h3><?php echo esc_html(__("Booking Times", "voodux-bookings")); ?></h3>
        <span class="select-date"><?php echo esc_html(__("Select a date", "voodux-bookings")); ?></span>
        <ul class="time-picker">

        <?php
            // Generate booking time HTML blocks.
            function vdx_bks_generate_time_blocks($from_time, $until_time, $day_class) {

                // Get the time format option from the database
                $time_format = get_option('vdx_bks_time_format');
            
                // Set the calendar time options format.
                for ($x = $from_time; $x <= $until_time; $x++) {
                    
                    if ($time_format === '12') {
                        // Convert to 12-hour format with AM/PM
                        $formatted_time = gmdate('g:i A', strtotime(str_pad($x, 2, '0', STR_PAD_LEFT) . ':00'));
                    } else {
                        // Default to 24-hour format
                        $formatted_time = str_pad($x, 2, '0', STR_PAD_LEFT) . ':00';
                    }
                    
                    // Format the data value in 24-hour format, as ISO 8601 requires
                    $data_value = '2024-08-01T' . str_pad($x, 2, '0', STR_PAD_LEFT) . ':00:00+0000';
                    ?>
                    <li class="time-block <?php echo esc_html($day_class); ?>" style="display:none;" data-block="<?php esc_html($formatted_time); ?>">
                        <a href="#" data-value="<?php echo esc_html($data_value); ?>" data-local-time="<?php echo esc_html($formatted_time); ?>">
                            <?php echo esc_html($formatted_time); ?>
                        </a>
                    </li>
                    <?php
                }

            }            

            vdx_bks_generate_time_blocks($mon_from_time, $mon_untill_time, 'mon');
            vdx_bks_generate_time_blocks($tue_from_time, $tue_untill_time, 'tue');
            vdx_bks_generate_time_blocks($wed_from_time, $wed_untill_time, 'wed');
            vdx_bks_generate_time_blocks($thu_from_time, $thu_untill_time, 'thu');
            vdx_bks_generate_time_blocks($fri_from_time, $fri_untill_time, 'fri');
            vdx_bks_generate_time_blocks($sat_from_time, $sat_untill_time, 'sat');
            vdx_bks_generate_time_blocks($sun_from_time, $sun_untill_time, 'sun');
        ?>

        </ul>
        <input type="hidden" class="required_for_calculation" name="wc_bookings_field_start_date_time"
            id="wc_bookings_field_start_date" value="">
    </div>
    <div class="btn-container wrapper-test">
        <div id="errorMessage" class="error-message"></div>
        <div id="bookingFormFieldsMessage" class="booking-form-fields-message"><?php echo isset($booking_form_fields_message) ? esc_html($booking_form_fields_message) : ''; ?></div>
        <?php if (isset($form_submission_success) && $form_submission_success): ?>
            <span class="booking-confirmation"><?php echo esc_html(__("Thank you! Your booking has been successfully confirmed.", "voodux-bookings")); ?></span>
        <?php endif; ?>

        <div class="total-price-container">
            <span class="total-price-label"><?php echo esc_html(__("Total Price", "voodux-bookings")); ?>:</span>
            <span class="total-price-currency"><?php echo esc_html(get_woocommerce_currency_symbol()); ?>&nbsp;</span>
            <span class="total-price-amount">00,00</span>
        </div>

        <div class="btn-now-wrapper"><a href="#" class="btn-book-now"><?php echo esc_html(__("Book Now", "voodux-bookings")); ?></a></div>
    </div>
</div>

<div id="bookingPopup" class="popup">
    <div class="popup-content">
        <span class="close">&times;</span>
        <h2><?php echo esc_html(__("Booking Details", "voodux-bookings")); ?></h2>
        <p id="bookingDetails"></p>

        <form method="POST" class="booking-form" onsubmit="disableSubmitButton()">
            <input type="hidden" name="action" value="vdx_bks_create_woocommerce_order">
            <input type="hidden" id="bookingDate" name="booking_date">
            <input type="hidden" id="bookingTime" name="booking_time">
            
            <label for="first_name"><?php echo esc_html(__('First Name', "voodux-bookings")); ?>:</label>
            <input type="text" id="first_name" name="first_name" autocomplete="given-name">
            
            <label for="last_name"><?php echo esc_html(__('Last Name', "voodux-bookings")); ?>:</label>
            <input type="text" id="last_name" name="last_name" required autocomplete="family-name">
            
            <label for="email"><?php echo esc_html(__('Email', "voodux-bookings")); ?>:</label>
            <input type="email" id="email" name="email" required autocomplete="email">
            
            <label for="phone"><?php echo esc_html(__('Phone', "voodux-bookings")); ?>:</label>
            <input type="tel" id="phone" name="phone" autocomplete="tel">
            
            <label for="order_comments"><?php echo esc_html(__('Comments', "voodux-bookings")); ?>:</label>
            <textarea id="order_comments" name="order_comments"></textarea>
            
            <input type="submit" value="<?php echo esc_html(__('Submit', "voodux-bookings")); ?>" id="submitButton">
        </form>

    </div>
</div>
