const { registerBlockType } = wp.blocks;
const { createElement, useEffect, useState } = wp.element;

// Register the block
registerBlockType('voodux-bookings/booking-calendar-block', {
    title: 'Voodux Booking Calendar Block',
    icon: 'calendar',
    category: 'common',
    attributes: {
        // Define your block attributes here
    },
    example: {
        attributes: {
            preview: true
        }
    },
    edit: function() {
        const [content, setContent] = useState('Loading...');
        const [error, setError] = useState(null);

        useEffect(() => {
            if (calendarBlockContent && calendarBlockContent.calendar_block_file_url) {
                fetch(calendarBlockContent.calendar_block_file_url)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Network response was not ok.');
                        }
                        return response.text();
                    })
                    .then(text => setContent(text))
                    .catch(err => {
                        console.error('Fetch error:', err);
                        setError('Failed to load content');
                    });
            } else {
                console.error('No PHP file URL provided.');
                setError('PHP file URL is not defined.');
            }
        }, []);

        return createElement('div', null, error || createElement('div', { dangerouslySetInnerHTML: { __html: content } }));
    },
    save: function() {
        // The save function is not needed for dynamically rendered blocks
        return null;
    },
});