<?php

/**
* Creates custom Woocommerce product type "booking_product".
*
* Extends the WC_Product class, adding specific functionality 
* for a custom product type called "booking_product".
*
* @link       http://example.com
* @since      1.0.0
*
* @package    Voodux_Bookings
* @subpackage Voodux_Bookings/includes
*/

/**
* Creates custom Woocommerce product type "booking_product".
*
* Extends the WC_Product class, adding specific functionality 
* for a custom product type called "booking_product".
*
* @since      1.0.0
* @package    Voodux_Bookings
* @subpackage Voodux_Bookings/includes
* @author     Paul Visser
*/

defined( 'ABSPATH' ) || exit(); // Exit if accessed directly.

if ( ! class_exists( 'WC_Product_Booking_Product' ) ) {

    /**
     * Booking Product class.
     * 
     * Format: WC_Product_{custom_product_type_name}
     */
    class WC_Product_Booking_Product extends WC_Product {

        /**
         * Constructor of this class.
         *
         * @param object $product woocomerce product.
         */
        public function __construct( $product ) {

            $this->product_type = 'booking_product';
            $this->virtual      = 'yes';
            $this->supports[]   = 'ajax_add_to_cart';

            parent::__construct( $product );

        }

        /**
         * Return the product type.
         *
         * @return string
         */
        public function get_type() {

            return 'booking_product';

        }
    }

}
