<?php

/**
* Sets the properties of the custom Woocommerce product type "booking_product".
*
* Eextends WooCommerce functionality to set the properties of the custom 
* Woocommerce product type "booking_product".
*
* @link       http://example.com
* @since      1.0.0
*
* @package    Voodux_Bookings
* @subpackage Voodux_Bookings/includes
*/

/**
* Sets the properties of the custom Woocommerce product type "booking_product".
*
* Eextends WooCommerce functionality to set the properties of the custom 
* Woocommerce product type "booking_product".
*
* @since      1.0.0
* @package    Voodux_Bookings
* @subpackage Voodux_Bookings/includes
* @author     Paul Visser
*/

defined( 'ABSPATH' ) || exit(); // Exit if accessed directly.

if ( ! class_exists( 'vdx_bks_wc_product_booking_product_properties' ) ) {

    /**
     * Booking Product Properties class.
     */
    class vdx_bks_wc_product_booking_product_properties {

        /**
         * Constructor.
         */
        public function __construct() {
            
            add_action( 'woocommerce_loaded', array( $this, 'vdx_bks_load_custom_booking_product' ) );
            add_filter( 'product_type_selector', array( $this, 'vdx_bks_add_booking_product_type' ) );
            add_filter( 'woocommerce_product_data_tabs', array( $this, 'vdx_bks_alter_booking_product_tab_properties' ) );
            add_action( 'woocommerce_product_data_panels', array( $this, 'vdx_bks_add_booking_product_tab_fields' ) );
            add_action( 'save_post', array( $this, 'vdx_bks_save_booking_product_fields' ) );
            
        }

        /**
         * Load Booking Product when WooCommerce is finished loading.
         */
        public function vdx_bks_load_custom_booking_product() {

            require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-wc-product-booking-product.php';

        }

        /**
         * Edit the product types displayed on the product edit page.
         *
         * @param array $types all product types.
         *
         * @return $types
         */
        public function vdx_bks_add_booking_product_type( $types ) {

            $types['booking_product'] = esc_html__( 'Booking Product', 'voodux-bookings' );

            return $types;
            
        }

        /**
         * Modify product data tabs.
         *
         * @param array $tabs List of product data tabs.
         *
         * @return array $tabs Product data tabs.
         */
        public function vdx_bks_alter_booking_product_tab_properties( $tabs ) {

            // Only display the General product type tabs hide the others.
            foreach ( $tabs as $key => $val ) {
                $product_tabs = array( '' );

                if ( ! in_array( $key, $product_tabs ) ) {
                    $tabs[ $key ]['class'][] = 'hide_if_booking_product';
                } else {
                    $tabs['inventory']['class'][] = 'show_if_booking_product';
                }
            }

            // Add the custom "Booking Settings" tab.
            $custom_tab = array(

                'voodux_bookings_prices' => array(
                    'label'    => __( 'Prices', "voodux-bookings" ),
                    'target'   => 'booking_prices_product_data',
                    'class'    => array( 'show_if_booking_product' ),
                    'priority' => 21,
                ),                

                'voodux_bookings_availability' => array(
                    'label'    => __( 'Availability', "voodux-bookings" ),
                    'target'   => 'booking_availability_product_data',
                    'class'    => array( 'show_if_booking_product' ),
                    'priority' => 22,
                ),
            );

            return array_merge( $tabs, $custom_tab );

        }

        /**
         * Adds field(s) to the "Booking Product" custom tab "Booking settings".
         */
        public function vdx_bks_add_booking_product_tab_fields() {

            global $product_object;

            ?>

            <div id="voodux-bookings-admin-settings">                

                <div id="booking_prices_product_data" class="panel woocommerce_options_panel">
                    <div class="options_group">
                        <h4>Prices</h4>
                        <?php
                            include plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/voodux-bookings-prices-display.php'; 
                        ?>
                    </div>
                </div>


                <div id="booking_availability_product_data" class="panel woocommerce_options_panel">
                    <div class="options_group">
                        <h4>Availability</h4>
                        <?php
                            include plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/voodux-bookings-availability-display.php'; 
                        ?>
                    </div>
                </div>

            </div>

            <?php
            
        }

        /**
         * Save custom "Booking Product" (custom) fields.
         *
         * @param int $post_id The Post ID.
         */
        public function vdx_bks_save_booking_product_fields( $post_id ) {

            if ( ! empty( $_POST['meta-box-order-nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['meta-box-order-nonce'] ) ), 'meta-box-order' ) ) {                

                if ( ! empty( $_POST['post_type'] ) && 'product' === $_POST['post_type'] && ! empty( $_POST['product-type'] ) 
                        && 'booking_product' === $_POST['product-type'] ) {                                                            
                    
                    // Save the Prices tab fields.
                    update_post_meta( $post_id, 'mon_price', ! $this->vdx_bks_is_empty_or_null( $_POST['mon_price'] ) ? str_replace(',', '.', $_POST['mon_price']) : '' );
                    update_post_meta( $post_id, 'tue_price', ! $this->vdx_bks_is_empty_or_null( $_POST['tue_price'] ) ? str_replace(',', '.', $_POST['tue_price']) : '' );
                    update_post_meta( $post_id, 'wed_price', ! $this->vdx_bks_is_empty_or_null( $_POST['wed_price'] ) ? str_replace(',', '.', $_POST['wed_price']) : '' );
                    update_post_meta( $post_id, 'thu_price', ! $this->vdx_bks_is_empty_or_null( $_POST['thu_price'] ) ? str_replace(',', '.', $_POST['thu_price']) : '' );
                    update_post_meta( $post_id, 'fri_price', ! $this->vdx_bks_is_empty_or_null( $_POST['fri_price'] ) ? str_replace(',', '.', $_POST['fri_price']) : '' );
                    update_post_meta( $post_id, 'sat_price', ! $this->vdx_bks_is_empty_or_null( $_POST['sat_price'] ) ? str_replace(',', '.', $_POST['sat_price']) : '' );
                    update_post_meta( $post_id, 'sun_price', ! $this->vdx_bks_is_empty_or_null( $_POST['sun_price'] ) ? str_replace(',', '.', $_POST['sun_price']) : '' );                    

                    // Save the Availability tab fields
                    update_post_meta( $post_id, 'mon_from_time', ! $this->vdx_bks_is_empty_or_null( $_POST['mon_from_time'] ) ? $_POST['mon_from_time'] : '' );                    
                    update_post_meta( $post_id, 'tue_from_time', ! $this->vdx_bks_is_empty_or_null( $_POST['tue_from_time'] ) ? $_POST['tue_from_time'] : '' );                    
                    update_post_meta( $post_id, 'wed_from_time', ! $this->vdx_bks_is_empty_or_null( $_POST['wed_from_time'] ) ? $_POST['wed_from_time'] : '' );                    
                    update_post_meta( $post_id, 'thu_from_time', ! $this->vdx_bks_is_empty_or_null( $_POST['thu_from_time'] ) ? $_POST['thu_from_time'] : '' );                    
                    update_post_meta( $post_id, 'fri_from_time', ! $this->vdx_bks_is_empty_or_null( $_POST['fri_from_time'] ) ? $_POST['fri_from_time'] : '' );                    
                    update_post_meta( $post_id, 'sat_from_time', ! $this->vdx_bks_is_empty_or_null( $_POST['sat_from_time'] ) ? $_POST['sat_from_time'] : '' );                    
                    update_post_meta( $post_id, 'sun_from_time', ! $this->vdx_bks_is_empty_or_null( $_POST['sun_from_time'] ) ? $_POST['sun_from_time'] : '' );

                    update_post_meta( $post_id, 'mon_untill_time', ! $this->vdx_bks_is_empty_or_null( $_POST['mon_untill_time'] ) ? $_POST['mon_untill_time'] : '' );
                    update_post_meta( $post_id, 'tue_untill_time', ! $this->vdx_bks_is_empty_or_null( $_POST['tue_untill_time'] ) ? $_POST['tue_untill_time'] : '' );
                    update_post_meta( $post_id, 'wed_untill_time', ! $this->vdx_bks_is_empty_or_null( $_POST['wed_untill_time'] ) ? $_POST['wed_untill_time'] : '' );
                    update_post_meta( $post_id, 'thu_untill_time', ! $this->vdx_bks_is_empty_or_null( $_POST['thu_untill_time'] ) ? $_POST['thu_untill_time'] : '' );
                    update_post_meta( $post_id, 'fri_untill_time', ! $this->vdx_bks_is_empty_or_null( $_POST['fri_untill_time'] ) ? $_POST['fri_untill_time'] : '' );
                    update_post_meta( $post_id, 'sat_untill_time', ! $this->vdx_bks_is_empty_or_null( $_POST['sat_untill_time'] ) ? $_POST['sat_untill_time'] : '' );
                    update_post_meta( $post_id, 'sun_untill_time', ! $this->vdx_bks_is_empty_or_null( $_POST['sun_untill_time'] ) ? $_POST['sun_untill_time'] : '' );

                    // Save the not available date rages
                    update_post_meta( $post_id, 'unavailable_from_date_1', ! $this->vdx_bks_is_empty_or_null( $_POST['unavailable_from_date_1'] ) ? $_POST['unavailable_from_date_1'] : '' );
                    update_post_meta( $post_id, 'unavailable_from_date_2', ! $this->vdx_bks_is_empty_or_null( $_POST['unavailable_from_date_2'] ) ? $_POST['unavailable_from_date_2'] : '' );
                    update_post_meta( $post_id, 'unavailable_from_date_3', ! $this->vdx_bks_is_empty_or_null( $_POST['unavailable_from_date_3'] ) ? $_POST['unavailable_from_date_3'] : '' );
                    update_post_meta( $post_id, 'unavailable_from_date_4', ! $this->vdx_bks_is_empty_or_null( $_POST['unavailable_from_date_4'] ) ? $_POST['unavailable_from_date_4'] : '' );
                    update_post_meta( $post_id, 'unavailable_from_date_5', ! $this->vdx_bks_is_empty_or_null( $_POST['unavailable_from_date_5'] ) ? $_POST['unavailable_from_date_5'] : '' ); 
                    
                    update_post_meta( $post_id, 'unavailable_untill_date_1', ! $this->vdx_bks_is_empty_or_null( $_POST['unavailable_untill_date_1'] ) ? $_POST['unavailable_untill_date_1'] : '' );
                    update_post_meta( $post_id, 'unavailable_untill_date_2', ! $this->vdx_bks_is_empty_or_null( $_POST['unavailable_untill_date_2'] ) ? $_POST['unavailable_untill_date_2'] : '' );
                    update_post_meta( $post_id, 'unavailable_untill_date_3', ! $this->vdx_bks_is_empty_or_null( $_POST['unavailable_untill_date_3'] ) ? $_POST['unavailable_untill_date_3'] : '' );
                    update_post_meta( $post_id, 'unavailable_untill_date_4', ! $this->vdx_bks_is_empty_or_null( $_POST['unavailable_untill_date_4'] ) ? $_POST['unavailable_untill_date_4'] : '' );
                    update_post_meta( $post_id, 'unavailable_untill_date_5', ! $this->vdx_bks_is_empty_or_null( $_POST['unavailable_untill_date_5'] ) ? $_POST['unavailable_untill_date_5'] : '' ); 

                    // Save booking per hout or for the whole day checkbox value.
                    update_post_meta( $post_id, 'book_per_hour', ! $this->vdx_bks_is_empty_or_null( $_POST['book_per_hour'] ) ? $_POST['book_per_hour'] : '' );
                }
            }

        }

        /**
         * Custom function to determine if a variable is considered empty.
         * 
         * This function returns true if the variable is either null or an empty string ("").
         * It treats the string "0" as non-empty, unlike the built-in empty() function in PHP.
         * 
         * @param mixed $var The variable to check.
         * 
         * @return bool Returns true if the variable is null or an empty string, otherwise false.
         */
        function vdx_bks_is_empty_or_null($var) {

            // Check if the variable is null or an empty string
            return $var === null || $var === "";

        }
    }
    
}

new vdx_bks_wc_product_booking_product_properties();
