<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       http://example.com
 * @since      1.0.0
 *
 * @package    Voodux_Bookings
 * @subpackage Voodux_Bookings/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Voodux_Bookings
 * @subpackage Voodux_Bookings/includes
 * @author     Your Name <email@example.com>
 */

defined( 'ABSPATH' ) || exit(); // Exit if accessed directly.

if ( ! class_exists( 'Voodux_Bookings' ) ) {

	class Voodux_Bookings {

		/**
		 * The loader that's responsible for maintaining and registering all hooks that power
		 * the plugin.
		 *
		 * @since    1.0.0
		 * @access   protected
		 * @var      vdx_bks_voodux_bookings_loaders    $loader    Maintains and registers all hooks for the plugin.
		 */
		protected $loader;

		/**
		 * The unique identifier of this plugin.
		 *
		 * @since    1.0.0
		 * @access   protected
		 * @var      string    $voodux_bookings    The string used to uniquely identify this plugin.
		 */
		protected $voodux_bookings;

		/**
		 * The current version of the plugin.
		 *
		 * @since    1.0.0
		 * @access   protected
		 * @var      string    $version    The current version of the plugin.
		 */
		protected $version;

		/**
		 * Define the core functionality of the plugin.
		 *
		 * Set the plugin name and the plugin version that can be used throughout the plugin.
		 * Load the dependencies, define the locale, and set the hooks for the admin area and
		 * the public-facing side of the site.
		 *
		 * @since    1.0.0
		 */
		public function __construct() {
			if ( defined( 'VOODUX_BOOKINGSVERSION' ) ) {
				$this->version = VOODUX_BOOKINGSVERSION;
			} else {
				$this->version = '1.0.0';
			}
			$this->voodux_bookings = 'voodux-bookings';

			$this->vdx_bks_load_dependencies();
			$this->vdx_bks_set_locale();
			$this->vdx_bks_define_admin_hooks();
			$this->vdx_bks_define_public_hooks();

		}

		/**
		 * Load the required dependencies for this plugin.
		 *
		 * Include the following files that make up the plugin:
		 *
		 * - vdx_bks_voodux_bookings_loaders. Orchestrates the hooks of the plugin.
		 * - vdx_bks_i18n. Defines internationalization functionality.
		 * - Voodux_Bookings_Admin. Defines all hooks for the admin area.
		 * - vdx_bks_voodux_bookings_public. Defines all hooks for the public side of the site.
		 * - Voodux_Bookings_Product. Creates a WooCommerce custom product type and product.
		 *
		 * Create an instance of the loader which will be used to register the hooks
		 * with WordPress.
		 *
		 * @since    1.0.0
		 * @access   private
		 */
		private function vdx_bks_load_dependencies() {

			/**
			 * The class responsible for orchestrating the actions and filters of the
			 * core plugin.
			 */
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-voodux-bookings-loader.php';

			/**
			 * The class responsible for defining internationalization functionality
			 * of the plugin.
			 */
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-voodux-bookings-i18n.php';

			/**
			 * The class responsible for defining all actions that occur in the admin area.
			 */
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-voodux-bookings-admin.php';

			/**
			 * The class responsible for defining all actions that occur in the public-facing
			 * side of the site.
			 */
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-voodux-bookings-public.php';

			/**
			 * The class responsible for creating a WooCommerce custom product type. 
			 * of that type.
			 */
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-wc-product-booking-product-properties.php';

			/**
			 * The class responsible for creating a custom Wordpress block that displays.
			 * the booking calender.
			 */
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-voodux-booking-calendar-block.php';

			/**
			 * The class responsible for validating the booking form fields.
			 * the booking calender.
			 */
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-voodux-booking-form-validator.php';

			$this->loader = new vdx_bks_voodux_bookings_loaders();

		}

		/**
		 * Define the locale for this plugin for internationalization.
		 *
		 * Uses the vdx_bks_i18n class in order to set the domain and to register the hook
		 * with WordPress.
		 *
		 * @since    1.0.0
		 * @access   private
		 */
		private function vdx_bks_set_locale() {

			$plugin_i18n = new vdx_bks_i18n();

			$this->loader->vdx_bks_add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

		}

		/**
		 * Register all of the hooks related to the admin area functionality
		 * of the plugin.
		 *
		 * @since    1.0.0
		 * @access   private
		 */
		private function vdx_bks_define_admin_hooks() {

			$plugin_admin = new vdx_bks_admin( $this->vdx_bks_get_bookings(), $this->vdx_bks_get_version() );

			$this->loader->vdx_bks_add_action( 'admin_enqueue_scripts', $plugin_admin, 'vdx_bks_enqueue_styles' );
			$this->loader->vdx_bks_add_action( 'admin_enqueue_scripts', $plugin_admin, 'vdx_bks_enqueue_scripts' );
			$this->loader->vdx_bks_add_action( 'admin_menu', $plugin_admin, 'vdx_bks_add_admin_menu' );

		}

		/**
		 * Register all of the hooks related to the public-facing functionality
		 * of the plugin.
		 *
		 * @since    1.0.0
		 * @access   private
		 */
		private function vdx_bks_define_public_hooks() {

			$plugin_public = new vdx_bks_voodux_bookings_public( $this->vdx_bks_get_bookings(), $this->vdx_bks_get_version() );

			$this->loader->vdx_bks_add_action( 'wp_enqueue_scripts', $plugin_public, 'vdx_bks_enqueue_styles' );
			$this->loader->vdx_bks_add_action( 'wp_enqueue_scripts', $plugin_public, 'vdx_bks_enqueue_scripts' );

		}

		/**
		 * Run the loader to execute all of the hooks with WordPress.
		 *
		 * @since    1.0.0
		 */
		public function vdx_bks_run() {
			$this->loader->vdx_bks_run();
		}

		/**
		 * The name of the plugin used to uniquely identify it within the context of
		 * WordPress and to define internationalization functionality.
		 *
		 * @since     1.0.0
		 * @return    string    The name of the plugin.
		 */
		public function vdx_bks_get_bookings() {
			return $this->voodux_bookings;
		}

		/**
		 * The reference to the class that orchestrates the hooks with the plugin.
		 *
		 * @since     1.0.0
		 * @return    vdx_bks_voodux_bookings_loaders    Orchestrates the hooks of the plugin.
		 */
		public function get_loader() {
			return $this->loader;
		}

		/**
		 * Retrieve the version number of the plugin.
		 *
		 * @since     1.0.0
		 * @return    string    The version number of the plugin.
		 */
		public function vdx_bks_get_version() {
			return $this->version;
		}
	}

}
