<?php
    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    $post_id = get_the_ID();
?>
<div class="vdx-bks-availability-page">
    <div class="vdx-bks-content-wrapper">
        <div class="vdx-bks-content">
            
                <div class="prices">
                    <div class="vdx-bks-content-container"> 
                    
                    <h2><?php echo esc_html(__("Booking Rates", "voodux-bookings")); ?></h2>

                    <p><?php echo esc_html(__("Set your preferred daily rates for each day of the week. This allows you to tailor the cost of your services based on demand, ensuring you can maximize bookings while accommodating your clients needs", "voodux-bookings")); ?></p>                      

                        <!-- Monday -->
                        <div class="day">
                            <label for="mon-price"><?php echo esc_html(__("Monday", "voodux-bookings")); ?>:</label>
                            <?php

                            woocommerce_wp_text_input(array(
                                'id' => 'mon_price',
                                'placeholder' => 'n/a',
                                'type' => 'text',
                                'desc_tip' => true,
                                'value' => get_post_meta($post_id, 'mon_price', true),
                                'custom_attributes' => array(
                                    'maxlength' => '8',
                                    'class' => 'mon-price',
                                    'oninput' => 'validateNumber(this)'
                                ),
                                'desc_tip' => false
                            ));

                            ?>
                        </div>

                        <!-- Tuesday -->
                        <div class="day">
                            <label for="tue-price"><?php echo esc_html(__("Tuesday", "voodux-bookings")); ?>:</label>
                            <?php
                            
                            woocommerce_wp_text_input(array(
                                'id' => 'tue_price',
                                'placeholder' => 'n/a',
                                'type' => 'text',
                                'desc_tip' => true,
                                'value' => get_post_meta($post_id, 'tue_price', true),
                                'custom_attributes' => array(
                                    'maxlength' => '8',
                                    'class' => 'tue-price',
                                    'oninput' => 'validateNumber(this)'
                                )
                            ));
                            ?>
                        </div>

                        <!-- Wednesday -->
                        <div class="day">
                            <label for="wed-price"><?php echo esc_html(__("Wednesday", "voodux-bookings")); ?>:</label>
                            <?php
                            
                            woocommerce_wp_text_input(array(
                                'id' => 'wed_price',
                                'placeholder' => 'n/a',
                                'type' => 'text',
                                'desc_tip' => true,
                                'value' => get_post_meta($post_id, 'wed_price', true),
                                'custom_attributes' => array(
                                    'maxlength' => '8',
                                    'class' => 'wed-price',
                                    'oninput' => 'validateNumber(this)'
                                )
                            ));

                            ?>
                        </div>

                        <!-- Thursday -->
                        <div class="day">
                            <label for="thu-price"><?php echo esc_html(__("Thursday", "voodux-bookings")); ?>:</label>
                            <?php
                            
                            woocommerce_wp_text_input(array(
                                'id' => 'thu_price',
                                'placeholder' => 'n/a',
                                'type' => 'text',
                                'desc_tip' => true,
                                'value' => get_post_meta($post_id, 'thu_price', true),
                                'custom_attributes' => array(
                                    'maxlength' => '8',
                                    'class' => 'thu-price',
                                    'oninput' => 'validateNumber(this)'
                                )
                            ));

                            ?>
                        </div>

                        <!-- Friday -->
                        <div class="day">
                            <label for="fri-price"><?php echo esc_html(__("Friday", "voodux-bookings")); ?>:</label>
                            <?php

                            woocommerce_wp_text_input(array(
                                'id' => 'fri_price',
                                'placeholder' => 'n/a',
                                'type' => 'text',
                                'desc_tip' => true,
                                'value' => get_post_meta($post_id, 'fri_price', true),
                                'custom_attributes' => array(
                                    'maxlength' => '8',
                                    'class' => 'fri-price',
                                    'oninput' => 'validateNumber(this)'
                                )
                            ));
                            
                            ?>
                        </div>

                        <!-- Saturday -->
                        <div class="day">
                            <label for="sat-price"><?php echo esc_html(__("Saturday", "voodux-bookings")); ?>:</label>
                            <?php

                            woocommerce_wp_text_input(array(
                                'id' => 'sat_price',
                                'placeholder' => 'n/a',
                                'type' => 'text',
                                'desc_tip' => true,
                                'value' => get_post_meta($post_id, 'sat_price', true),
                                'custom_attributes' => array(
                                    'maxlength' => '8',
                                    'class' => 'sat-price',
                                    'oninput' => 'validateNumber(this)'
                                )
                            ));

                            ?>
                        </div>

                        <!-- Sunday -->
                        <div class="day">
                            <label for="sun-price"><?php echo esc_html(__("Sunday", "voodux-bookings")); ?>:</label>
                            <?php
                           
                            woocommerce_wp_text_input(array(
                                'id' => 'sun_price',
                                'placeholder' => 'n/a',
                                'type' => 'text',
                                'desc_tip' => true,
                                'value' => get_post_meta($post_id, 'sun_price', true),
                                'custom_attributes' => array(
                                    'maxlength' => '8',
                                    'class' => 'sun-price',
                                    'oninput' => 'validateNumber(this)'
                                )
                            ));

                            ?>
                        </div>
                        
                    </div>
                </div>
            
        </div>
    </div>
</div>
