<?php
    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    $post_id = get_the_ID();
?>
<div class="vdx-bks-availability-page">
    <div class="vdx-bks-content-wrapper">
        <div class="vdx-bks-content">
            
                <div class="booking-per-hour-or-day">
                    <div class="vdx-bks-content-container">
                        <div id="checkbox-book-per-hour">

                            <h2><?php echo esc_html( __("Hourly or Daily Bookings", "voodux-bookings")); ?></h2>

                            <p><?php echo esc_html( __("By enabling this option, you grant customers the flexibility to book your services for specific hours rather than a full day.", "voodux-bookings")); ?></p>

                            <?php
                                woocommerce_wp_checkbox(array(
                                    'id' => 'book_per_hour',
                                    'label' => esc_html(__('Enable Bookings by the Hour', "voodux-bookings")),
                                    'description' => esc_html(__('Enable this option if you want to allow customers to book specific hours instead of the entire day.', "voodux-bookings")),
                                    'desc_tip' => true,
                                    'value' => get_post_meta($post_id, 'book_per_hour', true) ? 'yes' : 'no',
                                ));

                            ?>

                        </div>
                    </div>
                </div>

                <div class="times">
                    <div class="vdx-bks-content-container">                                                

                        <div id="booking-hours">
                            
                            <h2><?php echo esc_html( __("Hourly Booking Times", "voodux-bookings")); ?></h2>
                            
                            <p><?php echo esc_html( __("In this section, you can specify the time ranges during which customers are allowed to select an available hour for their booking. 
                                For example, you can set the available booking times from 9:00 until 17:00.", "voodux-bookings")); ?></p>
                            
                            <?php
                                $time_options = array(                                    
                                    '1' => '01:00',
                                    '2' => '02:00',
                                    '3' => '03:00',
                                    '4' => '04:00',
                                    '5' => '05:00',
                                    '6' => '06:00',
                                    '7' => '07:00',
                                    '8' => '08:00',
                                    '9' => '09:00',
                                    '10' => '10:00',
                                    '11' => '11:00',
                                    '12' => '12:00',
                                    '13' => '13:00',
                                    '14' => '14:00',
                                    '15' => '15:00',
                                    '16' => '16:00',
                                    '17' => '17:00',
                                    '18' => '18:00',
                                    '19' => '19:00',
                                    '20' => '20:00',
                                    '21' => '21:00',
                                    '22' => '22:00',
                                    '23' => '23:00'
                                );                                
                            ?>

                            <!-- Monday -->
                            <div class="day">
                                <label for="mon-from-time"><?php echo esc_html( __("Monday", "voodux-bookings")); ?>:</label>
                                <?php
                                    woocommerce_wp_select( array(
                                        'id' => 'mon_from_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'mon_from_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'mon-from-time')
                                    ));
                                    
                                    woocommerce_wp_select( array(
                                        'id' => 'mon_untill_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'mon_untill_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'mon-untill-time')
                                    ));
                                    ?>
                                </div>

                                <!-- Tuesday -->
                                <div class="day">
                                    <label for="tue-from-time"><?php echo esc_html( __("Tuesday", "voodux-bookings")); ?></label>
                                    <?php
                                    woocommerce_wp_select( array(
                                        'id' => 'tue_from_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'tue_from_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'tue-from-time')
                                    ));
                                    
                                    woocommerce_wp_select( array(
                                        'id' => 'tue_untill_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'tue_untill_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'tue-untill-time')
                                    ));
                                    ?>
                                </div>

                                <!-- Wednesday -->
                                <div class="day">
                                    <label for="wed-from-time"><?php echo esc_html( __("Wednesday", "voodux-bookings")); ?>:</label>
                                    <?php
                                    woocommerce_wp_select( array(
                                        'id' => 'wed_from_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'wed_from_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'wed-from-time')
                                    ));
                                    
                                    woocommerce_wp_select( array(
                                        'id' => 'wed_untill_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'wed_untill_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'wed-untill-time')
                                    ));
                                    ?>
                                </div>

                                <!-- Thursday -->
                                <div class="day">
                                    <label for="thu-from-time"><?php echo esc_html( __("Thursday", "voodux-bookings")); ?>:</label>
                                    <?php
                                    woocommerce_wp_select( array(
                                        'id' => 'thu_from_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'thu_from_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'thu-from-time')
                                    ));
                                    
                                    woocommerce_wp_select( array(
                                        'id' => 'thu_untill_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'thu_untill_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'thu-untill-time')
                                    ));
                                    ?>
                                </div>

                                <!-- Friday -->
                                <div class="day">
                                    <label for="fri-from-time"><?php echo esc_html( __("Friday", "voodux-bookings")); ?>:</label>
                                    <?php
                                    woocommerce_wp_select( array(
                                        'id' => 'fri_from_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'fri_from_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'fri-from-time')
                                    ));
                                    
                                    woocommerce_wp_select( array(
                                        'id' => 'fri_untill_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'fri_untill_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'fri-untill-time')
                                    ));
                                    ?>
                                </div>

                                <!-- Saturday -->
                                <div class="day">
                                    <label for="sat-from-time"><?php echo esc_html( __("Saturday", "voodux-bookings")); ?>:</label>
                                    <?php
                                    woocommerce_wp_select( array(
                                        'id' => 'sat_from_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'sat_from_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'sat-from-time')
                                    ));
                                    
                                    woocommerce_wp_select( array(
                                        'id' => 'sat_untill_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'sat_untill_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'sat-untill-time')
                                    ));
                                    ?>
                                </div>

                                <!-- Sunday -->
                                <div class="day">
                                    <label for="sun-from-time"><?php echo esc_html( __("Sunday", "voodux-bookings")); ?>:</label>
                                    <?php
                                    woocommerce_wp_select( array(
                                        'id' => 'sun_from_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'sun_from_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'sun-from-time')
                                    ));
                                    
                                    woocommerce_wp_select( array(
                                        'id' => 'sun_untill_time',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'sun_untill_time', true),
                                        'options' => $time_options,
                                        'custom_attributes' => array('class' => 'sun-untill-time')
                                    ));
                                    ?>
                            </div>

                        </div>

                    </div>
                </div>

                <div class="dates">
                    <div class="vdx-bks-content-container">
                        <h2><?php echo esc_html( __("Unavailable Booking Dates", "voodux-bookings")); ?></h2> 
                        
                        <p><?php echo esc_html( __("In this section, you can specify particular date ranges during which bookings will be blocked and unavailable for your customers.", "voodux-bookings")); ?></p>
                        
                        <!-- Date Range 1 -->
                        <div class="date">
                            <label><?php echo esc_html( __("Range", "voodux-bookings")); ?>:</label>
                            <?php
                                    woocommerce_wp_text_input(array(
                                        'id' => 'unavailable_from_date_1',                                    
                                        'type' => 'date',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'unavailable_from_date_1', true),
                                        'custom_attributes' => array(
                                            'class' => 'unavailable-time'
                                        )
                                    ));

                                    woocommerce_wp_text_input(array(
                                        'id' => 'unavailable_untill_date_1',
                                        'type' => 'date',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'unavailable_untill_date_1', true),
                                        'custom_attributes' => array(
                                            'class' => 'unavailable-time'
                                        )
                                    ));
                                ?>
                            </div>

                            <!-- Date Range 2 -->
                            <div class="date">
                            <label><?php echo esc_html( __("Range", "voodux-bookings")); ?>:</label>
                            <?php
                                    woocommerce_wp_text_input(array(
                                        'id' => 'unavailable_from_date_2',                                        
                                        'type' => 'date',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'unavailable_from_date_2', true),
                                        'custom_attributes' => array(                                            
                                            'class' => 'unavailable-time'
                                        )
                                    ));

                                    woocommerce_wp_text_input(array(
                                        'id' => 'unavailable_untill_date_2',                                        
                                        'type' => 'date',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'unavailable_untill_date_2', true),
                                        'custom_attributes' => array(                                            
                                            'class' => 'unavailable-time'
                                        )
                                    ));
                                ?>
                            </div>

                            <!-- Date Range 3 -->
                            <div class="date">
                            <label><?php echo esc_html( __("Range", "voodux-bookings")); ?>:</label>
                            <?php
                                    woocommerce_wp_text_input(array(
                                        'id' => 'unavailable_from_date_3',                                        
                                        'type' => 'date',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'unavailable_from_date_3', true),
                                        'custom_attributes' => array(                                            
                                            'class' => 'unavailable-time'
                                        )
                                    ));

                                    woocommerce_wp_text_input(array(
                                        'id' => 'unavailable_untill_date_3',                                        
                                        'type' => 'date',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'unavailable_untill_date_3', true),
                                        'custom_attributes' => array(                                            
                                            'class' => 'unavailable-time'
                                        )
                                    ));
                                ?>
                            </div>

                            <!-- Date Range 4 -->
                            <div class="date">
                            <label><?php echo esc_html( __("Range", "voodux-bookings")); ?>:</label>
                            <?php
                                    woocommerce_wp_text_input(array(
                                        'id' => 'unavailable_from_date_4',                                        
                                        'type' => 'date',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'unavailable_from_date_4', true),
                                        'custom_attributes' => array(                                            
                                            'class' => 'unavailable-time'
                                        )
                                    ));

                                    woocommerce_wp_text_input(array(
                                        'id' => 'unavailable_untill_date_4',                                        
                                        'type' => 'date',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'unavailable_untill_date_4', true),
                                        'custom_attributes' => array(                                            
                                            'class' => 'unavailable-time'
                                        )
                                    ));
                                ?>
                            </div>

                            <!-- Date Range 5 -->
                            <div class="date">
                            <label><?php echo esc_html( __("Range", "voodux-bookings")); ?>:</label>
                            <?php
                                    woocommerce_wp_text_input(array(
                                        'id' => 'unavailable_from_date_5',                                        
                                        'type' => 'date',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'unavailable_from_date_5', true),
                                        'custom_attributes' => array(                                            
                                            'class' => 'unavailable-time'
                                        )
                                    ));

                                    woocommerce_wp_text_input(array(
                                        'id' => 'unavailable_untill_date_5',                                        
                                        'type' => 'date',
                                        'desc_tip' => true,
                                        'value' => get_post_meta($post_id, 'unavailable_untill_date_5', true),
                                        'custom_attributes' => array(                                            
                                            'class' => 'unavailable-time'
                                        )
                                    ));
                                ?>
                        </div>
                        
                    </div>
                </div>

        </div>
    </div>
</div>
