<?php
    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    // Get the options values.
    $first_day_of_week = get_option('vdx_bks_first_day_of_week');
    $scroll_to_calendar = get_option('vdx_bks_scroll_to_calendar');
    $time_format = get_option('vdx_bks_time_format');
    
    // Check if the settings form is submitted and nonce is verified
    if (isset($_POST['vdx_bks_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['vdx_bks_nonce'])), 'vdx_bks_save_settings')) {
            
        // Sanitize and save the fields
        $first_day_of_week = isset($_POST['firstDayOfWeek']) ? sanitize_text_field(wp_unslash($_POST['firstDayOfWeek'])) : get_option('vdx_bks_first_day_of_week');
        $scroll_to_calendar = isset($_POST['scrollToCalendar']) ? sanitize_text_field(wp_unslash($_POST['scrollToCalendar'])) : get_option('vdx_bks_scroll_to_calendar');
        $time_format = isset($_POST['timeFormat']) ? sanitize_text_field(wp_unslash($_POST['timeFormat'])) : get_option('vdx_bks_time_format');                            

        // Save the fields to the database.
        update_option('vdx_bks_first_day_of_week', $first_day_of_week);
        update_option('vdx_bks_scroll_to_calendar', $scroll_to_calendar);
        update_option('vdx_bks_time_format', $time_format);                

        // Redirect back to the settings page.
        wp_redirect(admin_url('admin.php?page=voodux-bookings-settings&status=success'));
        exit;
    }
?>

<div class='vdx-bks-admin-page'>
    <div class='vdx-bks-header'>
        <h1>Settings</h1>
    </div>
    <div class='vdx-bks-content-wrapper'>
        <div class='vdx-bks-content'>
       
            <div class="tabs">
                <button class="tab-button" data-tab="option"><?php echo esc_html(__("Options", "voodux-bookings")); ?></button>
                <button class="tab-button" data-tab="plugin-documentation"><?php echo esc_html(__("Documentation", "voodux-bookings")); ?></button>
                <button class="tab-button higlight" data-tab="pro-version"><?php echo esc_html(__("Pro version", "voodux-bookings")); ?></button>
            </div>
            
            <form id="bookingSettingsForm" method="post" >
                <?php wp_nonce_field('vdx_bks_save_settings', 'vdx_bks_nonce'); ?>
                <input type="hidden" name="action" value="vdx_bks_save_settings">

                      
                <div class="tab-content active" id="option">
                    <h2><?php echo esc_html(__("Options", "voodux-bookings")); ?></h2>
                    
                    <div class="options-field">
                        <label for="firstDayOfWeek"><?php echo esc_html(__("First day of the week", "voodux-bookings")); ?>:</label>                    
                        <div class="radio-options">
                            <label for="monday">
                                <input type="radio" id="monday" name="firstDayOfWeek" value="monday" <?php echo !isset($first_day_of_week) || empty($first_day_of_week) || $first_day_of_week == 'monday' ? 'checked' : ''; ?>>
                                <?php echo esc_html(__("Monday", "voodux-bookings")); ?>
                            </label>
                            <label for="sunday">
                                <input type="radio" id="sunday" name="firstDayOfWeek" value="sunday" <?php echo $first_day_of_week == 'sunday' ? 'checked' : ''; ?>>
                                <?php echo esc_html(__("Sunday", "voodux-bookings")); ?>
                            </label>                        
                        </div>
                    </div>

                    <div class="options-field">
                        <label for="scrollToCalendar"><?php echo esc_html(__("Scroll to Calendar", "voodux-bookings")); ?>:</label>                    
                        <div class="radio-options">
                            <label for="yes">
                                <input type="radio" id="enable-scroll-to-calendar" name="scrollToCalendar" value="yes" <?php echo isset($scroll_to_calendar) && $scroll_to_calendar == 'yes' ? 'checked' : ''; ?>>
                                <?php echo esc_html(__("Yes", "voodux-bookings")); ?>
                            </label>
                            <label for="no">
                            <input type="radio" id="disable-scroll-to-calendar" name="scrollToCalendar" value="no" <?php echo !isset($scroll_to_calendar) || empty($scroll_to_calendar) || $scroll_to_calendar == 'no' ? 'checked' : ''; ?>>
                                <?php echo esc_html(__("No", "voodux-bookings")); ?>
                            </label>                        
                        </div>
                    </div>

                    <div class="options-field">
                        <label><?php echo esc_html(__("Booking time format", "voodux-bookings")); ?>:</label>
                        <div class="radio-options">
                            <label>
                                <input type="radio" name="timeFormat" value="24" <?php echo !isset($time_format) || empty($time_format) || $time_format == '24' ? 'checked' : ''; ?>>
                                <?php echo esc_html(__("24-hour format", "voodux-bookings")); ?>
                            </label>
                            <label>
                                <input type="radio" name="timeFormat" value="12" <?php echo $time_format == '12' ? 'checked' : ''; ?>>
                                <?php echo esc_html(__("12-hour format", "voodux-bookings")); ?>
                            </label>
                        </div>
                    </div>

                    <div class="options-image-one">
                        <img id="image-24-hour" src="images/booking-times-eur.png" alt="<?php echo esc_html(__("24-hour format", "voodux-bookings")); ?>">
                        <img id="image-12-hour" src="images/booking-times-us.png" alt="<?php echo esc_html(__("12-hour format", "voodux-bookings")); ?>">
                    </div>
                    
                    <button type="submit"><?php echo esc_html(__("Save Settings", "voodux-bookings")); ?></button>

                </div>        
                
                <div class="tab-content" id="pro-version">
                <div class="pro-version-container">
                    <h2><?php echo esc_html(__("Upgrade to the Pro Version", "voodux-bookings")); ?></h2>
                    <p>
                        <?php echo esc_html(__("Thank you for using our WordPress Booking Plugin! We are continuously working on improvements to provide you with an even better experience. 
                        We are excited to introduce the Pro Versio of our plugin, featuring powerful new tools to make managing your bookings more efficient and flexible", "voodux-bookings")); ?>.
                    </p>

                    <h3><?php echo esc_html(__("What can you expect from the Pro Version", "voodux-bookings")); ?>?</h3>
                    <ul>
                        <li><?php echo esc_html(__("Woocommerce payment integration: Fully integrated, user-friendly WooCommerce payment process that seamlessly occurs within the existing booking popups", "voodux-bookings")); ?>.</li>
                        <li><?php echo esc_html(__("Multiple booking types and prices: Define multiple booking types, each with its own pricing to accommodate different services or accommodations", "voodux-bookings")); ?>.</li>
                        <li><?php echo esc_html(__("Comprehensive styling options: The ability to customize the styling of the booking calendar with options such as color, size, layout and the ability to add custom classes", "voodux-bookings")); ?>.</li>
                        <li><?php echo esc_html(__("Extrensive booking costs: Add additional fixed booking costs such as service fees, cancellation fees, administration Fees etc", "voodux-bookings")); ?>.</li>
                        <li><?php echo esc_html(__("And more.. Mai your thoughts and feature requests to voodux.plugins@gmail.com", "voodux-bookings")); ?>.</li>
                    </ul>

                    <h3><?php echo esc_html(__("When will the Pro Version be available", "voodux-bookings")); ?>?</h3>
                    <p>
                    <?php echo esc_html(__("The Pro Version is currently in pre-development and will be available once there is enough interest. 
                        We want to make sure that the new features meet the needs of our users.", "voodux-bookings")); ?>
                    </p>

                    <div class="interest-box">
                        <p><?php echo esc_html(__("Interested in the Pro Version? Let us know what you want by mailing your thoughts and feature requests to voodux.plugins@gmail.com. 
                        We will start developing the Pro Version once there’s enough interest.", "voodux-bookings")); ?></p>
                    </div>
                </div>

                </div>

                <div class="tab-content" id="plugin-documentation">
                    <h2><?php echo esc_html(__("Documentation", "voodux-bookings")); ?></h2>
                    
                    <div class="collapsible-section">
                        <h3 class="collapsible"><?php echo esc_html(__("Requirements", "voodux-bookings")); ?></h3>
                        <div class="content">
                        <ul>
                            <li>
                            <strong><?php echo esc_html(__("A Working WordPress Website", "voodux-bookings")); ?>:</strong> 
                            <br><?php echo esc_html(__("You must have an active and functional WordPress website where the plugin will be installed", "voodux-bookings")); ?>.
                            </li>
                            <li>
                            <strong><?php echo esc_html(__("WooCommerce Installed and Activated", "voodux-bookings")); ?>:</strong>
                            <br><?php echo esc_html(__("Ensure WooCommerce is installed and activated on your WordPress site. The Voodux Booking plugin integrates with WooCommerce", "voodux-bookings")); ?>.
                            </li>
                        </ul>
                        </div>
                    </div>

                    <div class="collapsible-section">
                        <h3 class="collapsible"><?php echo esc_html(__("Plugin Installation and Integration", "voodux-bookings")); ?></h3>
                        <div class="content">

                            <h2><?php echo esc_html(__("Install the Voodux Booking plugin", "voodux-bookings")); ?></h2>

                            <ol>
                                <li>
                                    <strong><?php echo esc_html(__("Log in to WordPress Admin", "voodux-bookings")); ?>:</strong>
                                    <br><?php echo esc_html(__("Go to yourwebsite.com/wp-admin and log in with your credentials", "voodux-bookings")); ?>.
                                </li>
                                <li>
                                    <strong><?php echo esc_html(__("Navigate to Plugins", "voodux-bookings")); ?>:</strong>
                                    <br><?php echo esc_html(__("In the left-hand sidebar click Plugins -> Add New", "voodux-bookings")); ?>.
                                </li>
                                <li>
                                    <strong><?php echo esc_html(__("Search for a Plugin", "voodux-bookings")); ?>:</strong>
                                    <br><?php echo esc_html(__("Use the search bar to find the plugin you want to install", "voodux-bookings")); ?>.
                                </li>
                                <li>
                                    <strong><?php echo esc_html(__("Install the Plugin", "voodux-bookings")); ?>:</strong>
                                    <br><?php echo esc_html(__("Click Install Now next to the plugin you want", "voodux-bookings")); ?>.
                                </li>
                                <li>
                                    <strong><?php echo esc_html(__("Activate the Plugin", "voodux-bookings")); ?>:</strong>
                                    <br><?php echo esc_html(__("Once installed, click Activate to enable it", "voodux-bookings")); ?>.
                                </li>
                                <li>
                                    <strong><?php echo esc_html(__("Configure Settings (if necessary)", "voodux-bookings")); ?>:</strong>
                                    <br><?php echo esc_html(__("Go to the plugin’s settings under Settings or Plugins -> Installed Plugins", "voodux-bookings")); ?>.
                                </li>
                            </ol>
                            
                            <h2><?php echo esc_html(__("Add Booking Calendar to Woocommerce product page", "voodux-bookings")); ?></h2>

                            <ol>
                                <li>
                                    <strong><?php echo esc_html(__("Edit or Create a New Woocommere product page", "voodux-bookings")); ?>:</strong>
                                    <br><?php echo esc_html(__("In the WordPress admin area, navigate to Products, then either click Add New to create a product or select an existing product from All Products to edit", "voodux-bookings")); ?>.
                                </li>
                                <li>
                                    <strong><?php echo esc_html(__("Choose Product Data type", "voodux-bookings")); ?>:</strong>
                                    <br><?php echo esc_html(__("In the Product Data dropdown, select 'Booking Product'", "voodux-bookings")); ?>.
                                </li>                            
                                <li>
                                    <strong><?php echo esc_html(__("Save or Publish the product page", "voodux-bookings")); ?>:</strong>
                                    <br><?php echo esc_html(__("Click Save Draft or Publish to make the product page live", "voodux-bookings")); ?>.
                                </li>
                            </ol>

                        </div>
                    </div>                                    

                    <div class="collapsible-section">
                        <h3 class="collapsible"><?php echo esc_html(__("Overview of the General Booking Options", "voodux-bookings")); ?></h3>
                        <div class="content">
                        <h2><?php echo esc_html(__("General Booking Options", "voodux-bookings")); ?></h2>

                        <p><?php echo esc_html(__("Below you’ll find the options available under the Options tab, along with a description of what each option does", "voodux-bookings")); ?>.</p>

                        <ol>
                            <li>
                                <strong><?php echo esc_html(__("First day of the week", "voodux-bookings")); ?>:</strong>
                                <br><?php echo esc_html(__("Sets the starting day of the week for the calendar. This affects how the days are displayed in the calendar and which day appears first (Monday or Sunday)", "voodux-bookings")); ?>.
                            </li>
                            <li>
                                <strong><?php echo esc_html(__("Scroll to Calendar", "voodux-bookings")); ?>:</strong>
                                <br><?php echo esc_html(__("When this option is enabled, the page will automatically scroll to center the calendar on the screen when the page is loaded", "voodux-bookings")); ?>.
                            </li>
                            <li>
                                <strong><?php echo esc_html(__("Booking time format", "voodux-bookings")); ?>:</strong>
                                <br><?php echo esc_html(__("You can choose between a 24-hour format or a 12-hour format (e.g., 14:00 vs 2:00 PM)", "voodux-bookings")); ?>.
                            </li>                            
                        </ol>

                        </div>
                    </div>
                    
                    <div class="collapsible-section">
                        <h3 class="collapsible"><?php echo esc_html(__("Overview of the Product Page Booking Options", "voodux-bookings")); ?></h3>
                        <div class="content">
                            <h2><?php echo esc_html(__("Product Page Booking Options", "voodux-bookings")); ?></h2>

                        <p><?php echo esc_html(__("Below are the options available in the 'Product Data' tab on each product page. Along with a description of what each option does", "voodux-bookings")); ?>.</p>

                        <ol>
                            <li>
                                <h3><?php echo esc_html(__("Prices", "voodux-bookings")); ?>:</h3>
                                <strong><?php echo esc_html(__("Booking Rates", "voodux-bookings")); ?></strong>
                                <p><?php echo esc_html(__("Set your preferred daily rates for each day of the week. This allows you to tailor the cost of your services based on demand, ensuring you can maximize bookings while accommodating your clients needs", "voodux-bookings")); ?>.</p>
                            </li>
                            <li>
                                <h3><?php echo esc_html(__("Availability", "voodux-bookings")); ?>:</h3>
                                <strong><?php echo esc_html(__("Hourly or Daily Bookings", "voodux-bookings")); ?></strong>
                                <p><?php echo esc_html(__("By enabling this option, you grant customers the flexibility to book your services for specific hours rather than a full day", "voodux-bookings")); ?>. 
                                <?php echo esc_html(__("The 'Hourly Booking Times' option will also become available (described below)", "voodux-bookings")); ?>.</p>                                                                

                                <strong>** <?php echo esc_html(__("Hourly Booking Times", "voodux-bookings")); ?></strong>
                                <p><?php echo esc_html(__("This option is accessible once you select 'Enable Bookings by the Hour' under the 'Hourly or Daily Bookings' setting. 
                                You can then specify the time ranges during which customers can choose an available hour for their bookings. For instance, you could set the available booking times from 9:00 AM to 5:00 PM", "voodux-bookings")); ?>.</p>                                                            

                                <strong><?php echo esc_html(__("Unavailable Booking Dates", "voodux-bookings")); ?></strong>
                                <p><?php echo esc_html(__("In this section, you can specify particular date ranges during which bookings will be blocked and unavailable for your customers", "voodux-bookings")); ?>.</p>
                            </li>                            
                        </ol>
                        </div>
                    </div>


                    <div class="collapsible-section">
                        <h3 class="collapsible"><?php echo esc_html(__("Understanding the Booking Calendar", "voodux-bookings")); ?></h3>
                        <div class="content">                            
                            
                            <h3><?php echo esc_html(__("Overview Image", "voodux-bookings")); ?></h3>

                            <img src="images\start-booking-calendar-overview.png" alt="<?php echo esc_html(__("Bookings Calendar", "voodux-bookings")); ?>" style="width:50%;border: lightgrey 2px solid;">

                            <div class="documentation-overview-image">
                                <p>1. <?php echo esc_html(__("The booking calendar title", "voodux-bookings")); ?>.</p>
                                <p>2. <?php echo esc_html(__("Days on the booking calendar are color-coded: white for available days, blue for the selected day, and grey for unavailable days", "voodux-bookings")); ?>.</p>
                                <p>3. <?php echo esc_html(__("Booking times display the available slots for clients to make a reservation. The format (24-hour or AM/PM) can be adjusted in the options.", "voodux-bookings")); ?></p>
                                <p>4. <?php echo esc_html(__("The total booking price is dynamically calculated, and the daily price can be adjusted in the product page options", "voodux-bookings")); ?>.</p>
                                <p>5. <?php echo esc_html(__("Clicking 'Book Now' opens a detailed booking popup, allowing customers to review and confirm their selected options before completing their reservation", "voodux-bookings")); ?>.</p>
                            </div>

                            <br>

                            <h3><?php echo esc_html(__("Create a Booking", "voodux-bookings")); ?></h3>
                            <p><?php echo esc_html(__("Follow these steps to make a booking using the booking calendar", "voodux-bookings")); ?></p>

                            <p>1. <?php echo esc_html(__("Select an available date from the booking calendar", "voodux-bookings")); ?>.</p>
                            <p>2. <?php echo esc_html(__("Review the available time slots listed under booking times and choose one", "voodux-bookings")); ?>.</p>
                            <p>3. <?php echo esc_html(__("The total price will be shown above the 'Book Now' button", "voodux-bookings")); ?>.</p>
                            <p>4. <?php echo esc_html(__("Click the 'Book Now' button to open the Booking Details popup window", "voodux-bookings")); ?>.</p>
                            <p>5. <?php echo esc_html(__("Complete the form and click Submit", "voodux-bookings")); ?>.</p>
                            <p>6. <?php echo esc_html(__("Your booking is successfully created, the Booking Details popup window will close, and a confirmation message will appear", "voodux-bookings")); ?>.</p>

                            <br>
                            
                            <h3><?php echo esc_html(__("Booking Details Popup window", "voodux-bookings")); ?></h3>

                            <img src="images\clean_booking_details_popup.png" alt="<?php echo esc_html(__("Booking details popup window", "voodux-bookings")); ?>" style="width:40%;">

                            <div class="documentation-overview-image">
                                <p>1. <?php echo esc_html(__("Title of the booking details popup window", "voodux-bookings")); ?>.</p>
                                <p>2. <?php echo esc_html(__("Overview of the booking details which include the date, time, and price", "voodux-bookings")); ?>.</p>
                                <p>3. <?php echo esc_html(__("Booking form containing the necessary fields, which are saved in the WooCommerce order", "voodux-bookings")); ?></p>
                                <p>4. <?php echo esc_html(__("Pressing the 'Submit' button is required to confirm the booking and closes the booking details popup", "voodux-bookings")); ?>.</p>
                            </div>

                            <br>

                            <h3><?php echo esc_html(__("Confirmation Message", "voodux-bookings")); ?></h3>

                            <img src="images\booking-confirmation.png" alt="<?php echo esc_html(__("Confirmation message text", "voodux-bookings")); ?>" style="width:40%;">

                            <p style="width:80%;"><?php echo esc_html(__("The confirmation message displayed after successfully completing a booking.", "voodux-bookings")); ?></p>

                            <br>

                            <h3><?php echo esc_html(__("WooCommerce Order", "voodux-bookings")); ?></h3>
                            <p style="width:80%"><?php echo esc_html(__("When customers make bookings through the booking calendar, these reservations are processed as standard WooCommerce orders. 
                                This means that each booking is treated like any other product purchase within the WooCommerce system", "voodux-bookings")); ?>.<p>

                            <p style="width:80%"><?php echo esc_html(__("Once a booking is confirmed, it generates a corresponding order that includes all relevant details, such as the customer's 
                                information, the selected date, time, price and any additional notes. This integration allows you to manage bookings seamlessly alongside your other products and services", "voodux-bookings")); ?>.</p>
                        </div>
                    </div>

                    <div class="collapsible-section">
                        <h3 class="collapsible"><?php echo esc_html(__("Woocommerce Payments", "voodux-bookings")); ?></h3>
                        <div class="content">
                            <h2><?php echo esc_html(__("Process Woocommere Order Payments", "voodux-bookings")); ?>.</h2>

                            <p><?php echo esc_html(__("When a customer makes a booking, it is recorded as a standard order in your WooCommerce system. 
                            This integration allows you to manage bookings alongside your other products and services. 
                            Each booking order includes essential details such as the customer’s information, the selected date and time, and any additional notes, ensuring that you 
                            have all the necessary information for effective booking management", "voodux-bookings")); ?>.</p>                            

                            <p><?php echo esc_html(__("To manage payments for orders/bookings in WooCommerce, it's essential to follow the appropriate processes to ensure that transactions are handled smoothly and securely. 
                            This includes selecting payment methods, processing refunds, and managing any payment-related issues that may arise. For detailed guidance on handling payments for orders, please refer to the WooCommerce documentation on managing orders", "voodux-bookings")); ?></a>.</p>

                            <i><?php echo esc_html(__("Please note that WooCommerce Payments handling is not available in the free version of the plugin", "voodux-bookings")); ?>.</i>
                        </div>
                    </div>

                </div>
                
            </form>

        </div>
    </div>
</div>