document.addEventListener('DOMContentLoaded', function() {
    const tabButtons = document.querySelectorAll('.tab-button');
    const tabContents = document.querySelectorAll('.tab-content');
    const cssButtons = document.querySelectorAll('.css-button');

	// Settings Tabs on the admin page
    tabButtons.forEach(button => {
        button.addEventListener('click', function() {
            const targetTab = this.getAttribute('data-tab');
            
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => {
                content.classList.remove('active');
                content.style.opacity = 0; // Hide all contents initially
            });

            this.classList.add('active');
            const activeContent = document.getElementById(targetTab);
            activeContent.classList.add('active');

            // Add a small delay to ensure the display property is applied before changing opacity.
            setTimeout(() => {
                activeContent.style.opacity = 1;
            }, 50);
        });
    });

    const radioButtons = document.querySelectorAll('input[name="timeFormat"]');
    const image24Hour = document.getElementById('image-24-hour');
    const image12Hour = document.getElementById('image-12-hour');

    // Function to update the 24/12 hout image visibility.
    function updateImageVisibility() {

        if(radioButtons[0] == null) return;

        if (radioButtons[0].checked) {
            image24Hour.classList.add('active');
            image12Hour.classList.remove('active');
        } else if (radioButtons[1].checked) {
            image24Hour.classList.remove('active');
            image12Hour.classList.add('active');
        }
    }

    // Initialize visibility on page load
    updateImageVisibility();

    // Add event listeners to radio buttons
    radioButtons.forEach(radio => {
        radio.addEventListener('change', updateImageVisibility);
    });

    // Function to set active class on Tabs based on saved value.
    function setActiveButton() {
        const activeTab = localStorage.getItem('activeTab');
        tabButtons.forEach(button => {
            if (button.getAttribute('data-tab') === activeTab) {
                button.classList.add('active');
                button.click(); // Simulate a click on the active button
            } else {
                button.classList.remove('active');
            }
        });
    }

    // Set the active button on page load
    setActiveButton();

    // Se actie Tab so it stays active after page reload or page revisit.
    tabButtons.forEach(button => {
        button.addEventListener('click', function () {
            // Save the active tab's data-tab value
            localStorage.setItem('activeTab', this.getAttribute('data-tab'));

            // Update active class
            setActiveButton();
        });
    });

	// Collapse settings documentation
	const collapsibles = document.querySelectorAll('.collapsible');

	// Documentation Tab collapsable subjects.
	collapsibles.forEach(collapsible => {
		collapsible.addEventListener('click', function () {
			// Toggle active class on clicked collapsible
			this.classList.toggle('active');
				
			// Toggle visibility of content section with a smooth transition
			const content = this.nextElementSibling;
			if (content.classList.contains('open')) {
				content.classList.remove('open');
			} else {
				content.classList.add('open');
			}
		});
	});

    const bookingHoursDiv = document.getElementsByClassName('times')[0];
    const bookedWholeDayCheckbox = document.getElementById('book_per_hour');

    if(bookingHoursDiv != null && bookedWholeDayCheckbox != null) {
        // Functie om de maximale hoogte van het element in te stellen
        const setMaxHeight = () => {
            bookingHoursDiv.style.maxHeight = bookingHoursDiv.scrollHeight + 'px';
        };

        // Controleer de status van de checkbox bij het laden van de pagina
        if (bookedWholeDayCheckbox.checked) {
            bookingHoursDiv.style.display = 'block';
            setMaxHeight(); // Stel de maximale hoogte in
            bookingHoursDiv.style.opacity = '1'; // Zorg ervoor dat het volledig zichtbaar is
        }

        // Voeg event listener toe aan de checkbox
        bookedWholeDayCheckbox.addEventListener('change', function () {
            if (this.checked) {
                bookingHoursDiv.style.display = 'block'; // Zorg ervoor dat het div zichtbaar is
                setTimeout(() => {
                    setMaxHeight(); // Stel de maximale hoogte in voor het element
                    bookingHoursDiv.style.opacity = '1'; // Fade in
                }, 10); // Korte vertraging om de overgang te activeren
            } else {
                bookingHoursDiv.style.maxHeight = '0'; // Verklein de hoogte naar 0
                bookingHoursDiv.style.opacity = '0'; // Fade out
                bookingHoursDiv.addEventListener('transitionend', function handler() {
                    bookingHoursDiv.style.display = 'none'; // Verberg het na de overgang
                    bookingHoursDiv.removeEventListener('transitionend', handler);
                });
            }
        });
    }

    // Check the page-edit admin page fields after the page is been submitted.
    document.getElementById('post').addEventListener('submit', function(event) {
        // Prevent the form from being submitted
        event.preventDefault();

        // Retrieve input fields by ID
        const inputFields = [
            'mon_price',
            'tue_price',
            'wed_price',
            'thu_price',
            'fri_price',
            'sat_price',
            'sun_price'
        ].map(id => document.getElementById(id));

        // Validate all input fields and submit if all are valid
        const allValid = inputFields.every(field => validateNumber(field));

        if (allValid) {
            this.submit();
        }
        else
        {
            alert("Some fields contain invalid values.");
        }
    });

});

/**
 * Validates the input value to ensure it conforms to the correct number format.
 * Accepted formats are:
 * - Whole numbers (e.g., 100)
 * - Single-digit numbers (e.g., 1)
 * - Numbers with up to two decimal places (e.g., 1.1 or 1.50)
 *
 * If the input is empty or undefined, it is considered valid.
 * If the input matches the valid format, the border color is reset.
 * If the input is invalid, the input field's border is highlighted in red.
 * 
 * @param {HTMLInputElement} input - The input field to validate.
 * @returns {boolean} - Returns true if the input is valid, empty, or undefined, otherwise false.
 */
function validateNumber(input) {
    // Ensure input is an HTMLInputElement
    if (!(input instanceof HTMLInputElement)) {
        return true;
    }

    // Regular expression to match valid number formats (e.g., 100, 1, 1.1, or 1.50)
    const validPattern = /^(\d+)([.,]\d{1,2})?$/;

    // Get the value of the input, defaulting to an empty string if undefined
    const value = input.value;

    // If the value is undefined or empty, consider it valid
    if (value === undefined || value.trim() === '') {
        input.style.borderColor = ''; // Reset border color
        return true;
    }

    // Test if the value matches the pattern
    if (validPattern.test(value)) {        
        input.style.borderColor = ''; // Reset border color
        return true;
    } else {        
        input.style.borderColor = 'red'; // Highlight input field
        return false;
    }
}
