<?php
/**
 * Plugin Name:       VonSEO
 * Description:       A lightweight, premium SEO toolkit. Features a modern dashboard, automated JSON-LD Schema, Open Graph, Twitter Cards, and per-post SEO controls without the bloat.
 * Version:           2.1.9
 * Requires at least: 6.0
 * Tested up to:      6.9
 * Requires PHP:      7.4
 * Author:            Vondereich
 * Author URI:        https://www.facebook.com/kurama87
 * License:           GPLv3 or later
 * Text Domain:       vonseo
 * Domain Path:       /languages
 */

if (!defined('ABSPATH')) exit;

define('VONSEOWP_VERSION', '2.1.9');
define('VONSEOWP_PATH', plugin_dir_path(__FILE__));
define('VONSEOWP_URL', plugin_dir_url(__FILE__));


// Include modules
require_once VONSEOWP_PATH . 'includes/class-vonseowp-admin.php';
require_once VONSEOWP_PATH . 'includes/class-vonseowp-meta-box.php';
require_once VONSEOWP_PATH . 'includes/class-vonseowp-frontend.php';

require_once VONSEOWP_PATH . 'includes/class-vonseowp-sitemap.php';
require_once VONSEOWP_PATH . 'includes/class-vonseowp-redirects.php';
require_once VONSEOWP_PATH . 'includes/class-vonseowp-image-seo.php';
require_once VONSEOWP_PATH . 'includes/class-vonseowp-competitors.php';
require_once VONSEOWP_PATH . 'includes/class-vonseowp-indexnow.php';
require_once VONSEOWP_PATH . 'includes/class-vonseowp-cleanup.php';

class VonSEOWP {
    private static $instance = null;

    public static function instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action('plugins_loaded', array($this, 'init'));
        register_activation_hook(__FILE__, array($this, 'activation'));
    }

    public function activation() {
        // Flush rewrite rules for Sitemap
        if (!get_option('vonseowp_flush_sitemap')) {
            add_option('vonseowp_flush_sitemap', true);
        }
    }

    public function init() {
        // Initialize components
        new VonSEOWP_Admin();
        new VonSEOWP_Meta_Box();
        new VonSEOWP_Frontend();
        new VonSEOWP_Sitemap();
        new VonSEOWP_Redirects();
        new VonSEOWP_Image_SEO();
        new VonSEOWP_Competitors(); 
        new VonSEOWP_IndexNow();
        new VonSEOWP_Cleanup();

        // Flush on init if needed
        if (get_option('vonseowp_flush_sitemap')) {
            flush_rewrite_rules();
            delete_option('vonseowp_flush_sitemap');
        }
    }

    public static function get_option($key, $default = '') {
        $options = get_option('vonseowp_settings', array());
        return isset($options[$key]) ? $options[$key] : $default;
    }
}

// Initialize
VonSEOWP::instance();
