<?php
/**
 * XML Sitemap Generator
 */
if (!defined('ABSPATH')) exit;

class VonSEOWP_Sitemap {

    public function __construct() {
        add_action('init', array($this, 'add_rewrite_rules'));
        add_filter('query_vars', array($this, 'add_query_vars'));
        add_action('template_redirect', array($this, 'render_sitemap'));
        add_action('vonseowp_flush_sitemap', 'flush_rewrite_rules');
    }

    public function add_rewrite_rules() {
        add_rewrite_rule('sitemap\.xml$', 'index.php?vonseowp_sitemap=1', 'top');
    }

    public function add_query_vars($vars) {
        $vars[] = 'vonseowp_sitemap';
        return $vars;
    }

    public function render_sitemap() {
        if (get_query_var('vonseowp_sitemap')) {
            $this->output_xml();
            exit;
        }
    }

    private function output_xml() {
        header('Content-Type: application/xml; charset=utf-8');
        echo '<?xml version="1.0" encoding="UTF-8"?>';
        echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';

        // Home
        echo '<url>';
        echo '<loc>' . esc_url(home_url('/')) . '</loc>';
        echo '<priority>1.0</priority>';
        echo '<changefreq>daily</changefreq>';
        echo '</url>';

        // Posts & Pages
        $post_types = array('post', 'page');
        $args = array(
            'post_type' => $post_types,
            'post_status' => 'publish',
            'posts_per_page' => -1,
            'orderby' => 'modified',
            'order' => 'DESC'
        );

        $query = new WP_Query($args);

        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                
                // Check if noindex
                $noindex = get_post_meta(get_the_ID(), '_vonseowp_noindex', true) === '1';
                if ($noindex) continue;

                echo '<url>';
                echo '<loc>' . esc_url(get_permalink()) . '</loc>';
                echo '<lastmod>' . esc_html(get_the_modified_date('c')) . '</lastmod>';
                echo '<priority>' . (is_front_page() ? '1.0' : '0.8') . '</priority>';
                echo '</url>';
            }
            wp_reset_postdata();
        }

        echo '</urlset>';
    }
}
