<?php
/**
 * Per-Post/Page Meta Box for custom SEO
 */
if (!defined('ABSPATH')) exit;

class VonSEOWP_Meta_Box {

    public function __construct() {
        add_action('add_meta_boxes', array($this, 'add_meta_box'));
        add_action('save_post', array($this, 'save_meta_box'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_assets'));
    }

    public function enqueue_assets($hook) {
        if ($hook !== 'post.php' && $hook !== 'post-new.php') return;
        wp_enqueue_media();
        wp_enqueue_style('vonseowp-metabox-css', VONSEOWP_URL . 'admin/css/vonseowp-admin.css', array(), VONSEOWP_VERSION);
        wp_enqueue_style('vonseowp-sidebar-css', VONSEOWP_URL . 'admin/css/vonseowp-sidebar.css', array(), VONSEOWP_VERSION);
        wp_enqueue_style('vonseowp-social-previews-css', VONSEOWP_URL . 'admin/css/vonseowp-social-previews.css', array(), VONSEOWP_VERSION);
        wp_enqueue_script('vonseowp-metabox-js', VONSEOWP_URL . 'admin/js/vonseowp-metabox.js', array('jquery'), VONSEOWP_VERSION, true);
    }

    public function add_meta_box() {
        $screens = array('post', 'page');
        foreach ($screens as $screen) {
            add_meta_box(
                'vonseowp_meta_box',
                '🚀 VonSEO — Content Intelligence',
                array($this, 'render_meta_box'),
                $screen,
                'side',
                'high'
            );
        }
    }

    public function render_meta_box($post) {
        wp_nonce_field('vonseowp_meta_box', 'vonseowp_meta_box_nonce');
        require VONSEOWP_PATH . 'admin/partials/vonseowp-meta-box-display.php';
    }

    public function save_meta_box($post_id) {
        if (!isset($_POST['vonseowp_meta_box_nonce'])) return;
        if (!wp_verify_nonce(sanitize_key(wp_unslash($_POST['vonseowp_meta_box_nonce'])), 'vonseowp_meta_box')) return;
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
        if (!current_user_can('edit_post', $post_id)) return;

        $fields = array('title', 'description', 'keywords', 'image', 'schema_type', 'rating', 'social_title', 'social_desc');
        foreach ($fields as $field) {
            if (isset($_POST['vonseowp_' . $field])) {
                if ($field === 'description') {
                    update_post_meta($post_id, '_vonseowp_' . $field, sanitize_textarea_field(wp_unslash($_POST['vonseowp_' . $field])));
                } else {
                    update_post_meta($post_id, '_vonseowp_' . $field, sanitize_text_field(wp_unslash($_POST['vonseowp_' . $field])));
                }
            }
        }

        $noindex = isset($_POST['vonseowp_noindex']) ? '1' : '0';
        update_post_meta($post_id, '_vonseowp_noindex', $noindex);

        // Save FAQ
        if (isset($_POST['vonseowp_faq']) && is_array($_POST['vonseowp_faq'])) {
            $vonseo_faqs_raw = wp_unslash($_POST['vonseowp_faq']); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
            $faqs = array();
            foreach ($vonseo_faqs_raw as $faq) {
                if (is_array($faq) && !empty($faq['q']) && !empty($faq['a'])) {
                    $faqs[] = array(
                        'q' => sanitize_text_field($faq['q']),
                        'a' => sanitize_textarea_field($faq['a'])
                    );
                }
            }
            update_post_meta($post_id, '_vonseowp_faq', $faqs);
        } else {
            delete_post_meta($post_id, '_vonseowp_faq');
        }

        // Save Video Schema
        if (isset($_POST['vonseowp_video']) && is_array($_POST['vonseowp_video'])) {
            $vonseo_video_raw = wp_unslash($_POST['vonseowp_video']); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
            $video = array(
                'url'  => esc_url_raw($vonseo_video_raw['url'] ?? ''),
                'name' => sanitize_text_field($vonseo_video_raw['name'] ?? ''),
                'desc' => sanitize_textarea_field($vonseo_video_raw['desc'] ?? '')
            );
            if (!empty($video['url'])) {
                update_post_meta($post_id, '_vonseowp_video', $video);
            } else {
                delete_post_meta($post_id, '_vonseowp_video');
            }
        }
    }
}
