<div class="von-dashboard-wrapper">
    <?php if (!defined('ABSPATH')) exit; ?>
    
    <!-- Title Header -->
    <div class="von-header">
        <div class="von-header-left">
            <div class="von-logo">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M13 10V3L4 14h7v7l9-11h-7z" />
                </svg>
                <span>VonSEO</span>
            </div>
            <span class="von-badge-premium">Premium</span>
        </div>
        <div class="von-header-right">
            <a href="https://github.com/Vondereich" target="_blank" class="von-link-help">Help & Support</a>
        </div>
    </div>

    <div class="von-admin-layout">
        <aside class="von-sidebar">
            <nav class="von-tabs-nav">
                <a href="#tab-general" class="von-tab-link active" onclick="openTab(event, 'tab-general')">
                    <span class="dashicons dashicons-admin-settings"></span> General
                </a>
                <a href="#tab-social" class="von-tab-link" onclick="openTab(event, 'tab-social')">
                    <span class="dashicons dashicons-share"></span> Social Media
                </a>
                <a href="#tab-sitemap" class="von-tab-link" onclick="openTab(event, 'tab-sitemap')">
                    <span class="dashicons dashicons-networking"></span> XML Sitemap
                </a>
                <a href="#tab-redirects" class="von-tab-link" onclick="openTab(event, 'tab-redirects')">
                    <span class="dashicons dashicons-randomize"></span> Redirects
                </a>
                <a href="#tab-local" class="von-tab-link" onclick="openTab(event, 'tab-local')">
                    <span class="dashicons dashicons-location"></span> Local SEO
                </a>
                <a href="#tab-image" class="von-tab-link" onclick="openTab(event, 'tab-image')">
                    <span class="dashicons dashicons-format-image"></span> Image SEO
                </a>
                <a href="#tab-tutorial" class="von-tab-link" onclick="openTab(event, 'tab-tutorial')">
                    <span class="dashicons dashicons-welcome-learn-more"></span> Tutorial
                </a>
                <a href="#tab-advanced" class="von-tab-link" onclick="openTab(event, 'tab-advanced')">
                    <span class="dashicons dashicons-admin-tools"></span> Advanced
                </a>
                <a href="#tab-robots" class="von-tab-link" onclick="openTab(event, 'tab-robots')">
                    <span class="dashicons dashicons-index-card"></span> Robots.txt
                </a>
            </nav>

            <!-- Support Card -->
            <div class="von-support-card">
                <h4><span class="dashicons dashicons-heart"></span> Support Us</h4>
                <p>Help keep this plugin free and fast by supporting development.</p>
                <div class="von-center-row">
                    <a href="https://paypal.me/kurama87" target="_blank" class="von-btn-donate">
                        <span class="dashicons dashicons-heart"></span> Support Development
                    </a>
                </div>
            </div>
        </aside>

        <main class="von-main-content">
            <form method="post" action="options.php" class="von-settings-form">
        <?php settings_fields('vonseowp_options_group'); ?>
        <?php $vonseowp_options = get_option('vonseowp_settings'); ?>

        <!-- Tab: General -->
        <div id="tab-general" class="von-tab-content" style="display: block;">
            <div class="von-card">
                <div class="von-card-header">
                    <h3>Site Identity</h3>
                    <p class="von-card-desc">Configure how your site appears in search results.</p>
                </div>
                
                <div class="von-card-body">
                    <div class="von-form-group">
                        <label>Separator Character</label>
                        <select name="vonseowp_settings[separator]" class="von-input von-select">
                            <option value="-" <?php selected($vonseowp_options['separator'] ?? '-', '-'); ?>>- (Dash)</option>
                            <option value="|" <?php selected($vonseowp_options['separator'] ?? '-', '|'); ?>>| (Pipe)</option>
                            <option value="•" <?php selected($vonseowp_options['separator'] ?? '-', '•'); ?>>• (Bullet)</option>
                            <option value="—" <?php selected($vonseowp_options['separator'] ?? '-', '—'); ?>>— (Em Dash)</option>
                        </select>
                        <div class="von-form-desc">Character displayed between post title and site name.</div>
                    </div>

                    <div class="von-form-group">
                        <div class="label-row">
                            <label>Site Title</label>
                            <p class="description" style="margin:0; font-size:12px; color:#666;">Recommended length: ~60 characters.</p>
                        </div>
                        <div class="input-wrap">
                            <input type="text" name="vonseowp_settings[home_title]" id="vonseowp_home_title" value="<?php echo esc_attr($vonseowp_options['home_title'] ?? get_bloginfo('name')); ?>" class="von-input" placeholder="My Awesome Site">
                        </div>
                    </div>

                    <div class="von-form-group">
                        <div class="label-row">
                            <label>Site Tagline</label>
                            <p class="description" style="margin:0; font-size:12px; color:#666;">Describe your site in 1-2 concise sentences.</p>
                        </div>
                        <div class="input-wrap">
                            <textarea name="vonseowp_settings[home_desc]" id="vonseowp_home_desc" class="von-input" rows="3"><?php echo esc_textarea($vonseowp_options['home_desc'] ?? get_bloginfo('description')); ?></textarea>
                        </div>
                        <div class="von-form-desc">Synchronized with WordPress General Settings.</div>
                    </div>
                </div>
            </div>

            <div class="von-card">
                <div class="von-card-header">
                    <h3>Webmaster Tools</h3>
                    <p class="von-card-desc">Verify your site with Google and Bing.</p>
                </div>
                <div class="von-card-body">
                    <div class="von-form-group">
                        <label>Google Verification Code</label>
                        <input type="text" name="vonseowp_settings[google_verify]" value="<?php echo esc_attr($vonseowp_options['google_verify'] ?? ''); ?>" class="von-input">
                    </div>
                    <div class="von-form-group">
                        <label>Bing Verification Code</label>
                        <input type="text" name="vonseowp_settings[bing_verify]" value="<?php echo esc_attr($vonseowp_options['bing_verify'] ?? ''); ?>" class="von-input">
                    </div>
                </div>
            </div>
        </div>

        <!-- Tab: Social -->
        <div id="tab-social" class="von-tab-content" style="display: none;">
            <div class="von-card">
                <div class="von-card-header">
                    <h3>Social Profiles</h3>
                </div>
                <div class="von-card-body">
                    <div class="von-form-group">
                        <label>Facebook URL</label>
                        <input type="url" name="vonseowp_settings[facebook_url]" value="<?php echo esc_attr($vonseowp_options['facebook_url'] ?? ''); ?>" class="von-input">
                    </div>
                    <div class="von-form-group">
                        <label>Twitter Username</label>
                        <input type="text" name="vonseowp_settings[twitter_username]" value="<?php echo esc_attr($vonseowp_options['twitter_username'] ?? ''); ?>" class="von-input" placeholder="@username">
                    </div>
                </div>
            </div>
            
            <div class="von-card">
                <div class="von-card-header">
                    <h3>Open Graph Settings</h3>
                </div>
                <div class="von-card-body">
                    <div class="von-form-group">
                        <label class="von-switch">
                            <input type="checkbox" name="vonseowp_settings[enable_og]" value="1" <?php checked(1, $vonseowp_options['enable_og'] ?? 1); ?>>
                            <span class="von-slider"></span>
                        </label>
                        <span class="von-switch-label">Enable Open Graph Meta Data</span>
                        <div class="von-form-desc">Adds tags for Facebook, LinkedIn, etc.</div>
                    </div>
                    
                    <div class="von-form-group">
                        <label>Default Image URL</label>
                        <input type="url" name="vonseowp_settings[default_image]" value="<?php echo esc_attr($vonseowp_options['default_image'] ?? ''); ?>" class="von-input">
                        <div class="von-form-desc">Used if the post has no featured image.</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tab: Sitemap -->
        <div id="tab-sitemap" class="von-tab-content" style="display: none;">
            <div class="von-card">
                <div class="von-card-header">
                    <h3>XML Sitemap</h3>
                </div>
                <div class="von-card-body">
                    <div class="von-form-group">
                        <label class="von-switch">
                            <input type="checkbox" name="vonseowp_settings[enable_sitemap]" value="1" <?php checked(1, $vonseowp_options['enable_sitemap'] ?? 1); ?>>
                            <span class="von-slider"></span>
                        </label>
                        <span class="von-switch-label">Enable XML Sitemap</span>
                    </div>
                    
                    <div class="von-form-group">
                       <p class="von-sitemap-link">Your sitemap is located at: <a href="<?php echo esc_url(home_url('/sitemap.xml')); ?>" target="_blank" class="von-link"><?php echo esc_html(home_url('/sitemap.xml')); ?></a></p>
                    </div>

                    <h4>Include Post Types</h4>
                    <div class="von-form-group">
                         <label class="von-checkbox-label">
                            <input type="checkbox" name="vonseowp_settings[sitemap_posts]" value="1" <?php checked(1, $vonseowp_options['sitemap_posts'] ?? 1); ?>> 
                            Posts
                         </label>
                         <br>
                         <label class="von-checkbox-label">
                            <input type="checkbox" name="vonseowp_settings[sitemap_pages]" value="1" <?php checked(1, $vonseowp_options['sitemap_pages'] ?? 1); ?>> 
                            Pages
                         </label>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tab: Redirects -->
        <div id="tab-redirects" class="von-tab-content" style="display: none;">
            <div class="von-card">
                <div class="von-card-header">
                     <h3>Redirection Manager</h3>
                     <p class="von-card-desc">Format: <code>/old-url -> /new-url</code> (one per line)</p>
                </div>
                <div class="von-card-body">
                     <div class="von-form-group">
                         <label class="von-switch">
                            <input type="checkbox" name="vonseowp_settings[enable_404_log]" value="1" <?php checked(1, $vonseowp_options['enable_404_log'] ?? 0); ?>>
                            <span class="von-slider"></span>
                        </label>
                        <span class="von-switch-label">Enable 404 Error Logging</span>
                     </div>
                     <div class="von-form-group">
                         <label>Redirect Rules</label>
                         <textarea name="vonseowp_settings[redirects_list]" class="von-input von-code-area" rows="10" placeholder="/old-page -> /new-page"><?php echo esc_textarea($vonseowp_options['redirects_list'] ?? ''); ?></textarea>
                     </div>
                </div>
            </div>

            <?php 
            $vonseowp_logs = get_option('vonseowp_404_log', array());
            if (!empty($vonseowp_logs)): 
            ?>
            <div class="von-card">
                <div class="von-card-header">
                    <h3>Recent 404 Errors</h3>
                </div>
                <div class="von-card-body">
                    <table class="von-table">
                        <thead>
                            <tr>
                                <th>URL</th>
                                <th>Hits</th>
                                <th>Last Seen</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach(array_reverse($vonseowp_logs) as $vonseowp_url => $vonseowp_data): ?>
                            <tr>
                                <td><?php echo esc_html($vonseowp_url); ?></td>
                                <td><?php echo esc_html($vonseowp_data['count']); ?></td>
                                <td><?php echo esc_html($vonseowp_data['last_hit']); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    <p style="margin-top: 10px; font-size: 0.9em; color: #666;">* Showing last 50 unique 404s.</p>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Tab: Local SEO -->
        <div id="tab-local" class="von-tab-content" style="display: none;">
            <div class="von-card">
                <div class="von-card-header">
                    <h3>Local Business Info</h3>
                    <p class="von-card-desc">Populate your Organization Schema with location data.</p>
                </div>
                <div class="von-card-body">
                    <div class="von-form-group">
                        <label>Business Name</label>
                        <input type="text" name="vonseowp_settings[business_name]" value="<?php echo esc_attr($vonseowp_options['business_name'] ?? get_bloginfo('name')); ?>" class="von-input">
                    </div>
                     <div class="von-form-group">
                        <label>Address</label>
                        <input type="text" name="vonseowp_settings[address]" value="<?php echo esc_attr($vonseowp_options['address'] ?? ''); ?>" class="von-input" placeholder="123 SEO Street">
                    </div>
                    <div class="von-form-group">
                        <label>City</label>
                        <input type="text" name="vonseowp_settings[city]" value="<?php echo esc_attr($vonseowp_options['city'] ?? ''); ?>" class="von-input">
                    </div>
                    <div class="von-form-group">
                        <label>State / Province</label>
                        <input type="text" name="vonseowp_settings[state]" value="<?php echo esc_attr($vonseowp_options['state'] ?? ''); ?>" class="von-input">
                    </div>
                    <div class="von-form-group">
                        <label>Zip / Postal Code</label>
                        <input type="text" name="vonseowp_settings[zip]" value="<?php echo esc_attr($vonseowp_options['zip'] ?? ''); ?>" class="von-input">
                    </div>
                    <div class="von-form-group">
                        <label>Country</label>
                        <input type="text" name="vonseowp_settings[country]" value="<?php echo esc_attr($vonseowp_options['country'] ?? ''); ?>" class="von-input" placeholder="US">
                    </div>
                    <div class="von-form-group">
                        <label>Phone Number</label>
                        <input type="text" name="vonseowp_settings[phone]" value="<?php echo esc_attr($vonseowp_options['phone'] ?? ''); ?>" class="von-input">
                    </div>
                </div>
            </div>
        </div>

        <!-- Tab: Image SEO -->
        <div id="tab-image" class="von-tab-content" style="display: none;">
             <div class="von-card">
                <div class="von-card-header">
                    <h3>Image SEO</h3>
                    <p class="von-card-desc">Automatically optimize image attributes.</p>
                </div>
                <div class="von-card-body">
                    <div class="von-form-group">
                         <label class="von-switch">
                            <input type="checkbox" name="vonseowp_settings[auto_image_alt]" value="1" <?php checked(1, $vonseowp_options['auto_image_alt'] ?? 0); ?>>
                            <span class="von-slider"></span>
                        </label>
                        <span class="von-switch-label">Auto-Generate ALT Tags</span>
                        <div class="von-form-desc">Uses filename (e.g., "my-image.jpg" -> "My Image") if ALT is missing.</div>
                     </div>
                     <div class="von-form-group">
                         <label class="von-switch">
                            <input type="checkbox" name="vonseowp_settings[auto_image_title]" value="1" <?php checked(1, $vonseowp_options['auto_image_title'] ?? 0); ?>>
                            <span class="von-slider"></span>
                        </label>
                        <span class="von-switch-label">Auto-Generate Title Tags</span>
                     </div>
                </div>
            </div>
        </div>

        <!-- Tab: Tutorial -->
        <div id="tab-tutorial" class="von-tab-content" style="display: none;">
            <div class="von-card">
                <div class="von-card-header">
                    <h3>🚀 Getting Started with VonSEOWP v2.0</h3>
                    <p class="von-card-desc">Quick guide to master your new premium SEO tools.</p>
                </div>
                <div class="von-card-body">
                    <div class="von-tutorial-grid">
                        <div class="von-tutorial-item">
                            <h4>1. XML Sitemaps</h4>
                            <p>Enable it in the <strong>XML Sitemap</strong> tab. Your sitemap is always at <code>/sitemap.xml</code>. Google will use this to find your content faster.</p>
                        </div>
                        <div class="von-tutorial-item">
                            <h4>2. Redirection Manager</h4>
                            <p>Go to the <strong>Redirects</strong> tab to see 404 errors. Use the format <code>/old-url -> /new-url</code> to fix broken links and keep your SEO juice.</p>
                        </div>
                        <div class="von-tutorial-item">
                            <h4>3. Content Analysis</h4>
                            <p>Open any Post or Page. You'll see a new sidebar/metabox. Enter a <strong>Focus Keyword</strong> to see live SEO scores and improvements.</p>
                        </div>
                        <div class="von-tutorial-item">
                            <h4>4. Local SEO</h4>
                            <p>Fill in your business details in the <strong>Local SEO</strong> tab. This tells Google exactly where your business is located for local search results.</p>
                        </div>
                        <div class="von-tutorial-item">
                            <h4>5. Image SEO</h4>
                            <p>Enable "Auto-Generate ALT Tags" to automatically fix images that are missing descriptions using their filenames.</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="von-tutorial-row">
                <div class="von-card">
                    <div class="von-card-header">
                        <h3>✅ Setup Checklist</h3>
                    </div>
                    <div class="von-card-body">
                        <ul class="von-tutorial-checklist">
                            <li><span>1</span> Set your <strong>Homepage Title & Description</strong>.</li>
                            <li><span>2</span> Verify your site with <strong>Google Webmaster Tools</strong>.</li>
                            <li><span>3</span> Add your <strong>Social Media Profiles</strong>.</li>
                            <li><span>4</span> Enable the <strong>XML Sitemap</strong> for better indexing.</li>
                            <li><span>5</span> Configure <strong>Local Business Info</strong> if you have a physical location.</li>
                        </ul>
                    </div>
                </div>

                <div class="von-card">
                    <div class="von-card-header">
                        <h3>💡 Pro Tips</h3>
                    </div>
                    <div class="von-card-body">
                        <div class="von-pro-tip">
                            <strong>Use Canonical Tags:</strong> VonSEOWP automatically adds self-referencing canonical tags to prevent duplicate content issues.
                        </div>
                        <div class="von-pro-tip">
                            <strong>Monitor 404s Weekly:</strong> Check the Redirects tab regularly to ensure your visitors never hit a dead end.
                        </div>
                        <div class="von-pro-tip">
                            <strong>Alt Text Matters:</strong> Always use descriptive filenames for images. Our Image SEO will turn <code>best-coffee-beans.jpg</code> into <code>Best Coffee Beans</code> automatically!
                        </div>
                    </div>
                </div>
            </div>

            <div class="von-card">
                <div class="von-card-header">
                    <h3>❓ Frequently Asked Questions</h3>
                </div>
                <div class="von-card-body">
                    <div class="von-faq-item">
                        <div class="faq-q">Where is my sitemap?</div>
                        <div class="faq-a">Your sitemap is generated dynamically at <code>/sitemap.xml</code>. No physical file is created, keeping your server clean.</div>
                    </div>
                    <div class="von-faq-item">
                        <div class="faq-q">How do I get a 100/100 SEO Score?</div>
                        <div class="faq-a">Use your focus keyword in the title, first paragraph, and alt tags. Maintain at least 300 words for the best result.</div>
                    </div>
                    <div class="von-faq-item">
                        <div class="faq-q">Will this slow down my site?</div>
                        <div class="faq-a">No. VonSEOWP is built with performance in mind. We use native WordPress meta and options, meaning zero database bloat.</div>
                    </div>
                </div>
            </div>

            <!-- Support Development -->
            <div class="von-card" style="background: linear-gradient(135deg, #fef2f2 0%, #fff1f2 100%); border-color: #fecaca; margin-top: 30px;">
                <div class="von-card-body" style="text-align: center; padding: 40px 30px; display: flex; flex-direction: column; align-items: center;">
                    <h2 style="margin-bottom: 10px; color: #991b1b;">❤️ Support development</h2>
                    <p style="margin-bottom: 25px; color: #7f1d1d; font-size: 16px;">If this plugin helps you, consider supporting the developer to keep adding more magic!</p>
                    <a href="https://paypal.me/kurama87" target="_blank" class="von-btn-donate" style="padding: 15px 40px; font-size: 16px;">
                        <span class="dashicons dashicons-paypal"></span> Support Development via PayPal
                    </a>
                </div>
            </div>
            
        </div>

        <!-- Tab: Advanced -->
        <div id="tab-advanced" class="von-tab-content" style="display: none;">
            <!-- Section: URL Structure -->
            <div class="von-card">
                <div class="von-card-header">
                    <h3>URL Structure & Permalinks</h3>
                    <p class="von-card-desc">Advanced URL manipulation tools. Use with caution.</p>
                </div>
                <div class="von-card-body">
                    <div class="von-form-group">
                        <label class="von-switch">
                            <input type="checkbox" name="vonseowp_settings[remove_category_base]" value="1" <?php checked(1, $vonseowp_options['remove_category_base'] ?? 0); ?>>
                            <span class="von-slider"></span>
                        </label>
                        <span class="von-switch-label">Remove Category Base (Url Stub)</span>
                        <div class="von-form-desc">Removes <code>/category/</code> from category archive URLs. <br><strong>Important:</strong> Go to Settings > Permalinks and just click "Save" after changing this option.</div>
                    </div>
                    
                    <div class="von-form-group">
                         <label class="von-switch">
                            <input type="checkbox" name="vonseowp_settings[redirect_attachments]" value="1" <?php checked(1, $vonseowp_options['redirect_attachments'] ?? 1); ?>>
                            <span class="von-slider"></span>
                        </label>
                        <span class="von-switch-label">Redirect Attachment URLs</span>
                        <div class="von-form-desc">Redirects image attachment pages (e.g. <code>site.com/image-name/</code>) to the parent post. Highly recommended for SEO.</div>
                    </div>
                </div>
            </div>

            <!-- Section: Indexing -->
            <div class="von-card">
                <div class="von-card-header">
                    <h3>Instant Indexing</h3>
                    <p class="von-card-desc">Ping search engines immediately when you publish content.</p>
                </div>
                <div class="von-card-body">
                    <div class="von-form-group">
                        <label class="von-switch">
                            <input type="checkbox" name="vonseowp_settings[enable_indexnow]" value="1" <?php checked(1, $vonseowp_options['enable_indexnow'] ?? 1); ?>>
                            <span class="von-slider"></span>
                        </label>
                        <span class="von-switch-label">Enable IndexNow (Bing & Yandex)</span>
                        <div class="von-form-desc">
                            Automatically notifies search engines about new content. <a href="https://www.indexnow.org/" target="_blank">Learn more</a>.
                            <div style="margin-top: 8px; background: #f1f5f9; padding: 10px; border-radius: 6px; font-size: 0.85em;">
                                <strong>API Key Status:</strong> <span style="color: #16a34a; font-weight: bold;">Active</span><br>
                                <strong>Key:</strong> <code><?php echo esc_html(get_option('vonseowp_indexnow_key', 'Auto-Generated on save')); ?></code>
                            </div>
                        </div>
            </div>
                </div>
            </div>
        </div>

        <!-- Tab: Robots.txt -->
        <div id="tab-robots" class="von-tab-content" style="display: none;">
            <div class="von-card">
                <div class="von-card-header">
                    <h3>Advanced Robots.txt Editor</h3>
                    <p class="von-card-desc">Control how search engine crawlers access your site.</p>
                </div>
                <div class="von-card-body">
                    <div class="von-form-group">
                        <label>Robots.txt Content</label>
                        <textarea name="vonseowp_settings[robots_txt]" id="vonseowp_robots_txt" class="von-input von-code-area" rows="15"><?php 
                            echo esc_textarea($vonseowp_options['robots_txt'] ?? "User-agent: *\nDisallow: /wp-admin/\nAllow: /wp-admin/admin-ajax.php\nDisallow: /wp-login.php\nDisallow: /wp-register.php\nDisallow: /?s=\nDisallow: /search/\nDisallow: /feed/\nDisallow: /comments/feed/\nDisallow: /xmlrpc.php\n\nSitemap: " . home_url('/sitemap.xml')); 
                        ?></textarea>
                        <div class="von-form-desc">This content will override the default WordPress robots.txt output.</div>
                    </div>
                    
                    <div class="von-center-row">
                        <button type="button" class="von-btn-secondary" id="von-reset-robots">
                            <span class="dashicons dashicons-undo"></span> Reset to Recommended (Pro Rules)
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="von-card">
                <div class="von-card-header">
                    <h3>💡 Robots.txt Guide</h3>
                </div>
                <div class="von-card-body">
                    <div class="von-pro-tip">
                        <strong>User-agent: *</strong> means the rule applies to all crawlers.
                    </div>
                    <div class="von-pro-tip">
                        <strong>Disallow: /path/</strong> blocks crawlers from visiting that specific folder.
                    </div>
                    <div class="von-pro-tip">
                        <strong>Sitemap:</strong> helping Google find your sitemap quickly is an SEO best practice.
                    </div>
                </div>
            </div>
        </div>

        <div class="von-form-actions">
            <button type="submit" class="von-btn-primary">Save Changes</button>
        </div>
    </form>
    </main>
</div> <!-- .von-admin-layout -->
</div> <!-- .von-dashboard-wrapper -->

