jQuery(document).ready(function ($) {
  // AI Logic removed per user request (Simplified UI)

  // Tab switching (redundant but safe if inlined script is removed)
  window.openTab = function (evt, tabName) {
    if (evt) evt.preventDefault();
    $(".von-tab-content").hide();
    $(".von-tab-link").removeClass("active");
    $("#" + tabName).show();
    $(evt.currentTarget).addClass("active");
    window.scrollTo({ top: 0, behavior: 'smooth' });
  };
  // --- ROBOTS.TXT RESET ---
  $("#von-reset-robots").on("click", function () {
    if (
      !confirm(
        "Are you sure you want to reset robots.txt to recommended Pro rules?",
      )
    )
      return;

    const home_url =
      typeof vonseo_admin_data !== "undefined"
        ? vonseo_admin_data.home_url
        : window.location.origin;
    const proRules = [
      "User-agent: *",
      "Disallow: /wp-admin/",
      "Allow: /wp-admin/admin-ajax.php",
      "Disallow: /wp-login.php",
      "Disallow: /wp-register.php",
      "Disallow: /?s=",
      "Disallow: /search/",
      "Disallow: /feed/",
      "Disallow: /comments/feed/",
      "Disallow: /xmlrpc.php",
      "",
      "Sitemap: " + home_url + "/sitemap.xml",
    ].join("\n");

    $("#vonseowp_robots_txt").val(proRules);
  });
});
