# VonSEOWP 🚀

**The official SEO engine of the VonCMS ecosystem.**

A premium-grade, ultra-lightweight SEO toolkit ported from the **VonCMS** core. Built for high-performance websites where speed, security, and precision are non-negotiable.

![Version](https://img.shields.io/badge/version-2.1.9-blue.svg)
![License](https://img.shields.io/badge/license-GPLv3-blue.svg)

VonSEOWP eliminates the need for bloated, ad-heavy legacy SEO plugins. We deliver **High-Performance Metadata**, **Smart Schema**, and a **State-of-the-Art UI**—all powered by the same rock-solid architecture that drives VonCMS. No custom database tables. No bloat. Just pure SEO power.

---

## 🌟 Key Features

### 1. Modern Sidebar Meta Box
- **Icon-based Tabs**: Ultra-compact design for a better editing experience.
- **Micro Google Preview**: Real-time search result visualization.
- **AI Magic**: Instant suggestions for titles, descriptions, and keywords.
- **Competitor SEO Math**: Contrast your metrics against top-ranking URLs.

### 2. Advanced SEO Tools
- **Automated XML Sitemaps**: Dynamic `/sitemap.xml` for search engines.
- **Redirection Manager**: One-click 301 redirects & 404 error logging.
- **Smart Schema (JSON-LD)**: Local Business, Review Ratings, and Breadcrumbs.
- **Image SEO**: Auto-optimized ALT and Title tags.

### 3. Professional Performance
- **Zero Database Bloat**: Uses native WordPress `post_meta` and `wp_options`.
- **Air-Tight Security**: audited for XSS, SSRF, and CSRF.
- **Built for Devs**: Hooks and filters available for customization.

## 🛠 Installation

1. Go to **Plugins > Add New** in your WordPress dashboard.
2. Search for **"VonSEO"**.
3. Click **Install Now** and then **Activate**.

## 📦 Updates

Updates are delivered automatically via the **WordPress Plugin Directory**. Simply navigate to **Dashboard > Updates** to get the latest version.

## 📄 License
Licensed under the GPLv3 or later.
