# Changelog

All notable changes to the VonSEOWP plugin will be documented in this file.

## [2.1.9] - Unreleased
### Added
- **Security & Performance**: Added native WP Header Cleanup module to remove unnecessary meta tags like `wp_generator`, `rsd_link`, and `wlwmanifest`.

## [2.1.8] - 2026-02-19
### Added
- **Social Previews**: Real-time Facebook & Twitter card previews in the Meta Box.
- **Social Meta Tags**: Dedicated fields for Social Title, Description, and Image with smart fallbacks.
- **Schema Validator**: Added direct link to `validator.schema.org` for instant structured data testing.
- **UI**: Glassmorphism styling for social preview tabs and character counters.

## [2.1.7] - 2026-02-13
### Security
- **Hardening**: Implemented strict, field-specific sanitization for `register_setting` to meet WordPress.org Plugin Review guidelines.
- **Compliance**: Applied `wp_unslash()` to all input fields before sanitization.
- **Refactor**: Replaced generic sanitization loop with explicit field handling in `class-vonseowp-admin.php`.

## [2.1.5] - 2026-01-31
### Added
- **FAQ Schema**: New repeater in Post Meta Box for generating FAQ JSON-LD Rich Snippets.
- **Video Schema**: New VideoObject schema support for better video indexing.
- **Robots.txt Editor**: Advanced admin tab to control crawler access with "Pro Rules" reset functionality.
### Security
- **Hardening**: Completed 100% PHPCS & WordPress Security compliance audit.
- **Compliance**: Improved data sanitization (unslashing/recursive loops) and variable prefixing.
### Fixed
- **UI**: Corrected Robots.txt layout alignment and enhanced code editor styling.

## [2.1.4] - 2026-01-31
### Improved
- **Offline AI**: Implemented Smart Content Parser to generate distinct Title and Descriptions based on HTML structure (H1/H2 vs Paragraphs).
- **Offline AI**: Added metadata filtering to exclude author credits, photo sources, and separator lines from descriptions.
- **Offline AI**: Added automatic Focus Keyword injection into generated Titles and Descriptions if missing.
- **Offline AI**: Enhanced Dashboard suggestions with randomized templates and Site Tagline integration.
- **Offline AI**: Expanded keyword extraction stopword list for better relevance.

## [2.1.3] - 2026-01-31
### Added
- **IndexNow**: Native support for IndexNow (Bing/Yandex) instant indexing without configuration.
- **Fast Crawl**: Auto-ping search engines on post publish/update.

## [2.1.2] - 2026-01-30
### Security
- **Hardening**: Enhanced escaping and sanitization across Frontend, Sitemap, and Competitors modules.
- **Compliance**: Disabled OTA updater for WordPress.org repository approval.
- **Fix**: Added missing `languages` directory.

## [2.1.1] - 2026-01-30
### Fixed
- **OTA System**: Fixed updater instantiation in the main plugin file.
- **OTA System**: Improved version comparison and cleaning for GitHub tags.
### Added
- OTA Update test release.

## [2.1.0] - 2026-01-30
### Added
- **Competitor Analysis Module**: Real-time "SEO Math" comparison against any URL.
- **AI Magic**: Ultra-compact AI suggestions for Titles, Descriptions, and Keywords.
- **Bi-directional Sync**: Site Title & Tagline synchronized with WP General Settings.
- **Support UI Facelift**: Premium Glassmorphism design with Amber/Gold button.
- **Help & Tutorial Tab**: Integrated quick-start guides and setup checklist.
- **Build System**: Automated versioning and ZIP packaging via Python.

### Fixed
- **Security**: Hardened against XSS (Deep deep audit).
- **Security**: Patched SSRF vulnerability in competitor scanner.
- **Security**: Added proper nonce and capability checks to all AJAX actions.
- **UI**: Fixed `line-clamp` CSS compatibility and button centering.

## [2.0.0] - 2026-01-20
- **NEW**: Full Premium Suite release.
- **NEW**: XML Sitemap Generator (`/sitemap.xml`).
- **NEW**: Redirection Manager with 404 Logging.
- **NEW**: Local SEO & Schema markup support.
- **NEW**: Image SEO (Auto ALT/Title tags).
- **NEW**: Content Analysis in Post Editor.

## [1.13.0]
- **FIX**: Adjusted updater download link to correct package failure.

## [1.12.0]
- **NEW**: Added Auto-Updater directly from GitHub releases.
- **FIX**: Minor stability improvements.

## [1.1.0]
- **NEW**: Complete UI Overhaul - introduced premium dashboard design.
- **FIX**: Resolved PHP Warning "Undefined array key 'site_title'".
- **IMPROVED**: Better spacing and typography in admin panels.

## [1.0.0]
- Initial release.
- Ported core logic from VonCMS v1.9.6.
