<?php
/*
Plugin Name: voNavPilot Lite – Voice Navigation & Accessibility
Plugin URI: https://vonavpilot.com
Description: Basic voice navigation for WordPress. Scroll pages, read text aloud, and toggle simple accessibility features — no setup required.
Version: 1.0.0
Author: HM-IT
Author URI: https://codecanyon.net/user/hm-it
License: GPL-2.0+
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: vonavpilot-lite
*/

if (!defined('ABSPATH')) {
    exit;
}

// Enqueue frontend assets
function vonavpilot_enqueue_assets() {
    $current_lang = function_exists('get_current_lang') ? get_current_lang() : (substr(get_locale(), 0, 2) ?: 'en');
    wp_enqueue_style('vonavpilot-style', plugin_dir_url(__FILE__) . 'assets/css/vonavpilot-lite.min.css', [], '1.0.0');
    wp_enqueue_script('vonavpilot-levenshtein', plugin_dir_url(__FILE__) . 'assets/js/levenshtein.min.js', array(), '5.19.2', true);
    wp_enqueue_script('vonavpilot-fuzzysort', plugin_dir_url(__FILE__) . 'assets/js/fuzzysort.min.js', array(), '3.1.0', true);
    wp_enqueue_script('vonavpilot-noSleep', plugin_dir_url(__FILE__) . 'assets/js/NoSleep.min.js', [], '0.12.0', true);
    wp_enqueue_script('vonavpilot-main', plugin_dir_url(__FILE__) . 'assets/js/vonavpilot-lite.min.js', [], '1.0.0', true);
    wp_localize_script('vonavpilot-main', 'vonavpilotData', [
        'lang' => $current_lang,
        'beepUrl' => plugins_url('assets/mp3/beep.mp3', __FILE__),
        'ajaxUrl' => admin_url('admin-ajax.php'),
        'ajaxNonce' => wp_create_nonce('vonavpilot_nonce')
    ]);
}
add_action('wp_enqueue_scripts', 'vonavpilot_enqueue_assets');

// Register AJAX endpoint for logged-in and public users
add_action('wp_ajax_nopriv_vonavpilot_get', 'vonavpilot_get_data');
add_action('wp_ajax_vonavpilot_get', 'vonavpilot_get_data');

function vonavpilot_get_data() {
    // Unsash and sanitize nonce
    $nonce = isset($_REQUEST['_wpnonce']) ? sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ) : '';
    if (!wp_verify_nonce($nonce, 'vonavpilot_nonce')) {
        wp_send_json_error('Invalid nonce');
    }

    // Unsash and sanitize requested file
    $file = isset($_GET['file']) ? sanitize_text_field( wp_unslash( $_GET['file'] ) ) : '';

    $allowed_files = [
        'vonavpilotLinkCommandsMap.json',
        'vonavpilotLabelsMap.json',
        'vonavpilotSpellingMap.json',
        'vonavpilotStopWords.json',
        'vonavpilotControlCommandsMap.json',
        'vonavpilotLanMap.json',
        'vonavpilotFormCommandsMap.json'
    ];

    if (!in_array($file, $allowed_files, true)) {
        wp_send_json_error('File not allowed');
    }

    $cache_key = 'vonavpilot_json_cache_' . $file;
    $cached_data = get_transient($cache_key);
    if ($cached_data !== false) {
        wp_send_json_success(json_decode($cached_data));
    }

    $path = plugin_dir_path(__FILE__) . "assets/json/$file";
    if (!file_exists($path)) {
        wp_send_json_error('File not found');
    }
    $data = file_get_contents($path);
    $json = json_decode($data, true);
    set_transient($cache_key, $data, DAY_IN_SECONDS);
    wp_send_json_success($json);
}
