=== voNavPilot Lite – Voice Navigation & Accessibility ===
Contributors: hmosahebi
Tags: accessibility, voice navigation, tts, hands-free, multilingual
Requires at least: 5.6
Tested up to: 6.8
Stable tag: 1.0.0
Requires PHP: 7.4
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Donate link: https://www.paypal.com/donate/?hosted_button_id=QWGGAHSBHHE4Y

Short Description: Hands-free voice navigation and accessibility plugin for websites.


## Source Code

The unminified, human-readable source code for all JavaScript and CSS used in this plugin is included in the `/source` directory.
These source files were manually minified and/or obfuscated to create the optimized versions located in the `/assets/` directory. No automated build tools (e.g., Webpack, Gulp) were used in this process.

## What Is voNavPilot?

voNavPilot©2025 lets users navigate your site using voice commands. With just one key press, visitors can control everything hands-free — no mouse or keyboard needed. Designed for accessibility and ease of use, the plugin supports voice-activated actions like scrolling, clicking, reading content, and switching languages, making your site more inclusive and user-friendly. The initial version focuses on essential features for seamless website navigation.

## How It Works

voNavPilot© introduces seamless, voice-driven navigation. When your site loads, it welcomes users with a voice prompt: "Welcome to voNavPilot©, your voice navigation assistant. Press any key to start voice control." A single key press starts hands-free browsing. The plugin uses a dynamic command engine to respond to voice input for scrolling, opening links, filling forms, and triggering accessibility features like zooming, grayscale mode, or reading content aloud. Commands are customizable in five major languages—English, German, French, Spanish, and Italian.

Under the hood, voNavPilot© uses:
- **fuzzysort v3.1.0** – Fast fuzzy string sorting
- **Levenshtein 2.0.6** – String similarity detection
- **NoSleep v0.12.0** – Keeps the device awake during use

## Ideal For

- Site owners aiming for accessibility and modern UX
- Public institutions, museums, educational and healthcare platforms
- Anyone seeking voice navigation without coding or external APIs

## Feature Highlights

- **One-Key Start** – Activate voice control with a single key press
- **Hands-Free Page Control** – Scroll, open links, jump to top/bottom, refresh, and go back
- **Voice-Based Form Completion** – Field navigation, spelling mode, reCAPTCHA detection
- **Contact Triggers** – mailto: opens email, tel: opens calling app
- **Multilingual Switching** – Change site language by voice
- **Zoom Controls** – Zoom in/out or reset zoom
- **Visual Accessibility Modes** – High Contrast, Grayscale, Simple View
- **Image Visibility** – Show/hide images by voice
- **Cookie Banner Control** – Hide/show cookie notices by voice
- **Text-to-Speech (TTS)** – Read page content aloud, including image titles or ALT text
- **Fully Browser-Based** – No external APIs required
- **No Database Needed** – Works without database setup
- **Language Flexibility** – English, German, French, Spanish, Italian

## Admin Dashboard Features

- Visual Design & TTS Settings – Customize bot name, widget position, margins, and TTS speed
- Dynamic Button Colors – Match button to site theme
- Labels and Translations Management – Customize texts in five languages
- Open Link Voice Commands – Configure link-opening commands
- Control Commands Configuration – Add or adjust site-control commands
- Form Filling Voice Commands – Manage voice-driven form completion
- Spelling Map Editor – Customize phonetic spellings

## Accessibility

- **Motor Impairments** – Full navigation via voice
- **Low Vision** – TTS and multiple contrast modes
- **Cognitive Challenges** – Simple interface, minimal distractions, spoken feedback

## Tech Requirements & Browser Compatibility

- WordPress 5.6 or higher
- PHP 7.4+ (recommended 8.0+)
- Modern browser with voice recognition support
- JavaScript enabled
- TTS required (browser-supported)
- ★★★ Edge: Best experience
- ★★☆ Chrome: Most features work; TTS may vary on mobile
- ☆☆☆ Firefox: Not supported (no speech recognition)
- iOS Safari/Chrome: Limited voice navigation due to restrictions; best on desktop

## Demo

https://vonavpilot.com

## Frequently Asked Questions
For detailed FAQs, please visit: [voNavPilot FAQ](https://vonavpilot.com/faq/)

## Screenshots
1. Plugin widget and voice activation interface  
   [See workflow and screenshots](https://vonavpilot.com/workflow/)

## Changelog
### 1.0.0
* Initial release of voNavPilot©2025
* Supports voice navigation, TTS, accessibility modes, multilingual control
* Browser-based, no external API or database required

## Upgrade Notice
### 1.0.0
Initial release. No previous versions.