<?php
/**
 * Plugin Name: Voidek SERP Schema Builder
 * Description: A plugin to manage product schema with advanced features like dynamic data integration, variations, stock updates, and reviews.
 * Version: 1.0.8
 * Author: Voidek Webolutions
 * Requires at least: 5.0
 * Tested up to: 6.9
 * Requires PHP: 7.4
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: voidek-serp-schema-builder
 */

/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


	// Define constants.
	define( 'VSERPB_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
	define( 'VSERPB_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
	$vserpb_settings = get_option( 'vserpb_product_schema', array() );
/**
 * Main Plugin Class.
 */
class Vserpb_Product_Schema_Manager {

	/**
	 * Initialize the plugin.
	 */
	public static function init() {
		//add_action( 'plugins_loaded', array( __CLASS__, 'vserpb_check_woocommerce' ) );
		add_action( 'wp_head', array( __CLASS__, 'vserpb_output_product_schema' ) );
		add_action( 'wp_head', array( __CLASS__, 'vserpb_output_article_schema' ) );
		
			add_action( 'wp_head', array( __CLASS__, 'vserpb_output_review_schema' ) );
	}



	/**
	 * Check if WooCommerce is active
	 */
	public static function vserpb_check_woocommerce() {
		if ( ! class_exists( 'WooCommerce' ) ) {
			add_action( 'admin_notices', array( __CLASS__, 'vserpb_woocommerce_missing_notice' ) );
			deactivate_plugins( plugin_basename( __FILE__ ) );
		}
	}

	/**
	 * Admin notice if WooCommerce is missing
	 */
	public static function vserpb_woocommerce_missing_notice() {
		echo '<div class="notice notice-error"><p>' . esc_html__( 'voidek-serp-schema-builder requires WooCommerce to be installed and activated.', 'voidek-serp-schema-builder' ) . '</p></div>';
	}

	/**
	 * Output product schema in the header
	 */
	public static function vserpb_output_product_schema() {
		$vserpb_settings = get_option( 'vserpb_product_schema', array() );
		if ( class_exists( 'WooCommerce' ) && is_product() &&  $vserpb_settings['vserpb_enable_schema'] ) {
			global $post;
			$product_id = $post->ID;
			
			$schema     = Vserpb_Product_Schema::vserpb_generate_schema( $product_id );
	
			echo '<script type="application/ld+json" class="Vserpb-schema-product">' . wp_json_encode( $schema ) . '</script>';
		}
	}

	/**
	 * vserpb_output_article_schema
	 *
	 * @return void
	 */
	public static function vserpb_output_article_schema() {
		$vserpb_settings = get_option( 'vserpb_product_schema', array() );

		if ( $vserpb_settings['asm_enable_schema'] ) {

			global $post;
			$post_id = $post->ID;
				if ( $post_id && in_array( get_post_type( $post_id ), array( 'post' ), true ) ) {
					
				$schema     = Vserpb_Article_Schema::vserpb_generate_schema( $post_id );
				echo '<script type="application/ld+json"class="Vserpb-article-schema">' . wp_json_encode( $schema ) . '</script>';	
				
			}		
		}
	}




	/**
	 * vserpb_output_review_schema
	 *
	 * @return void
	 */
	public static function vserpb_output_review_schema() {
		
		$vserpb_settings = get_option( 'vserpb_product_schema', array() );

		if ( empty( $vserpb_settings['rsm_enable_schema'] ) ) {
			return;
		}

		if ( ! is_singular( 'product' ) ) {
			return; 
		}

		global $post;

		if ( ! $post || get_post_type( $post->ID ) !== 'product' ) {
			return;
		}

		$product_id       = $post->ID;
		$publication_spec = new VSERPB_Review_Schema( $product_id );
		$schema           = $publication_spec->vserpb_generate_schema();

		if ( empty( $schema ) || ! is_array( $schema ) ) {
			return;
		}

		echo '<script type="application/ld+json" class="Vserpb-Review-schema">'
			. wp_json_encode( $schema, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES )
			. '</script>';
		}
	
}


// Initialize the plugin
Vserpb_Product_Schema_Manager::init();

// Include necessary files

require_once VSERPB_PLUGIN_DIR . 'classes/class-vserpb-product-schema.php';
require_once VSERPB_PLUGIN_DIR . 'classes/class-vserpb-article-schema.php';
require_once VSERPB_PLUGIN_DIR . 'classes/class-vserpb-admin-settings.php';
require_once VSERPB_PLUGIN_DIR . 'classes/class-vserpb-ajax-handler.php';
require_once VSERPB_PLUGIN_DIR . 'classes/class-vserpb-review-schema.php';
require_once VSERPB_PLUGIN_DIR . 'classes/class-vserpb-license-manager.php';

add_action( 'admin_menu', function () {
    // Only show if PRO plugin is active
    if ( ! defined( 'VSERPB_PRO_SCHEMA_DIR' ) ) {
        return;
    }
    add_submenu_page(
        'voidek-serp-schema-builder',   // PARENT MENU SLUG (your main page)
        'Licenses',                      // Page title
        'Licenses',                      // Menu label
        'manage_options',                // Capability
        'vserpb-licenses',               // Submenu slug
        [ VSRPB_License_Manager::class, 'render_page' ] // Callback
    );

});


add_action('admin_init', [ VSRPB_License_Manager::class, 'handle_form' ] );
