<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
require_once VSERPB_PLUGIN_DIR . '/Schema_classes/class-vserpb-aggregaterating.php';
require_once VSERPB_PLUGIN_DIR . '/Schema_classes/class-vserpb-product.php';
require_once VSERPB_PLUGIN_DIR . '/Schema_classes/class-vserpb-thing.php';
require_once VSERPB_PLUGIN_DIR . '/Schema_classes/class-vserpb-person.php';
require_once VSERPB_PLUGIN_DIR . '/Schema_classes/class-vserpb-comment.php';
require_once VSERPB_PLUGIN_DIR . '/Schema_classes/class-vserpb-organization.php';
require_once VSERPB_PLUGIN_DIR . '/Schema_classes/class-vserpb-keyword.php';
class VSERPB_Review_Schema {

	
	/**
	 * __construct
	 *
	 * @param  mixed $post_id
	 * @return void
	 */
	public function __construct( $post_id ) {
		$this->post_id = $post_id;
	}
	
	/**
	 * vserpb_generate_schema
	 *
	 * @return void
	 */
	public function vserpb_generate_schema() {
		$author_name    = get_the_author_meta( 'display_name', get_post_field( 'post_author', $this->post_id ) );
		
		$product_id = $this->post_id;
		$post_id    = $this->post_id;
		$post_type      = get_post_type( $this->post_id );
		try {

	$product      = new Vserpb_Product( $product_id );
	$itemReviewed = $product->vserpb_getSchema( true ); // <-- add offers here

} catch ( Exception $e ) {

	$itemReviewed = array(
		'@type' => 'Product',
		'name'  => 'Unknown Product'
	);
}

$schema = array(
	'@context'      => 'https://schema.org',
	'@type'         => 'Review',
	'author'        => array(
		'@type' => 'Person',
		'name'  => $author_name,
	),
	'datePublished' => get_the_date( 'c', $this->post_id ),
	'itemReviewed'  => $itemReviewed,
);
	

		// about property start
			$schema['about'] = ( new Vserpb_Thing( $post_id, 'ufaq' ) )->vserpb_getSchema( 'ufaq' );
		// about property start

		// accountablePerson property start
			$Personspecfaq = new Vserpb_Person( $author_name );
			$Person        = $Personspecfaq->vserpb_getSchema();
		if ( ! empty( $Person ) ) {
			$schema['accountablePerson'] = $Person;
		}

		// accountablePerson property end

		// author property start

		if ( ! empty( $Person ) ) {
			$schema['author'] = $Person;
		}
		// author property end

		// comment property start
					$comments = get_comments(
						array(
							'post_id' => $post_id,
							'status'  => 'approve',
							'number'  => 1, // just the first one for schema
						)
					);

				if ( ! empty( $comments ) && $comments[0] instanceof WP_Comment ) {
					$comment_obj = new Vserpb_Comment( $comments[0] );
					$comment     = $comment_obj->vserpb_getSchema();

					if ( ! empty( $comment ) ) {
					$schema['comment'] = $comment;
					}
				}

			$schema['commentCount'] = count( $comments );

		// comment property end

		// contributor property start

		if ( ! empty( $Person ) ) {
			$schema['contributor'] = $Person;
		}
		// contributor property end

		// copyrightHolder property start
			$copyright_name = get_option( 'blogname' );
			$copyright_url  = home_url();
		if ( ! empty( $copyright_name ) && ! empty( $copyright_url ) ) {
			$schema['copyrightHolder'] = ( new Vserpb_Organization( $copyright_name, $copyright_url ) )->vserpb_getSchema();
			$schema['creator']         = ( new Vserpb_Organization( $copyright_name, $copyright_url ) )->vserpb_getSchema();
		}
		// copyrightHolder property end
		// dateCreated/datePublished property start
					$published_date = get_the_date( 'c', $post_id );
					$modified_date  = get_the_modified_date( 'c', $post_id );
		if ( $published_date ) {
			$schema['dateCreated']   = $published_date;
			$schema['datePublished'] = $published_date;
		}
		// dateCreated/datePublished property end

		// dateModified property start
		if ( $modified_date ) {
			$schema['dateModified'] = $modified_date;
		}
		// dateModified property end

		// genre propetry start

			$tags = wp_get_post_tags( $post_id, array( 'fields' => 'names' ) );

		if ( ! empty( $tags ) ) {
			$schema['genre'] = count( $tags ) === 1 ? $tags[0] : $tags;
		}
		// genre Property End

		if ( ! empty( $title ) ) {
			$schema['headline'] = $title;
		}

			$faq_keywords = new Vserpb_keyword( $post_id, 'product_tag' );
		if ( ! empty( $faq_keywords ) ) {
			$schema['keywords'] = $faq_keywords->vserpb_getSchema();
		}
		if ( ! empty( $Person ) ) {
			$schema['maintainer'] = $Person;
		}
		if ( ! empty( $copyright_name ) ) {
			$schema['publisher'] = ( new Vserpb_Organization( $copyright_name, $copyright_url ) )->vserpb_getSchema();
		}


		// description Property end
			$description = wp_strip_all_tags( get_the_excerpt( $post_id ) );
		if ( ! empty( $description ) ) {
			$schema['description'] = $description;
		}
			// description Property end

		// text Property start

		$text_content = apply_filters( 'the_content', get_post_field( 'post_content', $post_id ) );
		$text_content = wp_strip_all_tags( $text_content ); // remove HTML tags
		$text_content = trim( $text_content ); // remove extra whitespace

		if ( ! empty( $text_content ) ) {
			$schema['text']          = $text_content;
			$schema['wordCount'] = str_word_count( $text_content );
		}
		// text Property end

		// thumbnailUrl Property start
			$thumbnail_url = get_the_post_thumbnail_url( $post_id, 'full' );

		if ( ! empty( $thumbnail_url ) ) {
			$schema['thumbnailUrl'] = $thumbnail_url;
		}
		// thumbnailUrl Property end
					// name Property end
					$post_title = get_the_title( $post_id );
		if ( ! empty( $post_title ) ) {
			$schema['name'] = $post_title;
		}
		// name Property end

		return apply_filters( 'vserpb_review_schema_output', $schema, $this->post_id );
	}
}
